/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util.insitu_leaching;

import igentuman.nc.NuclearCraft;
import igentuman.nc.util.insitu_leaching.WorldVeinOres;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;

public class WorldVeinsProvider
implements ICapabilitySerializable<CompoundTag> {
    public static Capability<WorldVeinOres> VEINS_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<WorldVeinOres>(){});
    private WorldVeinOres veinsData = this.createVeinData();
    private final LazyOptional<WorldVeinOres> opt = LazyOptional.of(() -> this.createVeinData());
    public static boolean isTracking = false;
    private Level level;

    public WorldVeinsProvider() {
    }

    public WorldVeinsProvider(Level level) {
        this.level = level;
    }

    public static void attachVeinCapability(AttachCapabilitiesEvent<Level> event) {
        if (!((Level)event.getObject()).m_5776_() && !((Level)event.getObject()).getCapability(VEINS_CAP).isPresent()) {
            event.addCapability(NuclearCraft.rl("veins"), (ICapabilityProvider)new WorldVeinsProvider((Level)event.getObject()));
            isTracking = true;
        }
    }

    public static void stopTracking() {
        isTracking = false;
    }

    public static void startTracking() {
        isTracking = true;
    }

    @Nonnull
    private WorldVeinOres createVeinData() {
        if (this.veinsData == null) {
            this.veinsData = new WorldVeinOres();
        }
        return new WorldVeinOres(this.level);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == VEINS_CAP) {
            return this.opt.cast();
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    public CompoundTag serializeNBT() {
        return this.veinsData.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.veinsData.deserializeNBT(nbt);
    }
}

