/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class CameraUtil {
    public static Vec3 worldToScreenPos(BlockPos pos, float partialTicks) {
        BlockHitResult blockHit;
        Minecraft mc = Minecraft.m_91087_();
        Camera camera = mc.f_91063_.m_109153_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return null;
        }
        Vec3 cameraPos = camera.m_90583_();
        Vec3 blockCenter = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        Vec3 direction = blockCenter.m_82546_(cameraPos);
        BlockHitResult hitResult = level.m_45547_(new ClipContext(cameraPos, blockCenter, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mc.f_91074_));
        if (!(hitResult instanceof BlockHitResult) || !(blockHit = hitResult).m_82425_().equals((Object)pos)) {
            // empty if block
        }
        Vec3 viewPos = blockCenter.m_82546_(cameraPos);
        float fov = ((Integer)mc.f_91066_.m_231837_().m_231551_()).intValue();
        Matrix4f projMatrix = mc.f_91063_.m_253088_((double)fov);
        Matrix4f modelViewMatrix = RenderSystem.getModelViewMatrix();
        Vector4f screenPos = new Vector4f((float)viewPos.f_82479_, (float)viewPos.f_82480_, (float)viewPos.f_82481_, 1.0f);
        screenPos.mul((Matrix4fc)modelViewMatrix);
        screenPos.mul((Matrix4fc)projMatrix);
        if (screenPos.w != 0.0f) {
            float invW = 1.0f / screenPos.w;
            screenPos.set(screenPos.x * invW, screenPos.y * invW, screenPos.z * invW, 1.0f);
            double screenX = ((double)screenPos.x + 1.0) * 0.5 * (double)mc.m_91268_().m_85445_();
            double screenY = (1.0 - (double)screenPos.y) * 0.5 * (double)mc.m_91268_().m_85446_();
            return new Vec3(screenX, screenY, (double)screenPos.z);
        }
        return null;
    }
}

