/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world;

import igentuman.nc.NuclearCraft;
import igentuman.nc.content.materials.Ores;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.world.NCConfiguredFeatures;
import igentuman.nc.world.OrePlacementModifier;
import igentuman.nc.world.ore.NCOre;
import igentuman.nc.world.ore.OreGenerator;
import igentuman.nc.world.placement.HeightmapChunkPlacement;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.registries.RegistryObject;

public class NCPlacedFeatures {
    public static final HashMap<String, ResourceKey<PlacedFeature>> PLACED_FEATURES_KEYS = NCPlacedFeatures.initPlaceFeatures();
    public static final RegistryObject<PlacedFeature> WASTELAND_RUINS_PLACED_FEATURE = Registries.PLACED_FEATURES.register("wasteland_ruins", () -> new PlacedFeature((Holder)NCConfiguredFeatures.CONFIGURED_WASTELAND_RUINS.getHolder().get(), List.of()));

    private static HashMap<String, ResourceKey<PlacedFeature>> initPlaceFeatures() {
        HashMap<String, ResourceKey<PlacedFeature>> map = new HashMap<String, ResourceKey<PlacedFeature>>();
        for (String name : Ores.all().keySet()) {
            map.put(name, NCPlacedFeatures.registerKey(name + "_placed"));
            map.put(name + "_wasteland", NCPlacedFeatures.registerKey(name + "_wasteland_placed"));
        }
        for (String name : List.of("uranium", "thorium")) {
            map.put(name + "_additional_wasteland", NCPlacedFeatures.registerKey(name + "_additional_wasteland_placed"));
        }
        map.put("glowing_mushroom", NCPlacedFeatures.registerKey("glowing_mushroom_placed"));
        map.put("glowing_mushroom_wasteland", NCPlacedFeatures.registerKey("glowing_mushroom_wasteland_placed"));
        map.put("wasteland_ruins", NCPlacedFeatures.registerKey("wasteland_ruins"));
        map.put("wasteland_portal", NCPlacedFeatures.registerKey("wasteland_portal"));
        map.put("wasteland_boss_lair", NCPlacedFeatures.registerKey("wasteland_boss_lair"));
        map.put("wasteland_surface", NCPlacedFeatures.registerKey("wasteland_surface"));
        return map;
    }

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        NCOre ore;
        HolderGetter configuredFeatures = context.m_255420_(net.minecraft.core.registries.Registries.f_256911_);
        for (String name : Ores.all().keySet()) {
            ore = Ores.all().get(name);
            if (ore.dimensions.contains("minecraft:overworld")) {
                NCPlacedFeatures.register(context, PLACED_FEATURES_KEYS.get(name), configuredFeatures.m_255043_(NCConfiguredFeatures.CONFIGURED_FEATURES.get(name)), OreGenerator.orePlacement(new OrePlacementModifier(name), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().height[0]), (VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().height[1]))));
                NCPlacedFeatures.register(context, PLACED_FEATURES_KEYS.get(name + "_wasteland"), configuredFeatures.m_255043_(NCConfiguredFeatures.CONFIGURED_FEATURES.get(name + "_wasteland")), OreGenerator.orePlacement(new OrePlacementModifier(name), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().height[0]), (VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().height[1]))));
            }
            if (ore.dimensions.contains("minecraft:nether")) {
                NCPlacedFeatures.register(context, PLACED_FEATURES_KEYS.get(name), configuredFeatures.m_255043_(NCConfiguredFeatures.CONFIGURED_FEATURES.get(name)), OreGenerator.orePlacement(new OrePlacementModifier(name), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().height[0]), (VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().height[1]))));
            }
            if (!ore.dimensions.contains("minecraft:the_end")) continue;
            NCPlacedFeatures.register(context, PLACED_FEATURES_KEYS.get(name), configuredFeatures.m_255043_(NCConfiguredFeatures.CONFIGURED_FEATURES.get(name)), OreGenerator.orePlacement(new OrePlacementModifier(name), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().height[0]), (VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().height[1]))));
        }
        for (String name : List.of("uranium", "thorium")) {
            ore = Ores.all().get(name);
            NCPlacedFeatures.register(context, PLACED_FEATURES_KEYS.get(name + "_additional_wasteland"), configuredFeatures.m_255043_(NCConfiguredFeatures.CONFIGURED_FEATURES.get(name + "_additional_wasteland")), OreGenerator.orePlacement(new OrePlacementModifier(name), (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)1), (VerticalAnchor)VerticalAnchor.m_158922_((int)ore.config().height[1]))));
        }
        NCPlacedFeatures.register(context, PLACED_FEATURES_KEYS.get("glowing_mushroom"), configuredFeatures.m_255043_(NCConfiguredFeatures.CONFIGURED_FEATURES.get("glowing_mushroom")), List.of(RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195356_, BiomeFilter.m_191561_()));
        NCPlacedFeatures.register(context, PLACED_FEATURES_KEYS.get("glowing_mushroom_wasteland"), configuredFeatures.m_255043_(NCConfiguredFeatures.CONFIGURED_FEATURES.get("glowing_mushroom_wasteland")), List.of(RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195356_));
        NCPlacedFeatures.register(context, PLACED_FEATURES_KEYS.get("wasteland_ruins"), configuredFeatures.m_255043_(NCConfiguredFeatures.CONFIGURED_FEATURES.get("wasteland_ruins")), List.of(RarityFilter.m_191900_((int)250), HeightmapPlacement.m_191702_((Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG)));
        NCPlacedFeatures.register(context, PLACED_FEATURES_KEYS.get("wasteland_portal"), configuredFeatures.m_255043_(NCConfiguredFeatures.CONFIGURED_FEATURES.get("wasteland_portal")), List.of(RarityFilter.m_191900_((int)400), HeightmapPlacement.m_191702_((Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG)));
        NCPlacedFeatures.register(context, PLACED_FEATURES_KEYS.get("wasteland_boss_lair"), configuredFeatures.m_255043_(NCConfiguredFeatures.CONFIGURED_FEATURES.get("wasteland_boss_lair")), List.of(RarityFilter.m_191900_((int)800), HeightmapPlacement.m_191702_((Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG)));
        NCPlacedFeatures.register(context, PLACED_FEATURES_KEYS.get("wasteland_surface"), configuredFeatures.m_255043_(NCConfiguredFeatures.CONFIGURED_FEATURES.get("wasteland_surface")), List.of(HeightmapChunkPlacement.onHeightmap(Heightmap.Types.WORLD_SURFACE_WG)));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)net.minecraft.core.registries.Registries.f_256988_, (ResourceLocation)NuclearCraft.rl(name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

