/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world.biome;

import igentuman.nc.NuclearCraft;
import igentuman.nc.content.materials.Ores;
import igentuman.nc.setup.registration.WorldGeneration;
import igentuman.nc.world.NCPlacedFeatures;
import igentuman.nc.world.ore.NCOre;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class NCBiomeModifier {
    public static final HashMap<String, ResourceKey<BiomeModifier>> BIOME_MODIFIERS = NCBiomeModifier.initBiomeModifiers();

    private static HashMap<String, ResourceKey<BiomeModifier>> initBiomeModifiers() {
        HashMap<String, ResourceKey<BiomeModifier>> map = new HashMap<String, ResourceKey<BiomeModifier>>();
        for (String name : Ores.all().keySet()) {
            map.put(name, NCBiomeModifier.registerKey(name + "_biome_modifier"));
            map.put(name + "_wasteland", NCBiomeModifier.registerKey(name + "wasteland_biome_modifier"));
        }
        for (String name : List.of("uranium", "thorium")) {
            map.put(name + "_additional_wasteland", NCBiomeModifier.registerKey(name + "_additional_wasteland_biome_modifier"));
        }
        map.put("wasteland_portal", NCBiomeModifier.registerKey("wasteland_portal"));
        map.put("wasteland_boss_lair", NCBiomeModifier.registerKey("wasteland_boss_lair"));
        map.put("glowing_mushroom", NCBiomeModifier.registerKey("glowing_mushroom_biome_modifier"));
        map.put("glowing_mushroom_wasteland", NCBiomeModifier.registerKey("glowing_mushroom_wasteland_biome_modifier"));
        return map;
    }

    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256988_);
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        TagKey everyBiome = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"biomes"));
        for (String name : Ores.registered().keySet()) {
            NCOre ore = Ores.all().get(name);
            if (ore.config().dimensions.contains("minecraft:overworld")) {
                context.m_255272_(BIOME_MODIFIERS.get(name), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(everyBiome), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(NCPlacedFeatures.PLACED_FEATURES_KEYS.get(name))}), GenerationStep.Decoration.UNDERGROUND_ORES));
                context.m_255272_(BIOME_MODIFIERS.get(name + "_wasteland"), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(WorldGeneration.WASTELAND), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(NCPlacedFeatures.PLACED_FEATURES_KEYS.get(name + "_wasteland"))}), GenerationStep.Decoration.UNDERGROUND_ORES));
            }
            if (ore.config().dimensions.contains("minecraft:nether")) {
                context.m_255272_(BIOME_MODIFIERS.get(name), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(BiomeTags.f_207612_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(NCPlacedFeatures.PLACED_FEATURES_KEYS.get(name))}), GenerationStep.Decoration.UNDERGROUND_ORES));
            }
            if (!ore.config().dimensions.contains("minecraft:the_end")) continue;
            context.m_255272_(BIOME_MODIFIERS.get(name), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(BiomeTags.f_215818_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(NCPlacedFeatures.PLACED_FEATURES_KEYS.get(name))}), GenerationStep.Decoration.UNDERGROUND_ORES));
        }
        for (String name : List.of("uranium", "thorium")) {
            context.m_255272_(BIOME_MODIFIERS.get(name + "_additional_wasteland"), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(WorldGeneration.WASTELAND), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(NCPlacedFeatures.PLACED_FEATURES_KEYS.get(name + "_additional_wasteland"))}), GenerationStep.Decoration.UNDERGROUND_ORES));
        }
        context.m_255272_(BIOME_MODIFIERS.get("glowing_mushroom"), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(BiomeTags.f_207612_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(NCPlacedFeatures.PLACED_FEATURES_KEYS.get("glowing_mushroom"))}), GenerationStep.Decoration.UNDERGROUND_DECORATION));
        context.m_255272_(BIOME_MODIFIERS.get("glowing_mushroom_wasteland"), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(WorldGeneration.WASTELAND), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(NCPlacedFeatures.PLACED_FEATURES_KEYS.get("glowing_mushroom_wasteland"))}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(BIOME_MODIFIERS.get("wasteland_portal"), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(WorldGeneration.WASTELAND), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(NCPlacedFeatures.PLACED_FEATURES_KEYS.get("wasteland_portal"))}), GenerationStep.Decoration.SURFACE_STRUCTURES));
        context.m_255272_(BIOME_MODIFIERS.get("wasteland_boss_lair"), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.m_254956_(WorldGeneration.WASTELAND), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedFeatures.m_255043_(NCPlacedFeatures.PLACED_FEATURES_KEYS.get("wasteland_boss_lair"))}), GenerationStep.Decoration.SURFACE_STRUCTURES));
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)NuclearCraft.rl(name));
    }
}

