/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import igentuman.nc.setup.registration.WorldGeneration;
import igentuman.nc.world.placement.NCPlacementModifierTypes;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class HeightmapChunkPlacement
extends PlacementModifier {
    public static final Codec<HeightmapChunkPlacement> CODEC = RecordCodecBuilder.create(p_191701_ -> p_191701_.group((App)Heightmap.Types.f_64274_.fieldOf("heightmap").forGetter(p_191705_ -> p_191705_.heightmap)).apply((Applicative)p_191701_, HeightmapChunkPlacement::new));
    private final Heightmap.Types heightmap;

    private HeightmapChunkPlacement(Heightmap.Types p_191699_) {
        this.heightmap = p_191699_;
    }

    public static HeightmapChunkPlacement onHeightmap(Heightmap.Types pHeightmap) {
        return new HeightmapChunkPlacement(pHeightmap);
    }

    public Stream<BlockPos> m_213676_(PlacementContext pContext, RandomSource pRandom, BlockPos pPos) {
        int chunkOriginX = pPos.m_123341_() & 0xFFFFFFF0;
        int chunkOriginZ = pPos.m_123343_() & 0xFFFFFFF0;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = chunkOriginX; x < chunkOriginX + 16; ++x) {
            for (int z = chunkOriginZ; z < chunkOriginZ + 16; ++z) {
                int height = pContext.m_191824_(this.heightmap, x, z) - 1;
                if (height <= pContext.m_191830_()) continue;
                BlockPos pos = new BlockPos(x, height, z);
                BlockState testBs = pContext.m_191828_(pos);
                if (!pContext.m_191831_().m_204166_(pos).m_203656_(WorldGeneration.WASTELAND) || testBs.m_60713_(Blocks.f_49990_)) continue;
                if (!(testBs.m_204336_(BlockTags.f_13029_) || testBs.m_204336_(BlockTags.f_144274_) || testBs.m_204336_(BlockTags.f_198156_))) {
                    --height;
                }
                positions.add(new BlockPos(x, height, z));
            }
        }
        return positions.stream();
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)NCPlacementModifierTypes.HEIGHTMAP_CHUNK.get();
    }
}

