/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world.structure;

import com.mojang.datafixers.util.Pair;
import igentuman.nc.NuclearCraft;
import igentuman.nc.mixin.TemplatePoolAccess;
import igentuman.nc.util.NcUtils;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nuclearcraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScientistHouseStructure {
    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent ev) {
        if (ev.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
                ScientistHouseStructure.addToPool(NcUtils.rlFromString("minecraft:village/" + biome + "/houses"), NuclearCraft.rl("scientist_house/" + biome), ev.getRegistryAccess());
            }
        }
    }

    private static void addToPool(ResourceLocation poolId, ResourceLocation toAdd, RegistryAccess regAccess) {
        Registry registry = regAccess.m_175515_(Registries.f_256948_);
        StructureTemplatePool pool = Objects.requireNonNull((StructureTemplatePool)registry.m_7745_(poolId), poolId.m_135815_());
        TemplatePoolAccess poolAccess = (TemplatePoolAccess)pool;
        if (!(poolAccess.getRawTemplates() instanceof ArrayList)) {
            poolAccess.setRawTemplates(new ArrayList<Pair<StructurePoolElement, Integer>>(poolAccess.getRawTemplates()));
        }
        SinglePoolElement addedElement = (SinglePoolElement)SinglePoolElement.m_210526_((String)toAdd.toString()).apply(StructureTemplatePool.Projection.RIGID);
        poolAccess.getRawTemplates().add((Pair<StructurePoolElement, Integer>)Pair.of((Object)addedElement, (Object)1));
        poolAccess.getTemplates().add((Object)addedElement);
    }
}

