/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.accelerator.entity;

import dan200.computercraft.shared.Capabilities;
import igentuman.api.nc.multiblock.MultiblockAttachable;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.accelerator.entity.AbstractAcceleratorControllerBE;
import igentuman.nc.block.accelerator.entity.LinearAcceleratorControllerBE;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.block.target_chamber.entity.TargetChamberBeamPortBE;
import igentuman.nc.compat.oc2.FusionReactorDevice;
import igentuman.nc.content.particles.CapabilityParticleStackHandler;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.handler.sided.capability.FluidCapabilityHandler;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.accelerator.AbstractAcceleratorMultiblock;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.util.Equations;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class AcceleratorBeamPortBE
extends NuclearCraftBE
implements MultiblockAttachable {
    public static String NAME = "accelerator_beam_port";
    @NBTField
    public byte analogSignal = 0;
    @NBTField
    public byte comparatorMode = 1;
    @NBTField
    public BlockPos controllerPos;
    protected AbstractAcceleratorMultiblock multiblock;
    public boolean refreshCacheFlag = true;
    public byte validationRuns = 0;
    public LinearAcceleratorControllerBE controller;

    public AcceleratorBeamPortBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)AcceleratorRegistration.ACCELERATOR_BE.get(NAME).get(), pPos, pBlockState);
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    public void setMultiblock(AbstractMultiblock multiblock) {
        this.multiblock = (AbstractAcceleratorMultiblock)multiblock;
    }

    public AbstractAcceleratorMultiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    public boolean canInvalidateCache() {
        return true;
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        super.tickServer();
        if (this.getMultiblock() == null || this.controller() == null) {
            return;
        }
        byte wasSignal = this.analogSignal;
        boolean updated = false;
        this.sendOutPower();
        if (this.controllerPos == null) {
            this.controllerPos = this.controller().m_58899_();
            updated = true;
            this.m_6596_();
        }
        if (this.hasRedstoneSignal()) {
            this.controller().controllerEnabled = true;
        }
        this.updateAnalogSignal();
        updated = wasSignal != this.analogSignal || updated;
        switch (this.comparatorMode) {
            case 5: {
                this.controller().heatRate = this.analogSignal;
                break;
            }
            case 6: {
                this.controller().heatRate = this.analogSignal / 15 * 100;
            }
        }
        Direction dir = this.getFacing();
        if (this.fluidHandler() != null) {
            boolean bl = updated = this.fluidHandler().pullFluids(dir, false, this.f_58858_) || updated;
        }
        if (updated) {
            MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    protected void sendOutPower() {
        for (Direction direction : Direction.values()) {
            this.pullEnergyFromSide(direction);
        }
    }

    private void updateAnalogSignal() {
        if (this.controller() == null) {
            this.analogSignal = 0;
            return;
        }
        switch (this.comparatorMode) {
            case 1: {
                this.analogSignal = (byte)(this.controller().energyStorage().getEnergyStored() * 15 / this.controller().energyStorage().getMaxEnergyStored());
                break;
            }
            case 3: {
                this.analogSignal = (byte)(this.getProgress() / 100.0 * 15.0);
                break;
            }
            case 4: {
                this.analogSignal = (byte)(this.controller().contentHandler().itemHandler.getStackInSlot(0).m_41613_() * 15 / this.controller().contentHandler().itemHandler.getStackInSlot(0).m_41741_());
                break;
            }
            case 5: {
                this.analogSignal = (byte)Math.max(1, this.getRedstoneSignal());
                break;
            }
            case 6: {
                this.analogSignal = (byte)Math.max(1, this.getRedstoneSignal());
            }
        }
    }

    public int getRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_277086_(this.f_58858_);
    }

    protected FluidCapabilityHandler fluidHandler() {
        return this.controller().contentHandler().fluidHandler;
    }

    protected <T> LazyOptional<T> fluidHandler(@Nullable Direction side) {
        return this.controller().contentHandler().getFluidCapability(side);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.controller() == null) {
            return super.getCapability(cap, side);
        }
        if (cap == CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY) {
            return this.controller().getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return LazyOptional.empty();
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return LazyOptional.empty();
        }
        if (ModUtil.isOC2Loaded() && cap == FusionReactorDevice.DEVICE_CAPABILITY) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    public AbstractAcceleratorControllerBE controller() {
        if (NuclearCraft.instance.isNcBeStopped || !this.m_58904_().m_5776_() && this.m_58904_().m_7654_() != null && !this.m_58904_().m_7654_().m_130010_()) {
            return null;
        }
        if (this.m_58904_().f_46443_ && this.controllerPos != null) {
            return (AbstractAcceleratorControllerBE)this.m_58904_().getExistingBlockEntity(this.controllerPos);
        }
        try {
            return (AbstractAcceleratorControllerBE)this.getMultiblock().controller().controllerBE();
        }
        catch (NullPointerException e) {
            if (this.controllerPos != null) {
                return (AbstractAcceleratorControllerBE)this.m_58904_().getExistingBlockEntity(this.controllerPos);
            }
            return null;
        }
    }

    public int getEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyStorage().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyStorage().getMaxEnergyStored();
    }

    public int energyPerTick() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().heatRate;
    }

    public void toggleComparatorMode() {
        this.comparatorMode = (byte)(this.comparatorMode + 1);
        if (this.comparatorMode > 6) {
            this.comparatorMode = 1;
        }
        MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Override
    public FluidTank getFluidTank(int i) {
        if (this.controller() == null) {
            return null;
        }
        return this.controller().getFluidTank(i);
    }

    public double getProgress() {
        if (this.controller() == null) {
            return 0.0;
        }
        return this.controller().recipeInfo().getProgress();
    }

    public void extractParticle(ParticleStack particleStack) {
        if (this.controller() == null || particleStack == null || particleStack.getAmount() <= 0) {
            return;
        }
        Direction facing = this.getFacing();
        BlockPos currentPos = this.f_58858_.m_121945_(facing);
        int maxDistance = 16;
        for (int distance = 0; distance < maxDistance; ++distance) {
            BlockState blockState = this.f_58857_.m_8055_(currentPos);
            if (!blockState.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("particle_beam").get())) {
                TargetChamberBeamPortBE targetPort;
                BlockEntity blockEntity = this.f_58857_.m_7702_(currentPos);
                if (blockEntity instanceof AcceleratorBeamPortBE) {
                    AcceleratorBeamPortBE targetPort2 = (AcceleratorBeamPortBE)blockEntity;
                    if (targetPort2.getFacing() != facing.m_122424_() || targetPort2.controller() == null) break;
                    particleStack.addFocus(-Equations.focusLoss(distance - 1, particleStack));
                    targetPort2.controller().getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, facing.m_122424_()).ifPresent(handler -> handler.reciveParticle(facing.m_122424_(), particleStack));
                    break;
                }
                blockEntity = this.f_58857_.m_7702_(currentPos);
                if (!(blockEntity instanceof TargetChamberBeamPortBE) || (targetPort = (TargetChamberBeamPortBE)blockEntity).getFacing() != facing.m_122424_() || targetPort.controller() == null) break;
                particleStack.addFocus(-Equations.focusLoss(distance - 1, particleStack));
                targetPort.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, facing.m_122424_()).ifPresent(handler -> handler.reciveParticle(facing.m_122424_(), particleStack));
                break;
            }
            currentPos = currentPos.m_121945_(facing);
        }
    }

    public static class SignalSource {
        public static final byte ENERGY = 1;
        public static final byte MASS = 2;
        public static final byte PROGRESS = 3;
        public static final byte ITEMS = 4;
        public static final byte FREQUENCY = 5;
        public static final byte TRANSFORMATION_ENERGY_RATE = 6;
    }
}

