/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity;

import igentuman.api.nc.multiblock.MultiblockAttachable;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.handler.event.client.BlockOverlayHandler;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.util.BlockPosInstance;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.capability.CustomEnergyStorage;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class MultiblockControllerBE
extends NuclearCraftBE
implements MultiblockAttachable<AbstractMultiblock, MultiblockControllerBE> {
    @NBTField
    public int height = 1;
    @NBTField
    public int upgrade_tier = 0;
    @NBTField
    public int width = 1;
    @NBTField
    public int depth = 1;
    @NBTField
    public boolean isCasingValid = false;
    @NBTField
    public boolean isInternalValid = false;
    public boolean refreshCacheFlag = true;
    public byte validationRuns = 0;
    @NBTField
    public int analyzeDelay = 0;
    @NBTField
    public BlockPos bottomLeft = BlockPos.f_121853_;
    @NBTField
    public BlockPos topRight = BlockPos.f_121853_;
    protected AbstractMultiblock multiblock;
    public BlockPos errorBlockPos = BlockPos.f_121853_;
    public ValidationResult validationResult = ValidationResult.INCOMPLETE;
    public boolean controllerEnabled = false;
    @NBTField
    private boolean displayDetailedDataFlag = false;

    public MultiblockControllerBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public int getBaseGTEnergyTier() {
        return 0;
    }

    public int getRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_277086_(this.f_58858_);
    }

    @Override
    public void setMultiblock(AbstractMultiblock multiblock) {
        this.multiblock = multiblock;
    }

    @Override
    public MultiblockControllerBE controller() {
        return this;
    }

    @Override
    public AbstractMultiblock getMultiblock() {
        return this.multiblock;
    }

    @Override
    public boolean canInvalidateCache() {
        return true;
    }

    public void invalidateCache() {
        if (this.m_58904_().m_5776_()) {
            return;
        }
        this.getMultiblock().hasToRefresh = true;
        this.isCasingValid = false;
        this.isInternalValid = false;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public ItemCapabilityHandler getItemInventory() {
        return this.contentHandler().itemHandler;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    @Override
    public SidedContentHandler contentHandler() {
        return this.contentHandler;
    }

    @Override
    public CustomEnergyStorage energyStorage() {
        return this.energyStorage;
    }

    @Override
    public void tickServer() {
        if (this.analyzeDelay > 0) {
            --this.analyzeDelay;
        }
    }

    @Override
    public void tickClient() {
        if (!(this.isCasingValid && this.isInternalValid || this.errorBlockPos.equals((Object)BlockPos.f_121853_))) {
            BlockOverlayHandler.addToOutline(new BlockPosInstance(this.errorBlockPos.m_123341_(), this.errorBlockPos.m_123342_(), this.errorBlockPos.m_123343_()));
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.errorBlockPos = infoTag.m_128441_("erroredBlock") ? BlockPos.m_122022_((long)infoTag.m_128454_("erroredBlock")) : BlockPos.f_121853_;
            this.validationResult = ValidationResult.byId(infoTag.m_128451_("validationId"));
        }
    }

    protected void handleValidation() {
        boolean wasFormed = this.isInternalValid && this.isCasingValid;
        this.getMultiblock().controller().setControllerBe(this);
        this.validationResult = this.getMultiblock().validationResult;
        if (this.errorBlockPos == null || !this.errorBlockPos.equals((Object)this.getMultiblock().errorBlockPos)) {
            this.errorBlockPos = this.getMultiblock().errorBlockPos;
            this.changed = true;
        }
        this.isInternalValid = this.getMultiblock().isInnerValid();
        this.isCasingValid = this.getMultiblock().isOuterValid();
        this.height = this.getMultiblock().height();
        this.width = this.getMultiblock().width();
        this.depth = this.getMultiblock().depth();
        this.trackChanges(wasFormed, this.getMultiblock().isFormed());
    }

    @Override
    public void m_6596_() {
        MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(new BlockPos((Vec3i)this.m_58899_()));
        super.m_6596_();
        this.wasUpdated = true;
        this.changed = true;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            infoTag.m_128405_("validationId", this.validationResult.id);
            if (this.errorBlockPos == null) {
                this.errorBlockPos = BlockPos.f_121853_;
            }
            infoTag.m_128356_("erroredBlock", this.errorBlockPos.m_121878_());
            tag.m_128473_("Info");
            tag.m_128365_("Info", (Tag)infoTag);
        }
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        super.loadClientData(tag);
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            BlockPos tmp = BlockPos.f_121853_;
            if (infoTag.m_128441_("erroredBlock")) {
                tmp = BlockPos.m_122022_((long)infoTag.m_128454_("erroredBlock"));
            }
            if (!tmp.equals((Object)this.errorBlockPos) && this.f_58857_.m_5776_()) {
                BlockOverlayHandler.removeFromOutline(BlockPosInstance.copy(this.errorBlockPos), true);
            }
            this.errorBlockPos = tmp;
            this.validationResult = ValidationResult.byId(infoTag.m_128451_("validationId"));
        }
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        super.saveClientData(tag);
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            infoTag.m_128405_("validationId", this.validationResult.id);
            if (this.errorBlockPos == null) {
                this.errorBlockPos = BlockPos.f_121853_;
            }
            infoTag.m_128356_("erroredBlock", this.errorBlockPos.m_121878_());
            tag.m_128473_("Info");
            tag.m_128365_("Info", (Tag)infoTag);
        }
    }

    public void runAnalyze() {
        if (this.analyzeDelay > 0) {
            return;
        }
        this.analyzeDelay = 100;
        if (this.getMultiblock() != null) {
            this.getMultiblock().wipeCache();
            this.displayDetailedDataFlag = true;
        }
    }

    public HashMap<String, String> getAnalyzeReport() {
        return new HashMap<String, String>();
    }

    public void updateEnergyTier(int upgradeTier) {
        if (this.energyStorage().getGTOutputAmperage() > 0L) {
            this.energyStorage().setOutputEnergyTier(this.getBaseGTEnergyTier() + upgradeTier);
        }
        if (this.energyStorage().getGTInputAmperage() > 0L) {
            this.energyStorage().setInputEnergyTier(this.getBaseGTEnergyTier() + upgradeTier);
        }
        this.m_6596_();
    }
}

