/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import igentuman.api.nc.SideModeToggleable;
import igentuman.nc.client.sound.SoundHandler;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.handler.CatalystHandler;
import igentuman.nc.handler.UpgradesHandler;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.RecipeInfo;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.util.BlockPosInstance;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.capability.CustomEnergyStorage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class NuclearCraftBE
extends BlockEntity {
    protected final String name;
    protected BlockPosInstance bePos;
    protected boolean changed;
    protected SoundInstance currentSound;
    protected int playSoundCooldown = 0;
    protected UUID playerUID = null;
    public HashMap<Integer, SideModeToggleable.SideMode> sideConfig = new HashMap();
    public SidedContentHandler contentHandler;
    protected CustomEnergyStorage energyStorage;
    public final RecipeInfo recipeInfo;
    public UpgradesHandler upgradesHandler;
    public CatalystHandler catalystHandler;
    protected NcRecipe recipe;
    protected boolean saveSideMapFlag = true;
    public boolean wasUpdated = true;
    public HashMap<String, NcRecipe> cachedRecipes = new HashMap();
    protected LazyOptional<IEnergyStorage> energy;
    private final List<Field> booleanFields;
    private final List<Field> intFields;
    private final List<Field> intArrayFields;
    private final List<Field> doubleFields;
    private final List<Field> stringFields;
    private final List<Field> stringArrayFields;
    private final List<Field> floatFields;
    private final List<Field> byteFields;
    private final List<Field> longFields;
    private final List<Field> blockPosFields;
    private final List<Field> directionFields;

    public NuclearCraftBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.name = NuclearCraftBE.getName(pBlockState);
        this.directionFields = this.initFields(Direction.class);
        this.booleanFields = this.initFields(Boolean.TYPE);
        this.intFields = this.initFields(Integer.TYPE);
        this.intArrayFields = this.initFields(int[].class);
        this.doubleFields = this.initFields(Double.TYPE);
        this.stringFields = this.initFields(String.class);
        this.stringArrayFields = this.initFields(String[].class);
        this.blockPosFields = this.initFields(BlockPos.class);
        this.floatFields = this.initFields(Float.TYPE);
        this.byteFields = this.initFields(Byte.TYPE);
        this.longFields = this.initFields(Long.TYPE);
        this.recipeInfo = new RecipeInfo();
    }

    protected void sendOutPower() {
        for (Direction direction : Direction.values()) {
            this.transferEnergyToSide(direction);
        }
    }

    protected void pullEnergyFromSide(Direction direction) {
        BlockEntity be = this.f_58857_.getExistingBlockEntity(this.f_58858_.m_121945_(direction));
        if (be == null) {
            return;
        }
        if (ModUtil.isGtLoaded() && GTUtils.isOnlyGTCEUCapEnabled()) {
            return;
        }
        be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).map(handler -> {
            if (handler.canExtract()) {
                int canReceive = this.energyStorage().receiveEnergy(handler.getEnergyStored(), true);
                if (canReceive > 0) {
                    int received = this.energyStorage().receiveEnergy(canReceive, false);
                    handler.extractEnergy(received, false);
                }
                this.m_6596_();
                return true;
            }
            return true;
        });
    }

    protected void transferEnergyToSide(Direction direction) {
        if (this.energyStorage().getEnergyStored() <= 0) {
            return;
        }
        int wasEnergy = this.energyStorage().getEnergyStored();
        BlockEntity be = this.f_58857_.getExistingBlockEntity(this.f_58858_.m_121945_(direction));
        if (be == null) {
            return;
        }
        if (ModUtil.isGtLoaded() && NuclearCraftBE.isGTEUCapEnabled()) {
            GTUtils.transferEU(this, be, this.energyStorage(), direction);
        }
        if (ModUtil.isGtLoaded() && GTUtils.isOnlyGTCEUCapEnabled()) {
            return;
        }
        int extracted = wasEnergy - this.energyStorage().getEnergyStored();
        if (extracted >= this.energyStorage().getMaxExtract()) {
            return;
        }
        int canExtract = this.energyStorage().getMaxExtract() - extracted;
        be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).map(handler -> {
            if (handler.canReceive()) {
                int received = handler.receiveEnergy(Math.min(canExtract, this.energyStorage().getEnergyStored()), false);
                this.energyStorage().consumeEnergy(received);
                this.m_6596_();
                return this.energyStorage().getEnergyStored() > 0;
            }
            return true;
        });
    }

    public long getInputEnergyTier() {
        return 2L;
    }

    public long getOutputEnergyTier() {
        return 2L;
    }

    public SidedContentHandler contentHandler() {
        return this.contentHandler;
    }

    public UpgradesHandler upgradesHandler() {
        return this.upgradesHandler;
    }

    public CatalystHandler catalystHandler() {
        return this.catalystHandler;
    }

    public CustomEnergyStorage energyStorage() {
        return this.energyStorage;
    }

    public BlockEntity blockEntity(BlockPos pos) {
        BlockEntity blockEntity = this.f_58857_.getExistingBlockEntity(pos);
        if (blockEntity == null) {
            blockEntity = this.f_58857_.m_7702_(pos);
        }
        return blockEntity;
    }

    public RecipeInfo recipeInfo() {
        return this.recipeInfo;
    }

    public NcRecipe getRecipe() {
        NcRecipe cachedRecipe = this.getCachedRecipe();
        if (cachedRecipe != null) {
            return cachedRecipe;
        }
        if (!NcRecipeType.ALL_RECIPES.containsKey(this.getName())) {
            return null;
        }
        for (NcRecipe recipe : NcRecipeType.getAllRecipesFor(this.getName(), this.m_58904_())) {
            if (!recipe.test(this.contentHandler())) continue;
            this.addToCache(recipe);
            return recipe;
        }
        return null;
    }

    public NcRecipe getCachedRecipe() {
        String key = this.contentHandler().getCacheKey();
        if (this.cachedRecipes.containsKey(key) && this.cachedRecipes.get(key).test(this.contentHandler())) {
            return this.cachedRecipes.get(key);
        }
        return null;
    }

    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    protected void addToCache(NcRecipe recipe) {
        String key = this.contentHandler().getCacheKey();
        if (this.cachedRecipes.containsKey(key)) {
            this.cachedRecipes.replace(key, recipe);
        } else {
            this.cachedRecipes.put(key, recipe);
        }
    }

    protected void playSound(RegistryObject<SoundEvent> sound, float volume) {
        if (this.m_58901_() || this.currentSound != null && !this.currentSound.m_7904_().equals((Object)((SoundEvent)sound.get()).m_11660_())) {
            SoundHandler.stopTileSound(this.m_58899_());
            this.currentSound = null;
        }
        if (this.currentSound == null || !Minecraft.m_91087_().m_91106_().m_120403_(this.currentSound)) {
            if (this.currentSound != null && this.currentSound.m_7904_().equals((Object)((SoundEvent)sound.get()).m_11660_())) {
                if (!Minecraft.m_91087_().m_91106_().m_120403_(this.currentSound) && SoundHandler.isClientPlayerInRange(this.currentSound)) {
                    this.currentSound = SoundHandler.startTileSound((SoundEvent)sound.get(), SoundSource.BLOCKS, volume, this.f_58857_.m_213780_(), this.m_58899_());
                }
                return;
            }
            this.playSoundCooldown = 20;
            this.currentSound = SoundHandler.startTileSound((SoundEvent)sound.get(), SoundSource.BLOCKS, volume, this.f_58857_.m_213780_(), this.m_58899_());
        }
    }

    public static String getName(BlockState pBlockState) {
        return pBlockState.m_60734_().m_5456_().toString();
    }

    protected void trackChanges(boolean was, boolean now) {
        this.changed = was != now || this.changed;
    }

    protected void trackChanges(boolean was) {
        this.changed = was || this.changed;
    }

    public void saveTagData(CompoundTag tag) {
        try {
            for (Field f : this.blockPosFields) {
                if (f.get((Object)this) == null) continue;
                tag.m_128356_(f.getName(), ((BlockPos)f.get((Object)this)).m_121878_());
            }
            for (Field f : this.directionFields) {
                Direction direction = (Direction)f.get((Object)this);
                if (direction == null) continue;
                tag.m_128359_(f.getName(), direction.m_122433_());
            }
            for (Field f : this.booleanFields) {
                tag.m_128379_(f.getName(), f.getBoolean((Object)this));
            }
            for (Field f : this.intFields) {
                tag.m_128405_(f.getName(), f.getInt((Object)this));
            }
            for (Field f : this.stringFields) {
                String value = (String)f.get((Object)this);
                if (value == null) continue;
                tag.m_128359_(f.getName(), value);
            }
            for (Field f : this.doubleFields) {
                tag.m_128347_(f.getName(), f.getDouble((Object)this));
            }
            for (Field f : this.floatFields) {
                tag.m_128350_(f.getName(), f.getFloat((Object)this));
            }
            for (Field f : this.byteFields) {
                tag.m_128344_(f.getName(), f.getByte((Object)this));
            }
            for (Field f : this.longFields) {
                tag.m_128356_(f.getName(), f.getLong((Object)this));
            }
            for (Field f : this.intArrayFields) {
                int[] array = (int[])f.get((Object)this);
                if (array == null) continue;
                tag.m_128385_(f.getName(), array);
            }
            for (Field f : this.stringArrayFields) {
                String[] stringArray = (String[])f.get((Object)this);
                if (stringArray == null) continue;
                ListTag tagList = new ListTag();
                for (String string : stringArray) {
                    if (string == null) continue;
                    tagList.add((Object)StringTag.m_129297_((String)string));
                }
                tag.m_128365_(f.getName(), (Tag)tagList);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (Objects.requireNonNull(this.m_58904_()).m_5776_()) {
            this.stopSound();
        }
    }

    protected void stopSound() {
        if (this.currentSound == null) {
            return;
        }
        SoundHandler.stopTileSound(this.m_58899_());
        this.currentSound = null;
        this.playSoundCooldown = 0;
    }

    public void readTagData(CompoundTag tag) {
        try {
            for (Field f : this.directionFields) {
                if (!tag.m_128441_(f.getName())) continue;
                f.set((Object)this, Direction.m_122402_((String)tag.m_128461_(f.getName())));
            }
            for (Field f : this.blockPosFields) {
                if (!tag.m_128441_(f.getName())) continue;
                f.set((Object)this, BlockPos.m_122022_((long)tag.m_128454_(f.getName())));
            }
            for (Field f : this.booleanFields) {
                if (!tag.m_128441_(f.getName())) continue;
                f.setBoolean((Object)this, tag.m_128471_(f.getName()));
            }
            for (Field f : this.intFields) {
                if (!tag.m_128441_(f.getName())) continue;
                f.setInt((Object)this, tag.m_128451_(f.getName()));
            }
            for (Field f : this.stringFields) {
                if (!tag.m_128441_(f.getName())) continue;
                f.set((Object)this, tag.m_128461_(f.getName()));
            }
            for (Field f : this.doubleFields) {
                if (!tag.m_128441_(f.getName())) continue;
                f.setDouble((Object)this, tag.m_128459_(f.getName()));
            }
            for (Field f : this.floatFields) {
                if (!tag.m_128441_(f.getName())) continue;
                f.setFloat((Object)this, tag.m_128457_(f.getName()));
            }
            for (Field f : this.byteFields) {
                if (!tag.m_128441_(f.getName())) continue;
                f.setByte((Object)this, tag.m_128445_(f.getName()));
            }
            for (Field f : this.longFields) {
                if (!tag.m_128441_(f.getName())) continue;
                f.setLong((Object)this, tag.m_128454_(f.getName()));
            }
            for (Field f : this.intArrayFields) {
                if (!tag.m_128441_(f.getName())) continue;
                f.set((Object)this, tag.m_128465_(f.getName()));
            }
            for (Field f : this.stringArrayFields) {
                if (!tag.m_128441_(f.getName())) continue;
                ListTag tagList = tag.m_128437_(f.getName(), 8);
                String[] stringArray = new String[tagList.size()];
                for (int i = 0; i < tagList.size(); ++i) {
                    stringArray[i] = tagList.m_128778_(i);
                }
                f.set((Object)this, stringArray);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private List<Field> initFields(Class<?> fieldClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : ((Object)((Object)this)).getClass().getFields()) {
            if (!field.isAnnotationPresent(NBTField.class) || !field.getType().equals(fieldClass)) continue;
            fields.add(field);
        }
        return fields;
    }

    public ItemCapabilityHandler getItemInventory() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void handleSliderUpdate(int buttonId, int ratio) {
    }

    public FluidTank getFluidTank(int i) {
        return (FluidTank)this.contentHandler().fluidHandler.tanks.get(i);
    }

    public void m_6596_() {
        super.m_6596_();
        this.wasUpdated = true;
    }

    private void updateRecipeAfterLoad() {
        if (this.recipe == null && this.recipeInfo() != null && this.recipeInfo().recipe() != null) {
            this.recipe = this.recipeInfo().recipe();
        }
    }

    public static boolean isGTEUCapEnabled() {
        return CommonConfig.GTCEU_CONFIG.COMPATIBILITY.get() == CommonConfig.GTCEUCompatibilityConfig.GTCEUCompatibility.ONLY_GTCEU || CommonConfig.GTCEU_CONFIG.COMPATIBILITY.get() == CommonConfig.GTCEUCompatibilityConfig.GTCEUCompatibility.GTCEU_AND_FE;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (ModUtil.isGtLoaded() && cap == GTCapability.CAPABILITY_ENERGY_CONTAINER && this.energyStorage() != null) {
            if (NuclearCraftBE.isGTEUCapEnabled()) {
                if (side != null && this.sideConfig.get(side.ordinal()) != SideModeToggleable.SideMode.DISABLED) {
                    return GTUtils.getGTEnergy(this, side).cast();
                }
            } else {
                return LazyOptional.empty();
            }
        }
        if (cap == ForgeCapabilities.ENERGY && this.energyStorage() != null) {
            if (CommonConfig.GTCEU_CONFIG.COMPATIBILITY.get() != CommonConfig.GTCEUCompatibilityConfig.GTCEUCompatibility.ONLY_GTCEU) {
                return this.getEnergy().cast();
            }
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && this.contentHandler() != null) {
            return this.contentHandler().getItemCapability(side);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && this.contentHandler() != null) {
            return this.contentHandler().getFluidCapability(side);
        }
        if (ModUtil.isMekanismLoaded() && this.contentHandler() != null) {
            if (cap == Capabilities.GAS_HANDLER) {
                if (this.contentHandler().hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.contentHandler().gasConverter(side));
                }
                return LazyOptional.empty();
            }
            if (cap == Capabilities.SLURRY_HANDLER) {
                if (this.contentHandler().hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.contentHandler().getSlurryConverter(side));
                }
                return LazyOptional.empty();
            }
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.readTagData(infoTag);
            if (infoTag.m_128441_("recipeInfo") && this.recipeInfo() != null) {
                this.recipeInfo().deserializeNBT((Tag)infoTag.m_128469_("recipeInfo"));
            }
            if (infoTag.m_128441_("upgrades") && this.upgradesHandler() != null) {
                this.upgradesHandler().deserializeNBT((CompoundTag)infoTag.m_128423_("upgrades"));
            }
            if (infoTag.m_128441_("catalyst") && this.catalystHandler() != null) {
                this.catalystHandler().deserializeNBT((CompoundTag)infoTag.m_128423_("catalyst"));
            }
        }
        if (tag.m_128441_("Energy") && this.energyStorage() != null) {
            this.energyStorage().deserializeNBT(tag.m_128423_("Energy"));
        }
        if (tag.m_128441_("Content") && this.contentHandler() != null) {
            this.contentHandler().deserializeNBT((Tag)tag.m_128469_("Content"));
        }
        if (tag.m_128441_("energy")) {
            this.energyStorage().setEnergy(tag.m_128451_("energy"));
        }
        super.m_142466_(tag);
        this.updateRecipeAfterLoad();
    }

    public void loadClientData(CompoundTag tag) {
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.readTagData(infoTag);
            if (infoTag.m_128441_("recipeInfo") && this.recipeInfo() != null) {
                this.recipeInfo().deserializeNBT((Tag)infoTag.m_128469_("recipeInfo"));
            }
            if (tag.m_128441_("Energy") && this.energyStorage() != null) {
                this.energyStorage().deserializeNBT(tag.m_128423_("Energy"));
            }
            if (infoTag.m_128441_("energy") && this.energyStorage() != null) {
                this.energyStorage().setEnergy(infoTag.m_128451_("energy"));
            }
            if (infoTag.m_128441_("upgrades") && this.upgradesHandler() != null) {
                this.upgradesHandler().deserializeNBT((CompoundTag)infoTag.m_128423_("upgrades"));
            }
            if (infoTag.m_128441_("catalyst") && this.catalystHandler() != null) {
                this.catalystHandler().deserializeNBT((CompoundTag)infoTag.m_128423_("catalyst"));
            }
        }
        if (tag.m_128441_("Content") && this.contentHandler() != null) {
            this.contentHandler().deserializeNBT((Tag)tag.m_128469_("Content"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        if (this.contentHandler() != null) {
            this.contentHandler().saveSideMap();
        }
        if (!tag.m_128441_("Content") && this.contentHandler() != null) {
            tag.m_128365_("Content", this.contentHandler().serializeNBT());
        }
        if (!tag.m_128441_("Energy") && this.energyStorage() != null && this.energyStorage().wasUpdated) {
            tag.m_128365_("Energy", this.energyStorage().serializeNBT());
        }
        CompoundTag infoTag = new CompoundTag();
        if (this.upgradesHandler() != null) {
            infoTag.m_128365_("upgrades", (Tag)this.upgradesHandler().serializeNBT());
        }
        if (this.catalystHandler() != null) {
            infoTag.m_128365_("catalyst", (Tag)this.catalystHandler().serializeNBT());
        }
        if (this.recipeInfo() != null) {
            infoTag.m_128365_("recipeInfo", this.recipeInfo().serializeNBT());
        }
        if (this.playerUID != null) {
            tag.m_128362_("playerUID", this.playerUID);
        }
        this.saveTagData(infoTag);
        tag.m_128365_("Info", (Tag)infoTag);
    }

    protected void saveClientData(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        if (this.upgradesHandler() != null && this.upgradesHandler().wasUpdated) {
            infoTag.m_128365_("upgrades", (Tag)this.upgradesHandler().serializeNBT());
            this.upgradesHandler().wasUpdated = false;
        }
        if (this.catalystHandler() != null && this.catalystHandler().wasUpdated) {
            infoTag.m_128365_("catalyst", (Tag)this.catalystHandler().serializeNBT());
            this.catalystHandler().wasUpdated = false;
        }
        if (this.recipeInfo() != null) {
            infoTag.m_128365_("recipeInfo", this.recipeInfo().serializeNBT());
        }
        if (this.contentHandler() != null) {
            if (this.saveSideMapFlag) {
                this.contentHandler().saveSideMap();
                this.saveSideMapFlag = false;
            }
            tag.m_128365_("Content", this.contentHandler().serializeNBT());
        }
        if (!tag.m_128441_("Energy") && this.energyStorage() != null && this.energyStorage().wasUpdated) {
            tag.m_128365_("Energy", this.energyStorage().serializeNBT());
        }
        if (this.energyStorage() != null) {
            infoTag.m_128405_("energy", this.energyStorage().getEnergyStored());
        }
        this.saveTagData(infoTag);
        tag.m_128365_("Info", (Tag)infoTag);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.saveClientData(tag);
        if (this.playerUID != null) {
            tag.m_128362_("playerUID", this.playerUID);
        }
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag != null) {
            this.loadClientData(tag);
            if (tag.m_128441_("playerUID")) {
                this.playerUID = tag.m_128342_("playerUID");
            }
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public void setPlayer(ServerPlayer player) {
        this.playerUID = player.m_20148_();
    }

    public void tickClient() {
    }

    public void tickServer() {
    }

    public void handleOverVoltage() {
    }
}

