/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.energy;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.setup.registration.NCEnergyBlocks;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.capability.CustomEnergyStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class NCEnergy
extends NuclearCraftBE {
    protected String name;
    public static String NAME;
    public final CustomEnergyStorage energyStorage;
    protected final LazyOptional<IEnergyStorage> energy;

    public NCEnergy(BlockPos pPos, BlockState pBlockState, String name) {
        super((BlockEntityType)NCEnergyBlocks.ENERGY_BE.get(name).get(), pPos, pBlockState);
        this.name = name;
        this.energyStorage = this.createEnergy();
        this.energyStorage.setOutputEnergyTier(this.getOutputEnergyTier()).setInputEnergyTier(this.getInputEnergyTier());
        this.energy = LazyOptional.of(() -> this.energyStorage);
    }

    @Override
    public CustomEnergyStorage energyStorage() {
        return this.energyStorage;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    protected int getEnergyMaxStorage() {
        return 100;
    }

    protected int getEnergyTransferPerTick() {
        return Math.min(this.getEnergyMaxStorage(), this.energyStorage().getEnergyStored());
    }

    private CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(this.getEnergyMaxStorage(), this.getMaxTransfer(), this.getEnergyMaxStorage()){

            @Override
            protected void onEnergyChanged() {
                NCEnergy.this.m_6596_();
            }
        };
    }

    public int getMaxTransfer() {
        return 0;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (ModUtil.isGtLoaded() && cap == GTCapability.CAPABILITY_ENERGY_CONTAINER && NCEnergy.isGTEUCapEnabled()) {
            return GTUtils.getGTEnergy(this, side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            if (!GTUtils.isOnlyGTCEUCapEnabled()) {
                return this.getEnergy().cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.getEnergy().invalidate();
    }
}

