/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.processor;

import dan200.computercraft.shared.Capabilities;
import igentuman.api.nc.Processor;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.ProcessorBlock;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.compat.cc.ProcessorPeripheral;
import igentuman.nc.compat.oc2.ProcessorDevice;
import igentuman.nc.content.processors.ProcessorPrefab;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.handler.CatalystHandler;
import igentuman.nc.handler.UpgradesHandler;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.ProcessorsConfig;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.recipes.AbstractRecipe;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.NCProcessors;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.capability.CustomEnergyStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;

public class NCProcessorBE
extends NuclearCraftBE
implements Processor {
    public String NAME;
    public final SidedContentHandler contentHandler;
    protected final CustomEnergyStorage energyStorage;
    public final HashMap<String, NcRecipe> cachedRecipes = new HashMap();
    public final UpgradesHandler upgradesHandler;
    protected final LazyOptional<IItemHandler> handler;
    public final CatalystHandler catalystHandler;
    public int manualUpdateCounter = 40;
    protected int skippedTicks = 1;
    protected LazyOptional<ProcessorPeripheral> peripheralCap;
    protected final LazyOptional<IEnergyStorage> energy;
    @NBTField
    public int speedMultiplier = 1;
    @NBTField
    public int energyPerTick = 0;
    @NBTField
    public int energyMultiplier = 1;
    @NBTField
    public int redstoneMode = 0;
    @NBTField
    public boolean isActive = false;
    protected List<ItemStack> allowedInputItems;
    protected List<FluidStack> allowedInputFluids;
    protected List<FluidStack> allowedOutputFluids;
    protected ParticleOptions particle1 = ParticleTypes.f_123762_;
    protected ProcessorPrefab<?, ?> prefab;

    @Override
    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    public NCProcessorBE(BlockPos pPos, BlockState pBlockState, String name) {
        super((BlockEntityType)NCProcessors.PROCESSORS_BE.get(name).get(), pPos, pBlockState);
        this.NAME = name;
        this.prefab = Processors.all().get(name);
        this.contentHandler = new SidedContentHandler(this.prefab().getSlotsConfig().getInputItems(), this.prefab().getSlotsConfig().getOutputItems(), this.prefab().getSlotsConfig().getInputFluids(), this.prefab().getSlotsConfig().getOutputFluids(), new int[0]);
        this.contentHandler.setBlockEntity(this);
        this.energyStorage = this.createEnergy();
        this.energyStorage.setInputEnergyTier(((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.PROCESSOR_ENERGY_TIER.get())).ordinal());
        this.energyStorage.setOutputEnergyTier(((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.PROCESSOR_ENERGY_TIER.get())).ordinal());
        this.energy = LazyOptional.of(() -> this.energyStorage);
        this.upgradesHandler = this.createUpgradesHandler();
        this.handler = LazyOptional.of(() -> this.upgradesHandler);
        this.catalystHandler = this.createCatalystHandler();
        this.contentHandler().setAllowedInputItems(this::getAllowedInputItems);
        for (int i = 0; i < this.prefab().getSlotsConfig().getInputFluids(); ++i) {
            this.contentHandler().setAllowedInputFluids(i, this::getAllowedInputFluids);
        }
    }

    @Override
    public void handleOverVoltage() {
        if (((Boolean)CommonConfig.GTCEU_CONFIG.OVERCHARGE_EXPLOSIONS.get()).booleanValue()) {
            this.f_58857_.m_255391_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 2.0f, true, Level.ExplosionInteraction.TNT);
        }
    }

    @Override
    public String getName() {
        return this.NAME;
    }

    @Override
    public SidedContentHandler contentHandler() {
        return this.contentHandler;
    }

    @Override
    public UpgradesHandler upgradesHandler() {
        return this.upgradesHandler;
    }

    @Override
    public CatalystHandler catalystHandler() {
        return this.catalystHandler;
    }

    @Override
    public CustomEnergyStorage energyStorage() {
        return this.energyStorage;
    }

    public ProcessorPrefab<?, ?> prefab() {
        if (this.prefab == null) {
            this.prefab = Processors.all().get(this.getName());
        }
        return this.prefab;
    }

    public <T> LazyOptional<T> getPeripheral(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.peripheralCap == null) {
            this.peripheralCap = LazyOptional.of(() -> new ProcessorPeripheral(this));
        }
        return this.peripheralCap.cast();
    }

    @Override
    public ItemCapabilityHandler getItemInventory() {
        return this.contentHandler().itemHandler;
    }

    @Override
    public void updateRecipe() {
        if (this.recipe != null) {
            if (this.recipe.test(this.contentHandler())) {
                this.recipeInfo().ticksProcessed = 0.0;
                this.recipeInfo().setParallelProcessing(this.parallelRecipes());
                if (this.recipeInfo().consumeInputs(this.contentHandler())) {
                    return;
                }
                this.recipe = null;
                this.recipeInfo().clear();
            } else {
                this.recipeInfo().clear();
            }
        }
        this.recipe = this.getRecipe();
        if (this.recipe != null) {
            this.recipeInfo().setRecipe(this.recipe);
            this.recipeInfo().ticks = (int)((double)this.getBaseProcessTime() * this.recipe.getTimeModifier());
            this.recipeInfo().energy = (double)this.getBasePower() * this.recipe.getEnergy();
            this.recipeInfo().radiation = this.recipeInfo().recipe.getRadiation();
            this.recipeInfo().be = this;
            this.recipeInfo().setParallelProcessing(this.parallelRecipes());
            if (!this.recipeInfo().consumeInputs(this.contentHandler())) {
                this.recipe = null;
                this.recipeInfo().clear();
            }
        } else {
            this.recipeInfo().clear();
        }
    }

    @Override
    protected void addToCache(NcRecipe recipe) {
        String key = this.contentHandler().getCacheKey();
        if (this.cachedRecipes.containsKey(key)) {
            this.cachedRecipes.replace(key, recipe);
        } else {
            this.cachedRecipes.put(key, recipe);
        }
    }

    @Override
    public NcRecipe getRecipe() {
        if (this.isInputEmpty()) {
            return null;
        }
        NcRecipe cachedRecipe = this.getCachedRecipe();
        if (cachedRecipe != null) {
            return cachedRecipe;
        }
        if (!NcRecipeType.ALL_RECIPES.containsKey(this.getName())) {
            return null;
        }
        for (NcRecipe recipe : NcRecipeType.getAllRecipesFor(this.getName(), this.m_58904_())) {
            if (!recipe.test(this.contentHandler())) continue;
            this.addToCache(recipe);
            return recipe;
        }
        return null;
    }

    private boolean isInputEmpty() {
        return this.contentHandler().isInputEmpty();
    }

    @Override
    public NcRecipe getCachedRecipe() {
        String key = this.contentHandler().getCacheKey();
        if (this.cachedRecipes.containsKey(key) && this.cachedRecipes.get(key).test(this.contentHandler())) {
            return this.cachedRecipes.get(key);
        }
        return null;
    }

    @Override
    public int getBaseProcessTime() {
        return this.prefab().config().getTime();
    }

    @Override
    public int getBasePower() {
        return this.prefab().config().getPower();
    }

    @Override
    public void handleRecipeOutput() {
        if (this.hasRecipe() && (this.recipeInfo().isCompleted() || this.recipeInfo().isStuck())) {
            if (this.recipeInfo().handleOutputs(this.contentHandler())) {
                this.recipeInfo().stuck = false;
                this.updateRecipe();
            } else {
                this.recipeInfo().stuck = true;
            }
        }
    }

    public int parallelRecipes() {
        if (!this.prefab().supportSpeedUpgrade) {
            return 1;
        }
        int id = this.prefab().supportEnergyUpgrade ? 1 : 0;
        ItemStack upgrade = this.upgradesHandler().getStackInSlot(id);
        if (upgrade.m_41619_()) {
            return 1;
        }
        if (upgrade.m_150930_((Item)NCItems.NC_ITEMS.get("upgrade_stack").get())) {
            return (int)Math.min(32.0, Math.ceil((double)upgrade.m_41613_() / 4.0));
        }
        return 1;
    }

    public double speedMultiplier() {
        if (!this.prefab().supportSpeedUpgrade) {
            return 1.0;
        }
        int id = this.prefab().supportEnergyUpgrade ? 1 : 0;
        this.speedMultiplier = this.upgradesHandler().getStackInSlot(id).m_41613_() + 1;
        return this.speedMultiplier;
    }

    public int energyPerTick() {
        double energy = this.recipe == null ? 1.0 : this.recipe.getEnergy();
        this.energyPerTick = (int)(energy * (double)this.energyMultiplier() * (double)this.prefab().config().getPower());
        return this.energyPerTick;
    }

    public boolean recipeIsStuck() {
        if (this.recipeInfo().isCompleted() || this.recipeInfo().recipe == null) {
            this.handleRecipeOutput();
        }
        return false;
    }

    @Override
    public boolean hasRecipe() {
        return this.recipeInfo().recipe != null;
    }

    @Override
    public int getEnergyCapacity() {
        return this.prefab().config().getPower() * 5000;
    }

    protected CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(this.getEnergyCapacity(), 1000000000, 0){

            @Override
            protected void onEnergyChanged() {
                NCProcessorBE.this.m_6596_();
            }
        };
    }

    @Override
    public CatalystHandler createCatalystHandler() {
        return new CatalystHandler(this);
    }

    @Override
    public UpgradesHandler createUpgradesHandler() {
        return new UpgradesHandler(this);
    }

    protected boolean gtEUSupported() {
        return (Integer)ProcessorsConfig.PROCESSOR_CONFIG.GT_SUPPORT.get() == 2 || (Integer)ProcessorsConfig.PROCESSOR_CONFIG.GT_SUPPORT.get() == 1;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (Integer)ProcessorsConfig.PROCESSOR_CONFIG.GT_SUPPORT.get() != 2) {
            if (this.prefab().config().getPower() > 0) {
                return this.getEnergy().cast();
            }
            return LazyOptional.empty();
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.getPeripheral(cap, side);
        }
        if (ModUtil.isOC2Loaded() && cap == ProcessorDevice.DEVICE_CAPABILITY) {
            return this.getOCDevice(cap, side);
        }
        return super.getCapability(cap, side);
    }

    private <T> LazyOptional<T> getOCDevice(Capability<T> cap, Direction side) {
        return LazyOptional.of(() -> ProcessorDevice.createDevice(this)).cast();
    }

    @Override
    public void tickClient() {
        if (this.isActive && this.f_58857_.m_213780_().m_188503_(50) < 5) {
            BlockPos pos = this.f_58858_;
            Direction direction = this.getFacing();
            Direction.Axis direction$axis = direction.m_122434_();
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = pos.m_123342_();
            double d2 = (double)pos.m_123343_() + 0.5;
            double d3 = 0.52;
            double d4 = this.f_58857_.m_213780_().m_188500_() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
            double d6 = this.f_58857_.m_213780_().m_188500_() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
            this.f_58857_.m_7106_(this.particle1, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            this.f_58857_.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    public List<ItemStack> getAllowedInputItems() {
        if (this.allowedInputItems == null) {
            this.allowedInputItems = new ArrayList<ItemStack>();
            for (AbstractRecipe abstractRecipe : NcRecipeType.getAllRecipesFor(this.getName(), this.m_58904_())) {
                for (Ingredient ingredient : abstractRecipe.getItemIngredients()) {
                    this.allowedInputItems.addAll(List.of(ingredient.m_43908_()));
                }
            }
        }
        return this.allowedInputItems;
    }

    protected int howMuchICanSkip() {
        if (this.energyPerTick() == 0) {
            return (Integer)ProcessorsConfig.PROCESSOR_CONFIG.SKIP_TICKS.get();
        }
        return Math.min(this.energyStorage().getEnergyStored() / this.energyPerTick, (Integer)ProcessorsConfig.PROCESSOR_CONFIG.SKIP_TICKS.get());
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        if (this.redstoneMode == 1 && !this.hasRedstoneSignal()) {
            return;
        }
        if (this.howMuchICanSkip() >= this.skippedTicks) {
            ++this.skippedTicks;
            return;
        }
        boolean updated = this.forceUpdate();
        boolean wasActive = this.isActive;
        this.processRecipe();
        this.handleRecipeOutput();
        boolean bl = updated = updated || this.contentHandler().tick();
        if (updated || this.wasUpdated) {
            this.energyStorage().setMaxCapacity(this.getEnergyCapacity() * Math.max(1, this.getEnergyUpgrades() / 10));
            if (wasActive != this.isActive) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ProcessorBlock.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)));
            }
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)ProcessorBlock.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)), 1);
        }
        this.skippedTicks = 1;
    }

    public List<FluidStack> getAllowedInputFluids() {
        if (this.allowedInputFluids == null) {
            this.allowedInputFluids = new ArrayList<FluidStack>();
            for (NcRecipe recipe : NcRecipeType.getAllRecipesFor(this.getName(), this.m_58904_())) {
                for (FluidStackIngredient ingredient : recipe.getInputFluids()) {
                    this.allowedInputFluids.addAll(ingredient.getRepresentations());
                }
            }
        }
        return this.allowedInputFluids;
    }

    private boolean forceUpdate() {
        int i;
        if (this.manualUpdateCounter > 0) {
            --this.manualUpdateCounter;
            return false;
        }
        this.manualUpdateCounter = 80;
        this.saveSideMapFlag = true;
        this.energyStorage().wasUpdated = true;
        this.upgradesHandler().wasUpdated = true;
        this.catalystHandler().wasUpdated = true;
        this.contentHandler().setAllowedInputItems(this::getAllowedInputItems);
        for (i = 0; i < this.prefab().getSlotsConfig().getInputFluids(); ++i) {
            this.contentHandler().setAllowedInputFluids(i, this::getAllowedInputFluids);
        }
        for (i = this.prefab().getSlotsConfig().getInputFluids(); i < this.prefab().getSlotsConfig().getOutputFluids() + this.prefab().getSlotsConfig().getInputFluids(); ++i) {
            this.contentHandler().setAllowedInputFluids(i, this::getAllowedOutputFluids);
        }
        return true;
    }

    private List<FluidStack> getAllowedOutputFluids() {
        if (this.allowedOutputFluids == null) {
            this.allowedOutputFluids = new ArrayList<FluidStack>();
            for (NcRecipe recipe : NcRecipeType.getAllRecipesFor(this.getName(), this.m_58904_())) {
                this.allowedOutputFluids.addAll(recipe.getOutputFluids());
            }
        }
        return this.allowedOutputFluids;
    }

    @Override
    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    @Override
    public void processRecipe() {
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (!this.hasRecipe()) {
            this.isActive = false;
            return;
        }
        if (this.energyStorage().getEnergyStored() < this.energyPerTick * this.skippedTicks) {
            this.isActive = false;
            return;
        }
        if (!this.canProcessRecipe()) {
            return;
        }
        this.recipeInfo().process(this.speedMultiplier() * (double)this.skippedTicks);
        if (this.recipeInfo().radiation != 1.0) {
            RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), this.recipeInfo().radiation / 1000000.0 * this.speedMultiplier() * (double)this.skippedTicks, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
        }
        this.isActive = true;
        this.m_6596_();
        if (!this.recipeInfo().isCompleted() && this.hasRecipe()) {
            this.energyStorage().consumeEnergy(this.energyPerTick * this.skippedTicks);
        }
    }

    protected boolean canProcessRecipe() {
        return true;
    }

    public int getEnergyUpgrades() {
        if (!this.prefab().supportEnergyUpgrade) {
            return 1;
        }
        return this.upgradesHandler().getStackInSlot(0).m_41613_() + 1;
    }

    public int energyMultiplier() {
        double speedMult = this.speedMultiplier() + (double)(this.parallelRecipes() - 1) / 2.0;
        this.energyMultiplier = (int)Math.max(speedMult, Math.pow(speedMult - 1.0, 2.0) + speedMult - Math.pow(this.getEnergyUpgrades(), 2.0));
        return this.energyMultiplier;
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.contentHandler().invalidate();
        this.energy.invalidate();
    }

    @Override
    public double getProgress() {
        return this.recipeInfo().getProgress();
    }

    public int toggleSideConfig(int slotId, int direction) {
        this.m_6596_();
        this.saveSideMapFlag = true;
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        return this.contentHandler().toggleSideConfig(slotId, direction);
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public SlotModePair.SlotMode getSlotMode(int direction, int slotId) {
        return this.contentHandler().getSlotMode(direction, slotId);
    }

    @Override
    public FluidTank getFluidTank(int i) {
        return (FluidTank)this.contentHandler().fluidHandler.tanks.get(i);
    }

    public void toggleRedstoneMode() {
        ++this.redstoneMode;
        if (this.redstoneMode > 1) {
            this.redstoneMode = 0;
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public CompoundTag getTagForStack() {
        CompoundTag data = new CompoundTag();
        this.contentHandler().saveSideMap();
        data.m_128365_("Content", this.contentHandler().serializeNBT());
        data.m_128365_("Energy", this.energyStorage().serializeNBT());
        CompoundTag infoTag = new CompoundTag();
        this.saveTagData(infoTag);
        infoTag.m_128365_("upgrades", (Tag)this.upgradesHandler().serializeNBT());
        infoTag.m_128365_("catalyst", (Tag)this.catalystHandler().serializeNBT());
        infoTag.m_128365_("recipeInfo", this.recipeInfo().serializeNBT());
        infoTag.m_128405_("energy", this.energyStorage().getEnergyStored());
        data.m_128365_("Info", (Tag)infoTag);
        return data;
    }

    @Override
    public List<Item> getAllowedCatalysts() {
        return List.of();
    }

    public int getRecipeProgress() {
        if (this.hasRecipe()) {
            return (int)(this.recipeInfo().getProgress() * 100.0);
        }
        return 0;
    }

    public int getSlotsCount() {
        return this.prefab().getSlotsConfig().slotsCount();
    }

    public void voidSlotContent(int id) {
        if (id < 0 || id >= this.getSlotsCount()) {
            return;
        }
        this.contentHandler().voidSlot(id);
    }

    public Object[] getSlotContent(int id) {
        if (id < 0 || id >= this.getSlotsCount()) {
            return new Object[0];
        }
        return this.contentHandler().getSlotContent(id);
    }

    public void voidFluidSlot(int slotId) {
        if (this.contentHandler() != null) {
            this.contentHandler().voidFluidSlot(slotId);
        }
    }

    public void handleFluidItemClick(int slotId, ItemStack stack, ServerPlayer player) {
        if (this.contentHandler() != null) {
            this.contentHandler().handleFluidItemClick(slotId, stack, player);
        }
    }

    public boolean isInputAllowed(ItemStack stack) {
        for (ItemStack allowed : this.getAllowedInputItems()) {
            if (!ItemStack.m_41656_((ItemStack)allowed, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public List<Item> getAllowedItems(int idx) {
        if (this.contentHandler().itemHandler.validItemsForSlot.containsKey(idx)) {
            return this.contentHandler().itemHandler.validItemsForSlot.get(idx);
        }
        ArrayList<Item> allowedItems = new ArrayList<Item>();
        for (ItemStack stack : this.getAllowedInputItems()) {
            allowedItems.add(stack.m_41720_());
        }
        return allowedItems;
    }

    public void upgradesUpdated() {
        int tier = ((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.PROCESSOR_ENERGY_TIER.get())).ordinal() + (this.getEnergyUpgrades() - 1) / (Integer)CommonConfig.GTCEU_CONFIG.ENERGY_UPGRADES_NEEDED_TO_NEXT_TIER.get();
        this.energyStorage().setInputEnergyTier(tier).setOutputEnergyTier(tier);
        this.m_6596_();
    }

    public int getTier() {
        return ((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.PROCESSOR_ENERGY_TIER.get())).ordinal() + (this.getEnergyUpgrades() - 1) / (Integer)CommonConfig.GTCEU_CONFIG.ENERGY_UPGRADES_NEEDED_TO_NEXT_TIER.get();
    }
}

