/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.fission.entity;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import igentuman.api.nc.multiblock.MultiblockAttachable;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.MultiblockControllerBE;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.block.fission.entity.FissionControllerBE;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.compat.oc2.FissionReactorDevice;
import igentuman.nc.handler.sided.capability.FluidCapabilityHandler;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.fission.FissionReactorMultiblock;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FissionPortBE
extends NuclearCraftBE
implements MultiblockAttachable {
    public static final String NAME = "fission_reactor_port";
    @NBTField
    public byte analogSignal = 0;
    @NBTField
    public byte redstoneMode = (byte)2;
    @NBTField
    public BlockPos controllerPos;
    public boolean isSteamMode = false;
    @NBTField
    public boolean connected = false;
    protected FissionReactorMultiblock multiblock;
    protected FissionControllerBE controller;

    public FissionPortBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FissionReactorRegistration.FISSION_BE.get(NAME).get(), pPos, pBlockState);
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    public int getRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_277086_(this.f_58858_);
    }

    public FissionReactorMultiblock getMultiblock() {
        return this.multiblock;
    }

    private boolean updateController() {
        boolean result = false;
        if (this.controller != this.controller()) {
            this.controller = this.controller();
            this.controllerPos = BlockPos.f_121853_;
            result = true;
        }
        if (this.controller != null) {
            this.controllerPos = new BlockPos((Vec3i)this.controller.m_58899_());
            result = true;
        }
        if (this.controller() != null && this.isSteamMode != this.controller().isSteamMode) {
            this.isSteamMode = this.controller().isSteamMode;
            result = true;
        }
        return result;
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        byte wasSignal = this.analogSignal;
        boolean wasConnected = this.connected;
        if (this.getMultiblock() != null && this.controller() != null) {
            this.sendOutPower();
        }
        boolean updated = this.updateController();
        if (this.f_58857_.m_46467_() % 20L == 0L && this.controller() != null) {
            this.pushPull();
        }
        if (this.f_58857_.m_46467_() % 10L == 0L && this.controller() != null) {
            this.updateAnalogSignal();
            updated = wasSignal != this.analogSignal || updated;
            switch (this.redstoneMode) {
                case 5: {
                    this.controller().toggleReactor(this.analogSignal > 0);
                    break;
                }
                case 6: {
                    this.controller().adjustModerator(this.analogSignal);
                }
            }
        }
        boolean bl = this.connected = this.getMultiblock() != null && this.getMultiblock().isFormed();
        if (updated || wasConnected != this.connected) {
            if (this.connected) {
                MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
            }
            this.m_6596_();
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    private boolean pushPull() {
        boolean pushed = false;
        if (this.itemHandler() != null) {
            Direction dir = this.getFacing();
            pushed = this.itemHandler().pushItems(dir, true, this.f_58858_);
            pushed = this.itemHandler().pullItems(dir, true, this.f_58858_) || pushed;
        }
        return pushed;
    }

    private void updateAnalogSignal() {
        switch (this.redstoneMode) {
            case 1: {
                this.analogSignal = (byte)(this.controller().energyStorage().getEnergyStored() * 15 / this.controller().energyStorage().getMaxEnergyStored());
                break;
            }
            case 2: {
                this.analogSignal = (byte)(this.controller().heat * 15.0 / this.controller().getMaxHeat());
                break;
            }
            case 3: {
                this.analogSignal = (byte)(this.controller().recipeInfo().ticksProcessed * 15.0 / (double)this.controller().recipeInfo().ticks);
                break;
            }
            case 4: {
                this.analogSignal = (byte)(this.itemHandler().getStackInSlot(0).m_41613_() * 15 / this.itemHandler().getStackInSlot(0).m_41741_());
                break;
            }
            case 6: {
                this.analogSignal = (byte)Math.max(1, this.getRedstoneSignal());
            }
            case 5: {
                this.analogSignal = (byte)Math.max(0, this.getRedstoneSignal());
            }
        }
    }

    @Override
    protected void transferEnergyToSide(Direction direction) {
        if (this.getEnergyStored() <= 0) {
            return;
        }
        int wasEnergy = this.getEnergyStored();
        BlockEntity be = this.f_58857_.getExistingBlockEntity(this.f_58858_.m_121945_(direction));
        if (be == null || be instanceof FissionPortBE) {
            return;
        }
        if (ModUtil.isGtLoaded() && FissionPortBE.isGTEUCapEnabled()) {
            GTUtils.transferEU(this.controller(), be, this.controller().energyStorage(), direction);
        }
        if (ModUtil.isGtLoaded() && GTUtils.isOnlyGTCEUCapEnabled()) {
            return;
        }
        if (wasEnergy - this.getEnergyStored() >= this.controller().energyStorage().getMaxExtract()) {
            return;
        }
        int extracted = wasEnergy - this.controller().energyStorage().getEnergyStored();
        if (extracted >= this.controller().energyStorage().getMaxExtract()) {
            return;
        }
        int canExtract = Math.min(this.controller().energyStorage().getMaxExtract() - extracted, this.getEnergyStored());
        be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).map(handler -> {
            if (handler.canReceive()) {
                int received = handler.receiveEnergy(canExtract, false);
                this.controller().energyStorage().consumeEnergy(received);
                this.controller().m_6596_();
                return this.getEnergyStored() > 0;
            }
            return true;
        });
    }

    protected ItemCapabilityHandler itemHandler() {
        return this.controller().contentHandler().itemHandler;
    }

    protected FluidCapabilityHandler fluidHandler() {
        return this.controller().contentHandler().fluidHandler;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.controller() == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.controller().getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && this.controller().canAcceptFluid()) {
            return this.controller().getCapability(cap, side);
        }
        if (ModUtil.isGtLoaded() && cap == GTCapability.CAPABILITY_ENERGY_CONTAINER && FissionPortBE.isGTEUCapEnabled() && !this.isSteamMode) {
            return GTUtils.getGTEnergy(this.controller(), side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY && !this.isSteamMode) {
            if (!GTUtils.isOnlyGTCEUCapEnabled()) {
                return this.controller().getEnergy().cast();
            }
            return LazyOptional.empty();
        }
        if (ModUtil.isMekanismLoaded() && this.isSteamMode) {
            if (cap == Capabilities.GAS_HANDLER) {
                if (this.controller().contentHandler().hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.controller().contentHandler().gasConverter(side));
                }
                return LazyOptional.empty();
            }
            if (cap == Capabilities.SLURRY_HANDLER) {
                if (this.controller().contentHandler().hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.controller().contentHandler().getSlurryConverter(side));
                }
                return LazyOptional.empty();
            }
        }
        if (ModUtil.isOC2Loaded() && cap == FissionReactorDevice.DEVICE_CAPABILITY) {
            return this.controller().getOCDevice(cap, side);
        }
        if (ModUtil.isCcLoaded() && cap == dan200.computercraft.shared.Capabilities.CAPABILITY_PERIPHERAL) {
            return this.controller().getPeripheral(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canInvalidateCache() {
        return true;
    }

    public void setMultiblock(AbstractMultiblock multiblock) {
        if (this.multiblock == multiblock) {
            return;
        }
        this.multiblock = (FissionReactorMultiblock)multiblock;
        if (this.multiblock != null) {
            this.controllerPos = this.multiblock.controller().controllerBE().m_58899_();
            this.controller = (FissionControllerBE)this.multiblock.controller().controllerBE();
            MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
            this.m_6596_();
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    public FissionControllerBE controller() {
        block5: {
            MultiblockControllerBE be;
            if (NuclearCraft.instance.isNcBeStopped || !this.m_58904_().m_5776_() && this.m_58904_().m_7654_() != null && !this.m_58904_().m_7654_().m_130010_()) {
                return null;
            }
            if (this.controller == null && this.m_58904_().f_46443_ && this.controllerPos != null && (be = this.m_58904_().getExistingBlockEntity(this.controllerPos)) instanceof FissionControllerBE) {
                FissionControllerBE controllerBe;
                this.controller = controllerBe = (FissionControllerBE)be;
                return this.controller;
            }
            try {
                be = this.getMultiblock().controller().controllerBE();
                if (be instanceof FissionControllerBE) {
                    FissionControllerBE controllerBe;
                    this.controller = controllerBe = (FissionControllerBE)be;
                    return this.controller;
                }
            }
            catch (NullPointerException e) {
                FissionControllerBE controllerBe;
                BlockEntity be2;
                if (this.controllerPos == null || !((be2 = this.m_58904_().getExistingBlockEntity(this.controllerPos)) instanceof FissionControllerBE)) break block5;
                this.controller = controllerBe = (FissionControllerBE)be2;
            }
        }
        return this.controller;
    }

    public int getEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyStorage().getEnergyStored();
    }

    public double getDepletionProgress() {
        if (this.controller() == null) {
            return 0.0;
        }
        return this.controller().getDepletionProgress();
    }

    public int getMaxEnergyStored() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyStorage().getMaxEnergyStored();
    }

    public int energyPerTick() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().energyPerTick;
    }

    public void toggleRedstoneMode() {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode > 6) {
            this.redstoneMode = 1;
        }
        this.analogSignal = 0;
        MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Override
    public FluidTank getFluidTank(int i) {
        if (this.controller() == null) {
            return null;
        }
        return this.controller().getFluidTank(i);
    }

    public boolean isBoilingMode() {
        if (this.controller() == null) {
            return false;
        }
        return this.controller().isSteamMode;
    }

    public int getSteamPerTick() {
        if (this.controller() == null) {
            return 0;
        }
        return this.controller().steamPerTick;
    }

    public static class SignalSource {
        public static final byte ENERGY = 1;
        public static final byte HEAT = 2;
        public static final byte PROGRESS = 3;
        public static final byte ITEMS = 4;
        public static final byte SWITCH = 5;
        public static final byte MODERATOR = 6;
    }
}

