/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.storage;

import igentuman.api.nc.SideModeToggleable;
import igentuman.nc.block.entity.energy.NCEnergy;
import igentuman.nc.block.storage.entity.BatteryBE;
import igentuman.nc.content.energy.BatteryBlocks;
import igentuman.nc.setup.registration.NCEnergyBlocks;
import igentuman.nc.util.StackUtils;
import igentuman.nc.util.TextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BatteryBlock
extends Block
implements EntityBlock {
    public BatteryBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.getExistingBlockEntity(pPos);
        if (blockEntity instanceof BatteryBE) {
            BatteryBE batteryBE = (BatteryBE)blockEntity;
            return (int)((double)batteryBE.energyStorage.getEnergyStored() / (double)batteryBE.energyStorage.getMaxEnergyStored() * 15.0);
        }
        return 0;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity be;
        if (!level.m_5776_() && (be = level.getExistingBlockEntity(pos)) instanceof BatteryBE) {
            BatteryBE batteryBE = (BatteryBE)be;
            if (StackUtils.isMultiTool(player.m_21120_(hand))) {
                Direction dirToChange = result.m_82434_();
                if (player.m_6144_()) {
                    dirToChange = dirToChange.m_122424_();
                }
                SideModeToggleable.SideMode mode = batteryBE.toggleSideConfig(dirToChange.ordinal());
                player.m_213846_((Component)TextUtils.__("message.nc.switch_side.mode", mode.name()));
            } else {
                player.m_213846_((Component)TextUtils.__("tooltip.nc.energy_stored", TextUtils.formatEnergy(batteryBE.energyStorage.getEnergyStored()), TextUtils.formatEnergy(batteryBE.energyStorage.getMaxEnergyStored())).m_130940_(ChatFormatting.BLUE));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.m_60734_() == pNewState.m_60734_() || (blockEntity = pLevel.getExistingBlockEntity(pPos)) instanceof BatteryBE) {
            // empty if block
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)NCEnergyBlocks.ENERGY_BE.get(this.code()).get()).m_155264_(pPos, pState);
    }

    public String code() {
        return this.m_5456_().toString();
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof NCEnergy) {
                    NCEnergy tile = (NCEnergy)t;
                    tile.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof NCEnergy) {
                NCEnergy tile = (NCEnergy)t;
                tile.tickServer();
            }
        };
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        if (stack.m_41782_()) {
            BatteryBE tileEntity = (BatteryBE)world.getExistingBlockEntity(pos);
            CompoundTag nbtData = stack.m_41783_();
            tileEntity.m_142466_(nbtData);
        }
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @javax.annotation.Nullable BlockEntity pBlockEntity, ItemStack pTool) {
        pPlayer.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        pPlayer.m_36399_(0.005f);
        BatteryBE batteryBE = (BatteryBE)pBlockEntity;
        CompoundTag data = batteryBE.m_5995_();
        ItemStack drop = new ItemStack((ItemLike)this);
        drop.m_41751_(data);
        if (!pLevel.m_5776_()) {
            ItemEntity itemEntity = new ItemEntity(pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), drop);
            itemEntity.m_32060_();
            pLevel.m_7967_((Entity)itemEntity);
        }
    }

    public boolean registered() {
        return BatteryBlocks.registered().containsKey(this.code());
    }
}

