/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.storage;

import igentuman.api.nc.SideModeToggleable;
import igentuman.nc.block.storage.entity.ContainerBE;
import igentuman.nc.container.StorageContainerContainer;
import igentuman.nc.content.storage.ContainerBlocks;
import igentuman.nc.setup.registration.NCStorageBlocks;
import igentuman.nc.util.StackUtils;
import igentuman.nc.util.TextUtils;
import igentuman.nc.util.annotation.NothingNullByDefault;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ContainerBlock
extends Block
implements EntityBlock {
    public ContainerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.getExistingBlockEntity(pPos);
        if (blockEntity instanceof ContainerBE) {
            ContainerBE containerBE = (ContainerBE)blockEntity;
            return (int)(containerBE.getLoadRate() * 15.0);
        }
        return 0;
    }

    public InteractionResult m_6227_(BlockState state, Level level, final BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.m_5776_()) {
            ContainerBE be = (ContainerBE)level.getExistingBlockEntity(pos);
            ItemStack handStack = player.m_21120_(hand);
            if (StackUtils.isMultiTool(handStack)) {
                Direction dirToChange = result.m_82434_();
                if (player.m_6144_()) {
                    dirToChange = dirToChange.m_122424_();
                }
                SideModeToggleable.SideMode mode = be.toggleSideConfig(dirToChange.ordinal());
                player.m_213846_((Component)TextUtils.__("message.nc.switch_side.mode", mode.name()));
            } else {
                MenuProvider containerProvider = new MenuProvider(){

                    public Component m_5446_() {
                        return TextUtils.__("container.nc.storage", new Object[0]);
                    }

                    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                        return new StorageContainerContainer(windowId, pos, playerInventory);
                    }
                };
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)be.m_58899_());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.m_60734_() != pNewState.m_60734_()) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)NCStorageBlocks.STORAGE_BE.get(this.code()).get()).m_155264_(pPos, pState);
    }

    public String code() {
        return this.m_5456_().toString();
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof ContainerBE) {
                    ContainerBE tile = (ContainerBE)t;
                    tile.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof ContainerBE) {
                ContainerBE tile = (ContainerBE)t;
                tile.tickServer();
            }
        };
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        if (stack.m_41782_()) {
            ContainerBE tileEntity = (ContainerBE)world.m_7702_(pos);
            CompoundTag nbtData = stack.m_41783_();
            tileEntity.m_142466_(nbtData);
        }
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @javax.annotation.Nullable BlockEntity pBlockEntity, ItemStack pTool) {
        pPlayer.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        pPlayer.m_36399_(0.005f);
        ContainerBE ContainerBE2 = (ContainerBE)pBlockEntity;
        CompoundTag data = ContainerBE2.m_5995_();
        ItemStack drop = new ItemStack((ItemLike)this);
        drop.m_41751_(data);
        if (!pLevel.m_5776_()) {
            ItemEntity itemEntity = new ItemEntity(pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), drop);
            itemEntity.m_32060_();
            pLevel.m_7967_((Entity)itemEntity);
        }
    }

    public void m_5871_(ItemStack stack, @javax.annotation.Nullable BlockGetter world, List<Component> list, TooltipFlag flag) {
        list.add((Component)TextUtils.__("tooltip.nc.use_multitool", new Object[0]).m_130940_(ChatFormatting.YELLOW));
    }

    public boolean registered() {
        return ContainerBlocks.registered().containsKey(this.code());
    }
}

