/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.target_chamber;

import igentuman.nc.block.MultiblockBlock;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.particle_chamber.DetectorDef;
import igentuman.nc.multiblock.particle_chamber.TargetChamberRegistration;
import igentuman.nc.util.TextUtils;
import igentuman.nc.util.math.Pos3D;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class DetectorBlock
extends MultiblockBlock {
    public double efficiency = 0.0;
    public int power = 0;
    public int distance = 0;
    public String type = "";
    public DetectorDef def;

    public DetectorBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(2.0f).m_60999_());
    }

    public DetectorBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60918_(SoundType.f_56743_));
        this.initParams();
    }

    public DetectorBlock(BlockBehaviour.Properties reactorBlocksProperties, DetectorDef def) {
        super(reactorBlocksProperties);
        this.type = def.name;
        this.def = def;
        this.efficiency = def.efficiency;
        this.power = def.power;
        this.distance = def.distance;
    }

    private void initParams() {
        this.type = this.m_5456_().toString();
        this.def = TargetChamberRegistration.TARGET_CHAMBER_DETECTORS.get(this.type);
        this.power = this.def.power;
        this.efficiency = this.def.efficiency;
        this.distance = this.def.distance;
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> list, TooltipFlag pFlag) {
        if (this.m_5456_().toString().contains("empty")) {
            return;
        }
        this.initParams();
        list.add((Component)TextUtils.applyFormat((Component)TextUtils.__("tooltip.detector.distance", this.distance), ChatFormatting.GOLD));
        list.add((Component)TextUtils.applyFormat((Component)TextUtils.__("tooltip.detector.power", this.power), ChatFormatting.GOLD));
        list.add((Component)TextUtils.applyFormat((Component)TextUtils.__("tooltip.detector.efficiency", this.efficiency * 100.0), ChatFormatting.GOLD));
    }

    public boolean isValid(Level level, BlockPos pos, AbstractMultiblock multiblock) {
        return Pos3D.getTaxiDistance(multiblock.getCenterBlock(), pos) <= this.distance;
    }
}

