/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.turbine;

import igentuman.nc.block.turbine.entity.TurbineCoilBE;
import igentuman.nc.handler.event.client.InputEvents;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.turbine.CoilDef;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.util.NcUtils;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TurbineCoilBlock
extends Block
implements EntityBlock {
    public double efficiency = 0.0;
    public String type = "";
    public CoilDef def;
    public Component placementRule;

    public TurbineCoilBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_));
    }

    public TurbineCoilBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60918_(SoundType.f_56743_));
    }

    private void initParams() {
        Item item = Item.m_41439_((Block)this);
        if (item.toString().isEmpty()) {
            return;
        }
        this.type = item.toString().replaceAll("_coil|turbine_", "");
        this.def = TurbineRegistration.coils.get(this.type);
        this.efficiency = this.def.getEfficiency();
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        if (this.def == null) {
            this.initParams();
        }
        this.def.getValidator();
        TurbineCoilBE be = (TurbineCoilBE)((BlockEntityType)TurbineRegistration.TURBINE_BE.get("turbine_coil").get()).m_155264_(pPos, pState);
        be.setCoilDef(this.def);
        return be;
    }

    private List<String> getBlockNames(String rawLine) {
        String[] blocks;
        ArrayList<String> names = new ArrayList<String>();
        String[] conditionParts = rawLine.split("=|-|>|<|\\^");
        for (String code : blocks = conditionParts[0].split("\\|")) {
            Object id = code;
            if (!((String)id).contains(":")) {
                id = "nuclearcraft:" + (String)id;
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(NcUtils.rlFromString((String)id));
                names.add(block.m_49954_().getString());
                continue;
            }
            names.add(TextUtils.convertToName(((String)id).split(":")[1]));
        }
        return names;
    }

    public Component getPlacementRule() {
        if (this.placementRule == null) {
            ArrayList<String> lines = new ArrayList<String>();
            int i = 0;
            if (this.def.getValidator() instanceof CoilDef.Validator) {
                for (String[] condition : this.def.getValidator().blockLines().keySet()) {
                    if (i > 0) {
                        lines.add(TextUtils.__("heat_sink.and", new Object[0]).getString());
                    }
                    String blocksLine = String.join((CharSequence)(" " + TextUtils.__("heat_sink.or", new Object[0]).getString() + " "), this.getBlockNames(condition[2]));
                    switch (condition[0]) {
                        case ">": {
                            lines.add(TextUtils.__("heat_sink.atleast" + (condition[1].equals("1") ? "" : "s"), condition[1], blocksLine).getString());
                            break;
                        }
                        case "-": {
                            lines.add(TextUtils.__("heat_sink.between", condition[1], blocksLine).getString());
                            break;
                        }
                        case "=": {
                            lines.add(TextUtils.__("heat_sink.exact" + (condition[1].equals("1") ? "" : "s"), condition[1], blocksLine).getString());
                            break;
                        }
                        case "<": {
                            lines.add(TextUtils.__("heat_sink.less_than", condition[1], blocksLine).getString());
                            break;
                        }
                        case "^": {
                            lines.add(TextUtils.__("heat_sink.in_corner", condition[1], blocksLine).getString());
                        }
                    }
                    ++i;
                }
                this.placementRule = TextUtils.__("heat_sink.placement.rule", String.join((CharSequence)" ", lines));
            } else {
                this.placementRule = TextUtils.__("heat_sink.placement.error", new Object[0]);
            }
        }
        return this.placementRule;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof TurbineCoilBE) {
                    TurbineCoilBE tile = (TurbineCoilBE)t;
                    tile.tickClient();
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof TurbineCoilBE) {
                TurbineCoilBE tile = (TurbineCoilBE)t;
                tile.tickServer();
            }
        };
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        if (level.m_5776_()) {
            return;
        }
        MultiblockHandler.get((ResourceKey<Level>)((Level)level).m_46472_()).trackBlockChange(neighbor);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
        MultiblockHandler.get((ResourceKey<Level>)pLevel.m_46472_()).trackBlockChange(pPos, true);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        if (level.m_5776_()) {
            return;
        }
        MultiblockHandler.get((ResourceKey<Level>)level.m_46472_()).trackBlockChange(pos, true);
    }

    public void m_5871_(ItemStack pStack, @javax.annotation.Nullable BlockGetter pLevel, List<Component> list, TooltipFlag pFlag) {
        this.initParams();
        if (InputEvents.DESCRIPTIONS_SHOW) {
            list.add((Component)TextUtils.applyFormat(this.getPlacementRule(), ChatFormatting.AQUA));
            list.add((Component)TextUtils.applyFormat((Component)TextUtils.__("tooltip.nc.description.efficiency", TextUtils.numberFormat(this.def.getEfficiency())), ChatFormatting.GOLD));
        } else {
            list.add((Component)TextUtils.applyFormat((Component)TextUtils.__("tooltip.toggle_description_keys", new Object[0]), ChatFormatting.GRAY));
        }
    }
}

