/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.turbine;

import igentuman.nc.block.MultiblockControllerBlock;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.block.turbine.entity.TurbineControllerBE;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.container.TurbineControllerContainer;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.TurbineConfig;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.TextUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TurbineControllerBlock
extends MultiblockControllerBlock
implements EntityBlock {
    public static final String NAME = "turbine_controller";

    public TurbineControllerBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(2.0f).m_60999_());
    }

    public TurbineControllerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return ((BlockEntityType)TurbineRegistration.TURBINE_BE.get(NAME).get()).m_155264_(pPos, pState);
    }

    public InteractionResult m_6227_(@NotNull BlockState state, Level level, final @NotNull BlockPos pos, @NotNull Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity be;
        if (!level.m_5776_() && (be = level.getExistingBlockEntity(pos)) instanceof TurbineControllerBE) {
            MenuProvider containerProvider = new MenuProvider(){

                public Component m_5446_() {
                    return TextUtils.__(TurbineControllerBlock.NAME, new Object[0]);
                }

                public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new TurbineControllerContainer(windowId, pos, playerInventory);
                }
            };
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)be.m_58899_());
        }
        return InteractionResult.SUCCESS;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return (lvl, pos, blockState, t) -> {
                if (t instanceof TurbineControllerBE) {
                    TurbineControllerBE tile = (TurbineControllerBE)t;
                    tile.tickClient();
                    level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(tile.powered)), 3);
                }
            };
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof TurbineControllerBE) {
                TurbineControllerBE tile = (TurbineControllerBE)t;
                tile.tickServer();
            }
        };
    }

    public void m_5871_(ItemStack pStack, @javax.annotation.Nullable BlockGetter pLevel, List<Component> list, TooltipFlag pFlag) {
        if (ModUtil.isGtLoaded() && NuclearCraftBE.isGTEUCapEnabled()) {
            list.add((Component)TextUtils.__("tooltip.nc.energy_eu_tier", new Object[]{this.getTier(pStack)}).m_130940_(ChatFormatting.GOLD));
        }
        if (ModUtil.isGtLoaded() && CommonConfig.GTCEU_CONFIG.COMPATIBILITY.get() == CommonConfig.GTCEUCompatibilityConfig.GTCEUCompatibility.GTCEU_AND_FE && ((Boolean)CommonConfig.GTCEU_CONFIG.LIMIT_FE_OUTPUT.get()).booleanValue()) {
            list.add((Component)TextUtils.__("tooltip.nc.max_fe_extract_per_tick", TextUtils.formatEnergy(GTUtils.getMaxOutputFE((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.TURBINE_ENERGY_TIER.get())))).m_130940_(ChatFormatting.GOLD));
        }
        list.add((Component)TextUtils.__("multiblock.build_in_chunk.advise", new Object[0]).m_130940_(ChatFormatting.GREEN));
        int min = (Integer)TurbineConfig.TURBINE_CONFIG.MIN_SIZE.get();
        int max = (Integer)TurbineConfig.TURBINE_CONFIG.MAX_SIZE.get();
        list.add((Component)TextUtils.__("tooltip.structure.sizes", min + "x" + min + "x" + min, max + "x" + max + "x" + max).m_130940_(ChatFormatting.ITALIC));
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        if (level.m_5776_()) {
            return;
        }
        MultiblockHandler.get((ResourceKey<Level>)((Level)level).m_46472_()).trackBlockChange(pos);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
        MultiblockHandler.get((ResourceKey<Level>)pLevel.m_46472_()).trackBlockChange(pPos, true);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        if (level.m_5776_()) {
            return;
        }
        MultiblockHandler.get((ResourceKey<Level>)level.m_46472_()).trackBlockChange(pos, true);
    }

    private CommonConfig.GTCEUCompatibilityConfig.GTCEUTier getTier(ItemStack pStack) {
        return CommonConfig.GTCEUCompatibilityConfig.GTCEUTier.byId(((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.TURBINE_ENERGY_TIER.get())).ordinal() + pStack.m_41784_().m_128451_("upgrade_tier"));
    }
}

