/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.turbine.entity;

import igentuman.nc.block.fission.FissionControllerBlock;
import igentuman.nc.block.turbine.TurbineBearingBlock;
import igentuman.nc.block.turbine.TurbineRotorBlock;
import igentuman.nc.block.turbine.entity.TurbineBE;
import igentuman.nc.block.turbine.entity.TurbineBladeBE;
import igentuman.nc.block.turbine.entity.TurbineControllerBE;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.util.annotation.NBTField;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TurbineRotorBE
extends TurbineBE {
    @NBTField
    public BlockPos controllerPos = BlockPos.f_121853_;
    private float rotation = 0.0f;
    public static String NAME = "turbine_rotor_shaft";
    public boolean connectedToBearing = false;

    public TurbineRotorBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, NAME);
    }

    public void updateBearingConnection() {
        this.connectedToBearing = false;
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)TurbineRotorBlock.f_52588_);
        for (Direction dir : List.of(facing, facing.m_122424_())) {
            BlockEntity be = this.m_58904_().getExistingBlockEntity(this.m_58899_().m_121945_(dir));
            BlockState bs = this.m_58904_().m_8055_(this.m_58899_().m_121945_(dir));
            if (be instanceof TurbineRotorBE) {
                TurbineRotorBE rotor = (TurbineRotorBE)be;
                this.connectedToBearing = rotor.hasBearingConnection(dir);
                if (this.connectedToBearing) break;
            }
            if (!(bs.m_60734_() instanceof TurbineBearingBlock)) continue;
            this.connectedToBearing = true;
            break;
        }
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        this.saveTagData(tag);
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        this.readTagData(tag);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        BlockPos wasPos = this.controllerPos;
        if (wasPos != this.getControllerPos()) {
            this.controllerPos = this.getControllerPos();
            MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.getRotationSpeed() > 0.0f)));
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.getRotationSpeed() > 0.0f)), 1);
        }
    }

    private BlockPos getControllerPos() {
        if (this.getController() == null) {
            return BlockPos.f_121853_;
        }
        return this.getController().m_58899_();
    }

    private boolean hasBearingConnection(Direction dir) {
        if (this.connectedToBearing) {
            return true;
        }
        BlockEntity be = this.m_58904_().getExistingBlockEntity(this.m_58899_().m_121945_(dir));
        BlockState bs = this.m_58904_().m_8055_(this.m_58899_().m_121945_(dir));
        if (be instanceof TurbineRotorBE) {
            TurbineRotorBE rotor = (TurbineRotorBE)be;
            this.connectedToBearing = rotor.hasBearingConnection(dir);
        }
        if (bs.m_60734_() instanceof TurbineBearingBlock) {
            this.connectedToBearing = true;
        }
        return this.connectedToBearing;
    }

    public TurbineControllerBE getController() {
        if (this.controllerPos == BlockPos.f_121853_) {
            return this.controller();
        }
        BlockEntity be = this.m_58904_().getExistingBlockEntity(this.controllerPos);
        if (be instanceof TurbineControllerBE) {
            TurbineControllerBE controller = (TurbineControllerBE)be;
            return controller;
        }
        return this.controller();
    }

    public float getRotationSpeed() {
        TurbineControllerBE controller = this.getController();
        this.rotation = 0.0f;
        if (controller instanceof TurbineControllerBE) {
            if (controller.m_58901_()) {
                return this.rotation;
            }
            this.rotation = controller.getRotationSpeed();
        }
        return this.rotation;
    }

    public int getAttachedBlades() {
        BlockEntity be;
        int blades = 0;
        Direction rotorFacing = (Direction)this.m_58900_().m_61143_((Property)TurbineRotorBlock.f_52588_);
        Direction facing = Direction.NORTH;
        if (rotorFacing.m_122434_() != Direction.Axis.Y) {
            facing = rotorFacing.m_122427_();
        }
        for (int i = 1; i < 32 && (be = this.m_58904_().m_7702_(this.m_58899_().m_5484_(facing, i))) instanceof TurbineBladeBE; ++i) {
            ++blades;
        }
        return blades * 2;
    }

    public boolean isFormed() {
        if (this.getController() == null) {
            return false;
        }
        if (this.getController() instanceof TurbineControllerBE && this.getController().m_58901_()) {
            return false;
        }
        return this.getController().controller().isInternalValid && this.getController().controller().isCasingValid;
    }
}

