/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.NuclearCraft;
import igentuman.nc.client.gui.IVerticalBarScreen;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.client.gui.element.bar.VerticalBar;
import igentuman.nc.client.gui.element.button.Button;
import igentuman.nc.client.gui.element.button.Checkbox;
import igentuman.nc.client.gui.element.button.SliderHorizontal;
import igentuman.nc.client.gui.element.fluid.FluidTankRenderer;
import igentuman.nc.client.gui.element.slot.VerticalLongSlot;
import igentuman.nc.container.FusionCoreContainer;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class FusionCoreScreen
extends AbstractContainerScreen<FusionCoreContainer>
implements IVerticalBarScreen {
    protected final ResourceLocation GUI = NuclearCraft.rl("textures/gui/fusion_core.png");
    protected int relX;
    protected int relY;
    private int xCenter;
    private Checkbox checklist;
    private Button.FusionReactorRedstoneModeButton redstoneConfigBtn;
    private Button.MultiblockAnalyze analyzeBtn;
    public List<NCGuiElement> widgets = new ArrayList<NCGuiElement>();
    public Checkbox checkboxIsFormed;
    private VerticalBar energyBar;
    private VerticalBar heatBar;
    private VerticalBar coolantBar;
    private VerticalBar hotCoolantBar;
    private VerticalBar.HeatLong plasmaHeatBar;
    private SliderHorizontal rfAmplifierSlider;
    public Component casingTootip = Component.m_237119_();

    public FusionCoreContainer container() {
        return (FusionCoreContainer)this.f_97732_;
    }

    public FusionCoreScreen(FusionCoreContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.f_97726_ = 214;
        this.f_97727_ = 186;
    }

    protected void updateRelativeCords() {
        this.relX = (this.f_96543_ - this.f_97726_) / 2;
        this.relY = (this.f_96544_ - this.f_97727_) / 2;
        NCGuiElement.RELATIVE_X = this.relX;
        NCGuiElement.RELATIVE_Y = this.relY;
    }

    protected void m_7856_() {
        super.m_7856_();
        Minecraft mc = Minecraft.m_91087_();
        this.updateRelativeCords();
        this.widgets.clear();
        this.checkboxIsFormed = new Checkbox(6, 104, this, this.isCasingValid());
        this.checklist = new Checkbox(6, 122, this, this.isReady());
        this.heatBar = new VerticalBar.HeatLong(6, 5, this, (int)this.container().getMaxHeat());
        this.energyBar = new VerticalBar.EnergyLong(16, 5, (IVerticalBarScreen)this, this.container().getMaxEnergy());
        this.coolantBar = new VerticalBar.CoolantLong(26, 5, (IVerticalBarScreen)this, 1000000);
        this.plasmaHeatBar = new VerticalBar.HeatLong(36, 5, this, (long)(this.container().getOptimalTemp() * 2.0), () -> this.container().getPlasmaHeat());
        this.rfAmplifierSlider = new SliderHorizontal(64, 40, 119, this, ((FusionCoreContainer)this.f_97732_).getBlockPos());
        this.rfAmplifierSlider.slideTo(this.container().getAmlificationAdjustment());
        this.redstoneConfigBtn = new Button.FusionReactorRedstoneModeButton(169, 83, this, ((FusionCoreContainer)this.f_97732_).getBlockPos());
        this.analyzeBtn = new Button.MultiblockAnalyze(190, 105, this, ((FusionCoreContainer)this.f_97732_).getBlockPos());
        this.widgets.add(new Button.ReportIssue(6, 150, this, ((FusionCoreContainer)this.f_97732_).getBlockPos()));
        this.widgets.add(this.redstoneConfigBtn);
        this.widgets.add(this.analyzeBtn);
        this.widgets.add(this.rfAmplifierSlider);
        this.widgets.add(this.heatBar);
        this.widgets.add(this.plasmaHeatBar);
        this.widgets.add(this.coolantBar);
        this.addSlots();
    }

    private boolean isReady() {
        return this.container().isReady();
    }

    private boolean isCasingValid() {
        return this.container().isCasingValid();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.xCenter = this.getGuiLeft() - this.f_97726_ / 2;
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    public byte getComparatorMode() {
        return this.container().redstoneMode();
    }

    public byte getAnalogSignalStrength() {
        return this.container().analogSignal();
    }

    private void renderWidgets(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.redstoneConfigBtn.setMode(this.getComparatorMode());
        this.redstoneConfigBtn.strength = this.getAnalogSignalStrength();
        this.analyzeBtn.setEnabled(this.container().canAnalyze());
        for (NCGuiElement widget : this.widgets) {
            widget.draw(graphics, mouseX, mouseY, partialTicks);
        }
        this.checkboxIsFormed.setChecked(this.isCasingValid()).draw(graphics, mouseX, mouseY, partialTicks);
        this.checklist.setChecked(this.isReady()).draw(graphics, mouseX, mouseY, partialTicks);
        this.checklist.setTooltipKey("tooltip.nc.reactor.not_ready");
        if (this.isCasingValid()) {
            this.checkboxIsFormed.setTooltipKey("multiblock.casing.complete");
            if (this.isReady()) {
                this.checklist.setTooltipKey("tooltip.nc.reactor.ready");
            }
            this.checklist.addTooltip((Component)TextUtils.__("tooltip.nc.reactor.has_magnets", this.container().hasMagnets() ? "Ok" : "--").m_130940_(ChatFormatting.AQUA));
            this.checklist.addTooltip((Component)TextUtils.__("tooltip.nc.reactor.has_amplifiers", this.container().hasAmplifiers() ? "Ok" : "--").m_130940_(ChatFormatting.AQUA));
            this.checklist.addTooltip((Component)TextUtils.__("tooltip.nc.reactor.has_coolant", this.container().hasCoolant() ? "Ok" : "--").m_130940_(ChatFormatting.AQUA));
            this.checklist.addTooltip((Component)TextUtils.__("tooltip.nc.reactor.has_energy", this.container().hasEnoughEnergy() ? "Ok" : "--").m_130940_(ChatFormatting.AQUA));
            this.checklist.addTooltip((Component)TextUtils.__("tooltip.nc.reactor.has_fuel", this.container().hasRecipe() ? "Ok" : "--").m_130940_(ChatFormatting.AQUA));
            this.checklist.addTooltip((Component)TextUtils.__("tooltip.nc.reactor.charge", this.container().getCharge() == 100 ? "Ok" : "--").m_130940_(ChatFormatting.AQUA));
            this.checklist.addTooltip((Component)TextUtils.__("tooltip.nc.reactor.running", this.container().isRunning() ? "Ok" : "--").m_130940_(ChatFormatting.AQUA));
            if (!this.container().getElectromagnetsPower().equals("0")) {
                this.checkboxIsFormed.addTooltip((Component)TextUtils.__("tooltip.nc.electromagnet.magnetic_field", this.container().getElectromagnetsField()).m_130940_(ChatFormatting.BLUE));
                this.checkboxIsFormed.addTooltip((Component)TextUtils.__("tooltip.nc.electromagnet.power", this.container().getElectromagnetsPower()).m_130940_(ChatFormatting.AQUA));
                this.checkboxIsFormed.addTooltip((Component)TextUtils.__("tooltip.nc.electromagnet.max_temp", this.container().getElectromagnetsMaxTemp()).m_130940_(ChatFormatting.GOLD));
            } else {
                this.checkboxIsFormed.addTooltip((Component)TextUtils.__("tooltip.nc.electromagnet.not_found", new Object[0]).m_130940_(ChatFormatting.RED));
            }
            this.checkboxIsFormed.addTooltip((Component)Component.m_237113_((String)"----------------------"));
            if (this.container().hasAmplifiers()) {
                this.checkboxIsFormed.addTooltip((Component)TextUtils.__("tooltip.nc.rf_amplifier.voltage", this.container().getAmplifierVoltage()).m_130940_(ChatFormatting.BLUE));
                this.checkboxIsFormed.addTooltip((Component)TextUtils.__("tooltip.nc.rf_amplifier.power", this.container().getAmplifierPower()).m_130940_(ChatFormatting.AQUA));
                this.checkboxIsFormed.addTooltip((Component)TextUtils.__("tooltip.nc.rf_amplifier.max_temp", this.container().getAmplifierMaxTemp()).m_130940_(ChatFormatting.GOLD));
            } else {
                this.checkboxIsFormed.addTooltip((Component)TextUtils.__("tooltip.nc.rf_amplifier.not_found", new Object[0]).m_130940_(ChatFormatting.RED));
            }
        } else {
            this.checkboxIsFormed.setTooltipKey("reactor.casing.incomplete");
        }
        this.checkboxIsFormed.addTooltip(this.casingTootip);
        this.energyBar.draw(graphics, mouseX, mouseY, partialTicks);
    }

    protected FluidTank getFluidTank(int i) {
        return ((FusionCoreContainer)this.f_97732_).getFluidTank(i);
    }

    public void addSlots() {
        this.addWidget(new VerticalLongSlot(53, 6));
        this.addWidget(new VerticalLongSlot(53, 56));
        this.addWidget(new FluidTankRenderer(this.getFluidTank(0), 0, FluidTankRenderer.TooltipMode.SHOW_AMOUNT_AND_CAPACITY, 6, 46, 53, 6, true));
        this.addWidget(new FluidTankRenderer(this.getFluidTank(1), 1, FluidTankRenderer.TooltipMode.SHOW_AMOUNT_AND_CAPACITY, 6, 46, 53, 56, true));
        this.addWidget(new VerticalLongSlot(191, 6));
        this.addWidget(new VerticalLongSlot(191, 56));
        this.addWidget(new VerticalLongSlot(201, 6));
        this.addWidget(new VerticalLongSlot(201, 56));
        this.addWidget(new FluidTankRenderer(this.getFluidTank(3), FluidTankRenderer.TooltipMode.SHOW_AMOUNT_AND_CAPACITY, 6, 46, 191, 6));
        this.addWidget(new FluidTankRenderer(this.getFluidTank(4), FluidTankRenderer.TooltipMode.SHOW_AMOUNT_AND_CAPACITY, 6, 46, 191, 56));
        this.addWidget(new FluidTankRenderer(this.getFluidTank(5), FluidTankRenderer.TooltipMode.SHOW_AMOUNT_AND_CAPACITY, 6, 46, 201, 6));
        this.addWidget(new FluidTankRenderer(this.getFluidTank(6), FluidTankRenderer.TooltipMode.SHOW_AMOUNT_AND_CAPACITY, 6, 46, 201, 56));
        this.addWidget(new FluidTankRenderer(this.getFluidTank(2), FluidTankRenderer.TooltipMode.SHOW_AMOUNT_AND_CAPACITY, 6, 95, 27, 6));
    }

    protected void addWidget(NCGuiElement widget) {
        widget.setScreen(this);
        this.widgets.add(widget);
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280653_(this.f_96547_, (Component)TextUtils.__("nc_jei_cat.fusion_core", new Object[0]), 125, 10, 0xFFFFFF);
        graphics.m_280653_(this.f_96547_, (Component)TextUtils.__("fusion_core.rf_amplifiers.power", this.getAmplification()), 125, 20, 0xFFFFFF);
        graphics.m_280653_(this.f_96547_, (Component)TextUtils.__("fusion_core.rf_amplifiers.adjustment", this.getAmplificationAdjustment()), 125, 30, 0xFFFFFF);
        if (this.container().getCharge() < 100) {
            graphics.m_280653_(this.f_96547_, (Component)TextUtils.__("fusion_core.charge", this.container().getCharge()), 125, 50, 0xFFFFFF);
        }
        this.casingTootip = Component.m_237119_();
        if (this.container().isRunning()) {
            graphics.m_280653_(this.f_96547_, (Component)TextUtils.__("fusion_core.efficiency", this.container().getEfficiency()), 125, 60, 0xFFFFFF);
            graphics.m_280653_(this.f_96547_, (Component)TextUtils.__("fusion_core.stability", this.container().getPlasmaStability()), 125, 50, 0xFFFFFF);
        }
        this.renderTooltips(graphics, mouseX - this.relX, mouseY - this.relY);
    }

    private String getAmplification() {
        return TextUtils.numberFormat(this.container().getAmplification());
    }

    private String getAmplificationAdjustment() {
        return TextUtils.numberFormat(this.container().getAmlificationAdjustment());
    }

    private Object getValidationResultData() {
        return this.container().getValidationResultData().m_123344_();
    }

    private String getValidationResultKey() {
        return this.container().getValidationResultKey();
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        this.updateRelativeCords();
        graphics.m_280218_(this.GUI, this.relX, this.relY, 0, 0, this.f_97726_, this.f_97727_);
        this.renderWidgets(graphics, partialTicks, mouseX, mouseY);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_6375_(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        super.m_6375_(pMouseX, pMouseY, pButton);
        this.redstoneConfigBtn.m_6375_(pMouseX, pMouseY, pButton);
        this.rfAmplifierSlider.m_6375_(pMouseX, pMouseY, pButton);
        this.analyzeBtn.m_6375_(pMouseX, pMouseY, pButton);
        return false;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        super.m_6348_(pMouseX, pMouseY, pButton);
        this.redstoneConfigBtn.m_6348_(pMouseX, pMouseY, pButton);
        this.rfAmplifierSlider.m_6348_(pMouseX, pMouseY, pButton);
        return false;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.rfAmplifierSlider.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        return false;
    }

    private void renderTooltips(GuiGraphics graphics, int pMouseX, int pMouseY) {
        this.heatBar.clearTooltips();
        this.plasmaHeatBar.clearTooltips();
        this.coolantBar.clearTooltips();
        this.plasmaHeatBar.setTooltipKey("tooltip.nc.reactor.plasma_heat");
        this.plasmaHeatBar.addTooltip((Component)TextUtils.__("tooltip.nc.reactor.plasma_optimal", TextUtils.scaledFormat(this.container().getOptimalTemp())).m_130940_(ChatFormatting.GOLD));
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_5953_(pMouseX, pMouseY)) continue;
            graphics.m_280677_(this.f_96547_, widget.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.rfAmplifierSlider.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, List.of(TextUtils.__("tooltip.nc.rf_amplifier.voltage", this.container().getAmplifierVoltage()).m_130940_(ChatFormatting.AQUA), TextUtils.__("tooltip.nc.rf_amplifier.power", this.container().getAmplifierPower()).m_130940_(ChatFormatting.AQUA)), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.checkboxIsFormed.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checkboxIsFormed.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.checklist.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checklist.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        this.energyBar.clearTooltips();
        this.energyBar.addTooltip((Component)TextUtils.__("tooltip.nc.forge_energy_per_tick", TextUtils.scaledFormat(this.container().energyPerTick())));
        this.energyBar.addTooltip((Component)TextUtils.__("reactor.internal_usage", TextUtils.scaledFormat(this.container().requiredEnergy())).m_130940_(ChatFormatting.RED));
        if (this.energyBar.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.energyBar.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
    }

    @Override
    public double getEnergy() {
        return this.container().getEnergy();
    }

    @Override
    public double getHeat() {
        return this.container().getHeat();
    }

    @Override
    public double getCoolant() {
        return 0.0;
    }

    @Override
    public double getHotCoolant() {
        return 0.0;
    }
}

