/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.accelerator;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.NuclearCraft;
import igentuman.nc.client.gui.IProgressScreen;
import igentuman.nc.client.gui.IVerticalBarScreen;
import igentuman.nc.client.gui.element.GuiParticle;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.client.gui.element.bar.ProgressBar;
import igentuman.nc.client.gui.element.bar.VerticalBar;
import igentuman.nc.client.gui.element.button.Button;
import igentuman.nc.client.gui.element.button.Checkbox;
import igentuman.nc.client.gui.element.fluid.FluidTankRenderer;
import igentuman.nc.container.TargetChamberControllerContainer;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TargetChamberControllerScreen
extends AbstractContainerScreen<TargetChamberControllerContainer>
implements IProgressScreen,
IVerticalBarScreen {
    protected final ResourceLocation GUI = NuclearCraft.rl("textures/gui/accelerators/target_chamber_controller.png");
    protected int relX;
    protected int relY;
    private int xCenter;
    public List<NCGuiElement> widgets = new ArrayList<NCGuiElement>();
    public Checkbox checkboxCasing;
    public Checkbox checkboxInterior;
    private VerticalBar energyBar;
    private Button.MultiblockAnalyze analyzeBtn;
    private Button.Link linkBtn;
    public GuiParticle guiParticle;
    public GuiParticle outputParticle1;
    public GuiParticle outputParticle2;
    public GuiParticle outputParticle3;
    public List<GuiParticle> outputParticles = new ArrayList<GuiParticle>();
    public Component casingTootip = Component.m_237119_();
    public Component interiorTootip = Component.m_237119_();

    public TargetChamberControllerContainer container() {
        return (TargetChamberControllerContainer)this.f_97732_;
    }

    public TargetChamberControllerScreen(TargetChamberControllerContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.f_97726_ = 176;
        this.f_97727_ = 200;
        this.guiParticle = new GuiParticle(18, 46);
        this.outputParticle1 = new GuiParticle(28, 46);
        this.outputParticle2 = new GuiParticle(28, 46);
        this.outputParticle3 = new GuiParticle(28, 46);
        this.outputParticles.add(new GuiParticle(86, 15));
        this.outputParticles.add(new GuiParticle(146, 46));
        this.outputParticles.add(new GuiParticle(86, 78));
    }

    protected void updateRelativeCords() {
        this.relX = (this.f_96543_ - this.f_97726_) / 2;
        this.relY = (this.f_96544_ - this.f_97727_) / 2;
        NCGuiElement.RELATIVE_X = this.relX;
        NCGuiElement.RELATIVE_Y = this.relY;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_6375_(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.updateRelativeCords();
        this.widgets.clear();
        this.checkboxCasing = new Checkbox(this.f_97726_ - 18, 105, this, this.isCasingValid());
        this.checkboxInterior = new Checkbox(this.f_97726_ - 31, 105, this, this.isInteriorValid());
        this.energyBar = new VerticalBar.Energy(7, 16, (IVerticalBarScreen)this, this.container().getMaxEnergy());
        this.widgets.add(new ProgressBar(71, 47, this, 8));
        this.analyzeBtn = new Button.MultiblockAnalyze(150, 78, this, ((TargetChamberControllerContainer)this.f_97732_).getPosition());
        this.linkBtn = new Button.Link(150, 14, this, ((TargetChamberControllerContainer)this.f_97732_).getPosition(), "https://ftb.fandom.com/wiki/NuclearCraft:_Neoteric#Fission_Reactor_+_Irradiator", List.of(TextUtils.__("tooltip.nc.wiki", new Object[0])));
        this.m_7787_((GuiEventListener)FluidTankRenderer.tank(this.getFluidTank(0)).id(0).size(18, 18).pos(53, 58).canVoid());
        this.m_7787_((GuiEventListener)FluidTankRenderer.tank(this.getFluidTank(0)).id(0).size(18, 18).pos(113, 58).canVoid());
        this.widgets.add(this.analyzeBtn);
        this.widgets.add(this.linkBtn);
    }

    protected FluidTank getFluidTank(int i) {
        return ((TargetChamberControllerContainer)this.f_97732_).getFluidTank(i);
    }

    private boolean isInteriorValid() {
        return this.container().isInteriorValid();
    }

    private boolean isCasingValid() {
        return this.container().isCasingValid();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.xCenter = this.getGuiLeft() - this.f_97726_ / 2;
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    private void renderWidgets(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.analyzeBtn.setEnabled(this.container().canAnalyze());
        for (NCGuiElement widget : this.widgets) {
            widget.draw(graphics, mouseX, mouseY, partialTicks);
        }
        this.checkboxCasing.setChecked(this.isCasingValid()).draw(graphics, mouseX, mouseY, partialTicks);
        if (this.isCasingValid()) {
            this.checkboxCasing.setTooltipKey("multiblock.casing.complete");
        } else {
            this.checkboxCasing.setTooltipKey("multiblock.casing.incomplete");
        }
        this.checkboxCasing.addTooltip(this.casingTootip);
        this.checkboxInterior.setChecked(this.isInteriorValid()).draw(graphics, mouseX, mouseY, partialTicks);
        if (this.isInteriorValid()) {
            this.checkboxInterior.setTooltipKey("multiblock.interior.complete");
        } else {
            this.checkboxInterior.setTooltipKey("multiblock.interior.incomplete");
        }
        this.checkboxInterior.addTooltip(this.interiorTootip);
        if (this.isInteriorValid()) {
            this.checkboxInterior.addTooltip((Component)TextUtils.__("tooltip.target_chamber.detectors", this.container().getDetectors()));
        }
        this.energyBar.draw(graphics, mouseX, mouseY, partialTicks);
        if (this.hasParticle()) {
            this.guiParticle.drawParticleStack(graphics, this.getParticleStack());
        }
        if (this.container().hasRecipe()) {
            int i = 0;
            for (GuiParticle particle : this.outputParticles) {
                particle.drawParticleStack(graphics, this.getOutputParticle(i));
                ++i;
            }
        }
    }

    private ParticleStack getOutputParticleStack(int i) {
        return this.container().getOutputParticle(i);
    }

    private boolean hasParticle() {
        return this.container().hasParticle();
    }

    private ParticleStack getParticleStack() {
        return this.container().getParticleStack();
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280653_(this.f_96547_, ((TargetChamberControllerContainer)this.f_97732_).getTitle(), this.f_97726_ / 2, 5, 0xFFFFFF);
        this.casingTootip = this.isCasingValid() ? TextUtils.applyFormat((Component)TextUtils.__("tooltip.nc.structure.size", this.getMultiblockHeight(), this.getMultiblockWidth(), this.getMultiblockDepth()), ChatFormatting.GOLD) : TextUtils.applyFormat((Component)TextUtils.__(this.getValidationResultKey(), this.getValidationResultData()), ChatFormatting.RED);
        if (this.isCasingValid()) {
            if (this.isInteriorValid()) {
                if (this.container().hasRecipe() && !this.container().getEfficiency().equals("NaN")) {
                    int color = this.container().getRawEfficiency() > 0.0 ? 0x8AFF8A : 0xCCCCCC;
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
                    graphics.m_280430_(this.f_96547_, (Component)TextUtils.__("fission_reactor.efficiency", this.container().getEfficiency()), 70, 164, color);
                    graphics.m_280168_().m_85849_();
                }
            } else {
                this.interiorTootip = TextUtils.applyFormat((Component)TextUtils.__(this.getValidationResultKey(), this.getValidationResultData()), ChatFormatting.RED);
            }
        }
        this.renderTooltips(graphics, mouseX - this.relX, mouseY - this.relY);
    }

    private Object getValidationResultData() {
        return this.container().getValidationResultData().m_123344_();
    }

    private String getValidationResultKey() {
        return this.container().getValidationResultKey();
    }

    private int getMultiblockHeight() {
        return this.container().getHeight();
    }

    private int getMultiblockWidth() {
        return this.container().getWidth();
    }

    private int getMultiblockDepth() {
        return this.container().getDepth();
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        this.updateRelativeCords();
        graphics.m_280218_(this.GUI, this.relX, this.relY, 0, 0, this.f_97726_, this.f_97727_);
        this.renderWidgets(graphics, partialTicks, mouseX, mouseY);
    }

    private void renderTooltips(GuiGraphics graphics, int pMouseX, int pMouseY) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_5953_(pMouseX, pMouseY)) continue;
            graphics.m_280677_(this.f_96547_, widget.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.checkboxCasing.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checkboxCasing.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.checkboxInterior.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checkboxInterior.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.guiParticle.m_5953_(pMouseX, pMouseY) && this.hasParticle()) {
            this.guiParticle.renderTooltip(graphics, this.getParticleStack(), pMouseX, pMouseY);
        }
        int i = 0;
        for (GuiParticle particle : this.outputParticles) {
            if (particle.m_5953_(pMouseX, pMouseY)) {
                particle.renderTooltip(graphics, this.getOutputParticle(i), pMouseX, pMouseY);
            }
            ++i;
        }
        this.energyBar.clearTooltips();
        this.energyBar.addTooltip((Component)TextUtils.__("tooltip.nc.energy.per_tick", this.container().energyPerTick()));
        if (this.energyBar.m_5953_(pMouseX, pMouseY + 10)) {
            graphics.m_280677_(this.f_96547_, this.energyBar.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
    }

    private ParticleStack getOutputParticle(int i) {
        return this.container().getOutputParticle(i);
    }

    @Override
    public double getProgress() {
        return this.container().getProgress();
    }

    @Override
    public double getEnergy() {
        return this.container().getEnergy();
    }

    @Override
    public double getHeat() {
        return 0.0;
    }

    @Override
    public double getCoolant() {
        return 0.0;
    }

    @Override
    public double getHotCoolant() {
        return 0.0;
    }
}

