/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.element.bar;

import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.TextUtils;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyBar
extends NCGuiElement {
    private final IEnergyStorage energy;

    public EnergyBar(int xMin, int yMin, IEnergyStorage energy) {
        super(xMin, yMin, 18, 88, (Component)Component.m_237119_());
        this.energy = energy;
        this.x = xMin;
        this.y = yMin;
        this.width = 16;
        this.height = 88;
    }

    @Override
    public List<Component> getTooltips() {
        if (ModUtil.isGtLoaded() && NuclearCraftBE.isGTEUCapEnabled()) {
            this.tooltips.add(Component.m_237113_((String)(GTUtils.formatEUEnergy(this.energy.getEnergyStored()) + "/" + GTUtils.formatEUEnergy(this.energy.getMaxEnergyStored()))));
            return this.tooltips;
        }
        this.tooltips.add(Component.m_237113_((String)(TextUtils.scaledFormat(this.energy.getEnergyStored()) + "/" + TextUtils.scaledFormat(this.energy.getMaxEnergyStored()) + " FE")));
        return this.tooltips;
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY, float pTicks) {
        super.draw(graphics, mX, mY, pTicks);
        int stored = (int)(86.0f * ((float)this.energy.getEnergyStored() / (float)this.energy.getMaxEnergyStored()));
        graphics.m_280218_(TEXTURE, this.X(), this.Y(), 36, 0, 18, 88);
        graphics.m_280218_(TEXTURE, this.X() + 1, this.Y() + 1 + 86 - stored, 54, 0, 16, stored);
    }
}

