/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import igentuman.nc.block.kugelblitz.entity.BlackHoleBE;
import igentuman.nc.client.renderer.NCShaders;
import igentuman.nc.handler.config.KugelblitzConfig;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

@Mod.EventBusSubscriber(modid="nuclearcraft", value={Dist.CLIENT})
public class DistortShader {
    private static int currentSize = 0;
    public static final BlackholeRegistry blackhole = new BlackholeRegistry();

    public static void register() {
        MinecraftForge.EVENT_BUS.register(DistortShader.class);
    }

    private static boolean isBlackHoleBlock(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("black_hole").get());
    }

    private static boolean processBlackHole(Minecraft mc, RenderLevelStageEvent event, EffectInstance effect, BlockPos pos) {
        if (mc.f_91073_ == null && mc.f_91074_ == null) {
            return false;
        }
        double distanceSq = mc.f_91074_.m_20182_().m_82531_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        double distance = Math.sqrt(distanceSq);
        if (distance > 64.0) {
            return false;
        }
        BlockEntity be = mc.f_91073_.getExistingBlockEntity(pos);
        float scaleMult = 1.0f;
        if (!(be instanceof BlackHoleBE)) {
            return false;
        }
        BlackHoleBE blackHoleBE = (BlackHoleBE)be;
        scaleMult = 0.3f / blackHoleBE.scale;
        if (scaleMult != 1.0f) {
            scaleMult = (float)Math.pow(scaleMult + 0.375f, 5.0);
        }
        float blurX = 0.5f;
        float blurY = 0.5f;
        boolean blackholeVisible = false;
        float distanceFactor = 0.0f;
        Matrix4f viewMatrix = event.getPoseStack().m_85850_().m_252922_();
        Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        float posX = (float)((double)pos.m_123341_() + 0.5 - cameraPos.m_7096_());
        float posY = (float)((double)pos.m_123342_() + 0.5 - cameraPos.m_7098_());
        float posZ = (float)((double)pos.m_123343_() + 0.5 - cameraPos.m_7094_());
        Vector4f pos1 = new Vector4f(posX, posY, posZ, 1.0f);
        pos1.mul((Matrix4fc)viewMatrix);
        pos1.mul((Matrix4fc)projectionMatrix);
        if (pos1.w != 0.0f) {
            pos1.x /= pos1.w;
            pos1.y /= pos1.w;
            pos1.z /= pos1.w;
        }
        float normalizedDepth = (pos1.z + 1.0f) * 0.5f;
        if (pos1.z > -1.0f && pos1.z < 1.0f) {
            blurX = pos1.x * 0.5f + 0.5f;
            blurY = pos1.y * 0.5f + 0.5f;
            float margin = 0.1f;
            if (blurX >= -margin && blurX <= 1.0f + margin && blurY >= -margin && blurY <= 1.0f + margin) {
                blackholeVisible = true;
                distanceFactor = (float)(7.0 / distance);
            }
        }
        float baseRadius = blackholeVisible ? 150.0f : 0.0f;
        float radius = baseRadius * distanceFactor * scaleMult;
        float baseMagnification = blackholeVisible ? 5.8f : 0.1f;
        effect.m_108952_("BlurPos").m_7971_(blurX, blurY);
        effect.m_108952_("Radius").m_7971_(radius, baseMagnification / scaleMult);
        effect.m_108952_("BlackHoleDepth").m_5985_(normalizedDepth);
        return true;
    }

    @SubscribeEvent
    public static void onRenderTick(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!((Boolean)KugelblitzConfig.KUGELBLITZ_CONFIG.BLACKHOLE_SHADER.get()).booleanValue()) {
            return;
        }
        if (NCShaders.blackholePostEffect != null) {
            EffectInstance effect = ((PostPass)NCShaders.blackholePostEffect.f_110009_.get(0)).m_110074_();
            if (currentSize != mc.m_91268_().m_85441_() + mc.m_91268_().m_85442_()) {
                currentSize = mc.m_91268_().m_85441_() + mc.m_91268_().m_85442_();
                NCShaders.blackholePostEffect.m_110025_(mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_());
                effect.m_108952_("BlurDir").m_7971_(0.2f, 0.0f);
            }
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            for (BlockPos pos : blackhole.getPositions()) {
                if (!DistortShader.processBlackHole(mc, event, effect, pos)) continue;
                NCShaders.blackholePostEffect.m_110023_(mc.m_91296_());
            }
            mc.m_91385_().m_83947_(false);
            ((PostPass)NCShaders.blackholePostEffect.f_110009_.get((int)(NCShaders.blackholePostEffect.f_110009_.size() - 1))).f_110053_.m_83956_();
            RenderSystem.depthFunc((int)515);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_5483_(0.0, (double)mc.m_91385_().f_83916_, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
            bufferbuilder.m_5483_((double)mc.m_91385_().f_83915_, (double)mc.m_91385_().f_83916_, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
            bufferbuilder.m_5483_((double)mc.m_91385_().f_83915_, 0.0, 0.0).m_7421_(1.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, 1.0f).m_5752_();
            tesselator.m_85914_();
            RenderSystem.depthFunc((int)515);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }
    }

    public static class BlackholeRegistry {
        private final Set<BlockPos> positions = new HashSet<BlockPos>();

        public boolean contains(BlockPos pos) {
            return this.positions.contains(pos);
        }

        public void add(BlockPos pos) {
            this.positions.add(pos);
        }

        public void remove(BlockPos pos) {
            this.positions.remove(pos);
        }

        public Set<BlockPos> getPositions() {
            return Collections.unmodifiableSet(this.positions);
        }
    }
}

