/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.cc;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import igentuman.nc.block.kugelblitz.entity.ChamberTerminalBE;
import javax.annotation.Nonnull;

public class KugelblitzPeripheral
implements IPeripheral {
    private final ChamberTerminalBE controller;

    public KugelblitzPeripheral(ChamberTerminalBE controller) {
        this.controller = controller;
    }

    @Nonnull
    public String getType() {
        return "nc_kugelblitz";
    }

    public boolean equals(IPeripheral other) {
        return this == other || other instanceof KugelblitzPeripheral && ((KugelblitzPeripheral)other).controller == this.controller;
    }

    @LuaFunction
    public final boolean isFormed() {
        return this.controller.isCasingValid && this.controller.isInternalValid;
    }

    @LuaFunction
    public final String getName() {
        return this.controller.getName();
    }

    @LuaFunction
    public final boolean hasRecipe() {
        return this.controller.hasRecipe();
    }

    @LuaFunction
    public final int getEnergyPerTick() {
        return this.controller.energyPerTick;
    }

    @LuaFunction
    public final int getEnergyStored() {
        return this.controller.energyStorage().getEnergyStored();
    }

    @LuaFunction
    public final int getRecipeProgress() {
        return (int)(this.controller.recipeInfo().getProgress() * 100.0);
    }

    @LuaFunction
    public final int getEvaporationRate() {
        return this.controller.evaporation;
    }

    @LuaFunction
    public final int getFeedingRate() {
        return (int)this.controller.feeding;
    }

    @LuaFunction
    public final int getBlackholeMass() {
        return (int)(this.controller.mass / 1000L);
    }

    @LuaFunction
    public final int getBlackholeStability() {
        return this.controller.blackholeStability;
    }

    @LuaFunction
    public final int getQuantumFrequency() {
        return this.controller.frequency;
    }

    @LuaFunction
    public final int setQuantumFrequency(int frequency) throws LuaException {
        if (frequency < 0 || frequency > 15) {
            throw new LuaException("Frequency must be between 0 and 15");
        }
        this.controller.frequency = (byte)frequency;
        this.controller.m_6596_();
        return this.controller.frequency;
    }

    @LuaFunction
    public final int getFluxRegulators() {
        return this.controller.fluxRegulators;
    }

    @LuaFunction
    public final int getTransformers() {
        return this.controller.transformers;
    }

    @LuaFunction
    public final int getStabilizers() {
        return this.controller.stabilizers;
    }

    @LuaFunction
    public final int getTransformationEnergyRate() {
        return this.controller.energyConvertionRate;
    }

    @LuaFunction
    public final int setTransformationEnergyRate(int rate) throws LuaException {
        if (rate < 0 || rate > 100) {
            throw new LuaException("Rate must be between 0 and 100");
        }
        this.controller.energyConvertionRate = rate;
        this.controller.m_6596_();
        return this.controller.energyConvertionRate;
    }
}

