/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.kubejs;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.recipe.OutputReplacement;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import igentuman.nc.compat.kubejs.InputParticle;
import igentuman.nc.content.particles.Particle;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.Particles;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class OutputParticle
implements OutputReplacement {
    public static final OutputParticle EMPTY = new OutputParticle(ParticleStack.EMPTY, Double.NaN, null);
    public final ParticleStack item;
    public final double chance;
    public final IntProvider rolls;

    public static OutputParticle of(ParticleStack item, double chance) {
        return item.isEmpty() ? EMPTY : new OutputParticle(item, chance, null);
    }

    public static OutputParticle of(Object from) {
        if (from instanceof OutputParticle) {
            OutputParticle out = (OutputParticle)from;
            return out;
        }
        if (from instanceof ParticleStack) {
            ParticleStack stack = (ParticleStack)from;
            return OutputParticle.of(stack, Double.NaN);
        }
        ParticleStack item = ParticleStack.EMPTY;
        if (from instanceof String) {
            String str = (String)from;
            item = OutputParticle.parseParticleFromString(str);
        } else if (from instanceof JsonObject) {
            JsonObject json = (JsonObject)from;
            item = OutputParticle.parseParticleFromJson(json);
        } else {
            return EMPTY;
        }
        if (item.isEmpty()) {
            return EMPTY;
        }
        double chance = Double.NaN;
        UniformInt rolls = null;
        if (from instanceof JsonObject) {
            JsonObject j = (JsonObject)from;
            if (j.has("chance")) {
                chance = j.get("chance").getAsDouble();
            }
            if (j.has("minRolls") && j.has("maxRolls")) {
                rolls = UniformInt.m_146622_((int)j.get("minRolls").getAsInt(), (int)j.get("maxRolls").getAsInt());
            }
        }
        return new OutputParticle(item, chance, (IntProvider)rolls);
    }

    private static ParticleStack parseParticleFromString(String str) {
        Particle particle;
        String[] parts = str.split(":");
        if (parts.length >= 1 && (particle = Particles.getParticleFromName(parts[0])) != null) {
            int amount = parts.length > 1 ? Integer.parseInt(parts[1]) : 1;
            long energy = parts.length > 2 ? Long.parseLong(parts[2]) : 0L;
            double focus = parts.length > 3 ? Double.parseDouble(parts[3]) : 0.0;
            return new ParticleStack(particle, amount, energy, focus);
        }
        return ParticleStack.EMPTY;
    }

    private static ParticleStack parseParticleFromJson(JsonObject json) {
        Particle particle;
        if (json.has("particle") && (particle = Particles.getParticleFromName(json.get("particle").getAsString())) != null) {
            int amount = json.has("amount") ? json.get("amount").getAsInt() : 1;
            long energy = json.has("meanEnergy") ? json.get("meanEnergy").getAsLong() : 0L;
            double focus = json.has("focus") ? json.get("focus").getAsDouble() : 0.0;
            return new ParticleStack(particle, amount, energy, focus);
        }
        return ParticleStack.EMPTY;
    }

    @Deprecated
    protected OutputParticle(ParticleStack item, double chance) {
        this(item, chance, null);
    }

    protected OutputParticle(ParticleStack item, double chance, @Nullable IntProvider rolls) {
        this.item = item;
        this.chance = chance;
        this.rolls = rolls;
    }

    public OutputParticle withCount(int count) {
        ParticleStack newItem = this.item.copy();
        newItem.setAmount(count);
        return new OutputParticle(newItem, this.chance, this.rolls);
    }

    public OutputParticle withChance(double chance) {
        return new OutputParticle(this.item.copy(), chance, this.rolls);
    }

    public OutputParticle withRolls(IntProvider rolls) {
        return new OutputParticle(this.item.copy(), this.chance, rolls);
    }

    public OutputParticle withRolls(int min, int max) {
        return this.withRolls((IntProvider)UniformInt.m_146622_((int)min, (int)max));
    }

    public boolean hasChance() {
        return !Double.isNaN(this.chance);
    }

    public double getChance() {
        return this.chance;
    }

    public int getCount() {
        return this.item.getAmount();
    }

    public CompoundTag getNbt() {
        return new CompoundTag();
    }

    public String toString() {
        if (this.item.getParticle() != null) {
            return this.item.getParticle().getName() + ":" + this.item.getAmount() + ":" + this.item.getMeanEnergy() + ":" + this.item.getFocus();
        }
        return "empty";
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public Object replaceOutput(RecipeJS recipe, ReplacementMatch match, OutputReplacement original) {
        if (original instanceof OutputParticle) {
            OutputParticle o = (OutputParticle)original;
            OutputParticle replacement = new OutputParticle(this.item.copy(), o.chance, o.rolls);
            replacement.item.setAmount(o.getCount());
            return replacement;
        }
        return new OutputParticle(this.item.copy(), Double.NaN, null);
    }

    @Deprecated
    public InputParticle ignoreNBT() {
        ConsoleJS console = ConsoleJS.getCurrent((ConsoleJS)ConsoleJS.SERVER);
        console.warn((Object)"Particles don't have NBT data like items!");
        return InputParticle.of(OutputParticle.createIngredientFromParticle(this.item), this.item.getAmount());
    }

    public InputParticle weakNBT() {
        return InputParticle.of(OutputParticle.createIngredientFromParticle(this.item), this.item.getAmount());
    }

    public InputParticle strongNBT() {
        return InputParticle.of(OutputParticle.createIngredientFromParticle(this.item), this.item.getAmount());
    }

    private static Ingredient createIngredientFromParticle(ParticleStack stack) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42127_});
    }
}

