/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentWithParent;
import dev.latvian.mods.kubejs.util.TinyMap;
import igentuman.nc.compat.kubejs.InputParticle;
import igentuman.nc.compat.kubejs.OutputParticle;
import igentuman.nc.compat.kubejs.ParticleMatch;
import java.util.Map;

public interface ParticleComponents {
    public static final RecipeComponent<InputParticle> INPUT = new RecipeComponent<InputParticle>(){

        public String componentType() {
            return "input_particle";
        }

        public ComponentRole role() {
            return ComponentRole.INPUT;
        }

        public Class<?> componentClass() {
            return InputParticle.class;
        }

        public boolean hasPriority(RecipeJS recipe, Object from) {
            return recipe.inputItemHasPriority(from);
        }

        public JsonElement write(RecipeJS recipe, InputParticle value) {
            return value.toJsonJS();
        }

        public InputParticle read(RecipeJS recipe, Object from) {
            return InputParticle.of(from);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isInput(RecipeJS recipe, InputParticle value, ReplacementMatch match) {
            if (!(match instanceof ParticleMatch)) return false;
            ParticleMatch m = (ParticleMatch)match;
            if (!value.validForMatching()) return false;
            if (!m.contains(value.ingredient)) return false;
            return true;
        }

        public String checkEmpty(RecipeKey<InputParticle> key, InputParticle value) {
            if (value.isEmpty()) {
                return "Ingredient '" + key.name + "' can't be empty!";
            }
            return "";
        }

        public RecipeComponent<TinyMap<Character, InputParticle>> asPatternKey() {
            return null;
        }

        public String toString() {
            return this.componentType();
        }
    };
    public static final RecipeComponent<InputParticle[]> INPUT_ARRAY = INPUT.asArray();
    public static final RecipeComponent<InputParticle[]> UNWRAPPED_INPUT_ARRAY = new RecipeComponentWithParent<InputParticle[]>(){

        public RecipeComponent<InputParticle[]> parentComponent() {
            return INPUT_ARRAY;
        }

        public JsonElement write(RecipeJS recipe, InputParticle[] value) {
            JsonArray json = new JsonArray();
            for (InputParticle in : value) {
                for (InputParticle in1 : in.unwrap()) {
                    json.add(INPUT.write(recipe, (Object)in1));
                }
            }
            return json;
        }

        public String toString() {
            return this.parentComponent().toString();
        }
    };
    public static final RecipeComponent<OutputParticle> OUTPUT = new RecipeComponent<OutputParticle>(){

        public String componentType() {
            return "output_particle";
        }

        public ComponentRole role() {
            return ComponentRole.OUTPUT;
        }

        public Class<?> componentClass() {
            return OutputParticle.class;
        }

        public boolean hasPriority(RecipeJS recipe, Object from) {
            return recipe.outputItemHasPriority(from);
        }

        public JsonElement write(RecipeJS recipe, OutputParticle value) {
            return ParticleComponents.writeParticleToJson(value);
        }

        public OutputParticle read(RecipeJS recipe, Object from) {
            return OutputParticle.of(from);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isOutput(RecipeJS recipe, OutputParticle value, ReplacementMatch match) {
            if (!(match instanceof ParticleMatch)) return false;
            ParticleMatch m = (ParticleMatch)match;
            if (value.isEmpty()) return false;
            if (!m.contains(value.item)) return false;
            return true;
        }

        public String checkEmpty(RecipeKey<OutputParticle> key, OutputParticle value) {
            if (value.isEmpty()) {
                return "ItemStack '" + key.name + "' can't be empty!";
            }
            return "";
        }

        public String toString() {
            return this.componentType();
        }
    };
    public static final RecipeComponent<OutputParticle[]> OUTPUT_ARRAY = OUTPUT.asArray();
    public static final RecipeComponent<OutputParticle> OUTPUT_ID_WITH_COUNT = new RecipeComponentWithParent<OutputParticle>(){

        public RecipeComponent<OutputParticle> parentComponent() {
            return OUTPUT;
        }

        public void writeToJson(RecipeJS recipe, RecipeComponentValue<OutputParticle> cv, JsonObject json) {
            if (((OutputParticle)cv.value).item.getParticle() != null) {
                json.addProperty(cv.key.name, ((OutputParticle)cv.value).item.getParticle().getName());
            }
            json.addProperty("count", (Number)((OutputParticle)cv.value).item.getAmount());
        }

        public void readFromJson(RecipeJS recipe, RecipeComponentValue<OutputParticle> cv, JsonObject json) {
            super.readFromJson(recipe, cv, json);
            if (cv.value != null && json.has("count")) {
                ((OutputParticle)cv.value).item.setAmount(json.get("count").getAsInt());
            }
        }

        public void readFromMap(RecipeJS recipe, RecipeComponentValue<OutputParticle> cv, Map<?, ?> map) {
            super.readFromMap(recipe, cv, map);
            if (cv.value != null && map.containsKey("count")) {
                ((OutputParticle)cv.value).item.setAmount(((Number)map.get("count")).intValue());
            }
        }

        public String toString() {
            return this.parentComponent().toString();
        }
    };

    public static JsonElement writeParticleToJson(OutputParticle value) {
        if (value.isEmpty()) {
            return null;
        }
        JsonObject json = new JsonObject();
        if (value.item.getParticle() != null) {
            json.addProperty("particle", value.item.getParticle().getName());
        }
        json.addProperty("amount", (Number)value.item.getAmount());
        json.addProperty("meanEnergy", (Number)value.item.getMeanEnergy());
        json.addProperty("focus", (Number)value.item.getFocus());
        if (value.hasChance()) {
            json.addProperty("chance", (Number)value.getChance());
        }
        return json;
    }
}

