/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.container;

import igentuman.nc.block.fission.entity.FissionControllerBE;
import igentuman.nc.container.elements.NCSlotItemHandler;
import igentuman.nc.handler.config.FissionConfig;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.util.TextUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FissionControllerContainer
extends AbstractContainerMenu {
    protected final FissionControllerBE blockEntity;
    protected final Player playerEntity;
    protected final String name = "fission_reactor_controller";
    private int slotIndex = 0;
    protected final IItemHandler playerInventory;

    public FissionControllerContainer(int pContainerId, BlockPos pos, Inventory playerInventory) {
        super((MenuType)FissionReactorRegistration.FISSION_CONTROLLER_CONTAINER.get(), pContainerId);
        this.playerEntity = playerInventory.f_35978_;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.blockEntity = (FissionControllerBE)this.playerEntity.m_20193_().m_7702_(pos);
        this.layoutPlayerInventorySlots();
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            this.m_38897_((Slot)new NCSlotItemHandler.Input((IItemHandler)h, 0, 56, 35));
            this.m_38897_((Slot)new NCSlotItemHandler.Output((IItemHandler)h, 1, 116, 35));
        });
    }

    public ItemStack m_7648_(Player pPlayer, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (slot instanceof NCSlotItemHandler.Output || slot instanceof NCSlotItemHandler.Input ? !this.m_38903_(stack, 0, 36, true) : !this.m_38903_(stack, this.f_38839_.size() - 2, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, stack);
        }
        return itemstack;
    }

    public boolean m_6875_(Player playerIn) {
        return FissionControllerContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)FissionReactorRegistration.FISSION_BLOCKS.get("fission_reactor_controller").get()));
    }

    public Component getTitle() {
        return TextUtils.__("block.nuclearcraft.fission_reactor_controller", new Object[0]);
    }

    public boolean isCasingValid() {
        return this.blockEntity.isCasingValid;
    }

    public int[] getDimensions() {
        return new int[]{this.getHeight(), this.getWidth(), this.getDepth()};
    }

    public int getDepth() {
        return this.blockEntity.getDepth();
    }

    public int getWidth() {
        return this.blockEntity.getWidth();
    }

    public int getHeight() {
        return this.blockEntity.getHeight();
    }

    public boolean isInteriorValid() {
        return this.blockEntity.isInternalValid;
    }

    public BlockPos getValidationResultData() {
        return this.blockEntity.errorBlockPos;
    }

    public String getValidationResultKey() {
        return this.blockEntity.validationResult.messageKey;
    }

    public int getEnergy() {
        return TextUtils.energy2Display(this.blockEntity.energyStorage.getEnergyStored());
    }

    public double getHeat() {
        return Math.floor(this.blockEntity.heat);
    }

    public double getProgress() {
        return this.blockEntity.getDepletionProgress();
    }

    private void addSlotRange(IItemHandler handler, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, this.slotIndex, x, y));
            x += dx;
            ++this.slotIndex;
        }
    }

    protected void addSlotBox(IItemHandler handler, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            this.addSlotRange(handler, x, y, horAmount, dx);
            y += dy;
        }
    }

    protected void layoutPlayerInventorySlots() {
        int leftCol = 8;
        int topRow = 153;
        this.addSlotRange(this.playerInventory, leftCol, topRow, 9, 18);
        this.addSlotBox(this.playerInventory, leftCol, topRow -= 58, 9, 18, 3, 18);
    }

    public int getFuelCellsCount() {
        return this.blockEntity.fuelCellsCount;
    }

    public ItemStack getResultStack() {
        if (this.blockEntity.recipeInfo.recipe != null) {
            return this.blockEntity.recipeInfo.recipe.getResultItem();
        }
        return ItemStack.f_41583_;
    }

    public int getMaxEnergy() {
        return TextUtils.energy2Display(this.blockEntity.energyStorage.getMaxEnergyStored());
    }

    public double getMaxHeat() {
        return this.blockEntity.getMaxHeat();
    }

    public String getEfficiency() {
        return TextUtils.roundFormat(this.blockEntity.efficiency);
    }

    public double getRawEfficiency() {
        return this.blockEntity.efficiency;
    }

    public String getNetHeat() {
        return TextUtils.roundFormat(this.blockEntity.heatPerTick - this.blockEntity.heatSinkCooling - this.blockEntity.activeCooling);
    }

    public int getCooling() {
        return (int)(this.blockEntity.heatSinkCooling + this.blockEntity.activeCooling);
    }

    public String getHeating() {
        return TextUtils.roundFormat(this.blockEntity.heatPerTick);
    }

    public int getHeatSinksCount() {
        return this.blockEntity.heatSinksCount;
    }

    public int getModeratorsCount() {
        return this.blockEntity.moderatorsCount;
    }

    public int energyPerTick() {
        return TextUtils.energy2Display(this.blockEntity.energyPerTick);
    }

    public String getHeatMultiplier() {
        return TextUtils.numberFormat(this.blockEntity.heatMultiplier);
    }

    public boolean hasRecipe() {
        return this.blockEntity.hasRecipe();
    }

    public ItemStack getInputStack() {
        return this.blockEntity.getCurrentFuel();
    }

    public int getIrradiatorsConnections() {
        return this.blockEntity.irradiationLines;
    }

    public BlockPos getPosition() {
        return this.blockEntity.m_58899_();
    }

    public boolean isBoilingMode() {
        if (!((Boolean)FissionConfig.FISSION_CONFIG.BOILING_ENABLED.get()).booleanValue()) {
            return false;
        }
        return this.blockEntity.isSteamMode;
    }

    public int getModeTimer() {
        return this.blockEntity.toggleModeTimer;
    }

    public FluidTank getFluidTank(int i) {
        return this.blockEntity.getFluidTank(i);
    }

    public int getSteamPerTick() {
        return this.blockEntity.steamPerTick;
    }

    public String getModerationLevel() {
        return TextUtils.numberFormat(this.blockEntity.getModerationLevel() * 100.0);
    }

    public int getReactivity() {
        return this.blockEntity.reactivityLevel;
    }

    public int getMaxBoilingRate() {
        return this.blockEntity.maxSteamOutput;
    }

    public int getBoilingPenalty() {
        return (int)this.blockEntity.boilingPenalty;
    }

    public boolean canAnalyze() {
        return this.blockEntity.analyzeDelay < 1;
    }
}

