/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.container;

import igentuman.nc.block.fusion.entity.FusionCoreBE;
import igentuman.nc.multiblock.fusion.FusionReactorRegistration;
import igentuman.nc.util.TextUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class FusionCoreContainer
extends AbstractContainerMenu {
    protected final FusionCoreBE blockEntity;
    protected final Player playerEntity;
    protected final String name = "fusion_core";
    private int slotIndex = 0;
    protected final IItemHandler playerInventory;

    public FusionCoreContainer(int pContainerId, BlockPos pos, Inventory playerInventory) {
        super((MenuType)FusionReactorRegistration.FUSION_CORE_CONTAINER.get(), pContainerId);
        this.playerEntity = playerInventory.f_35978_;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.blockEntity = (FusionCoreBE)this.playerEntity.m_20193_().getExistingBlockEntity(pos);
        this.layoutPlayerInventorySlots();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return FusionCoreContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)FusionReactorRegistration.FUSION_BLOCKS.get("fusion_core").get())) || FusionCoreContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)FusionReactorRegistration.FUSION_CORE_PROXY.get()));
    }

    public Component getTitle() {
        return TextUtils.__("block.nuclearcraft.fusion_core", new Object[0]);
    }

    public boolean isCasingValid() {
        return this.blockEntity.isCasingValid;
    }

    public BlockPos getValidationResultData() {
        return this.blockEntity.errorBlockPos;
    }

    public String getValidationResultKey() {
        return this.blockEntity.validationResult.messageKey;
    }

    public int getEnergy() {
        return TextUtils.energy2Display(this.blockEntity.energyStorage.getEnergyStored());
    }

    public double getHeat() {
        return this.blockEntity.reactorHeat;
    }

    private void addSlotRange(IItemHandler handler, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, this.slotIndex, x, y));
            x += dx;
            ++this.slotIndex;
        }
    }

    protected void addSlotBox(IItemHandler handler, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            this.addSlotRange(handler, x, y, horAmount, dx);
            y += dy;
        }
    }

    protected void layoutPlayerInventorySlots() {
        int leftCol = 27;
        int topRow = 163;
        this.addSlotRange(this.playerInventory, leftCol, topRow, 9, 18);
        this.addSlotBox(this.playerInventory, leftCol, topRow -= 58, 9, 18, 3, 18);
    }

    public int getMaxEnergy() {
        return TextUtils.energy2Display(this.blockEntity.energyStorage().getMaxEnergyStored());
    }

    public double getMaxHeat() {
        return this.blockEntity.getMaxHeat();
    }

    public String getEfficiency() {
        return TextUtils.roundFormat(this.blockEntity.efficiency * 100.0);
    }

    public int energyPerTick() {
        return TextUtils.energy2Display(this.blockEntity.energyPerTick);
    }

    public boolean hasRecipe() {
        return this.blockEntity.hasRecipe();
    }

    public double getElectromagnetsField() {
        return this.blockEntity.magneticFieldStrength;
    }

    public String getAmplifierVoltage() {
        return TextUtils.scaledFormat(this.blockEntity.rfAmplification);
    }

    public String getElectromagnetsPower() {
        return TextUtils.scaledFormat(this.blockEntity.magnetsPower);
    }

    public int getElectromagnetsMaxTemp() {
        return this.blockEntity.maxMagnetsTemp;
    }

    public String getAmplifierPower() {
        return TextUtils.scaledFormat(this.blockEntity.rfAmplifiersPower);
    }

    public String getAmplifierMaxTemp() {
        return TextUtils.scaledFormat(this.blockEntity.minRFAmplifiersTemp);
    }

    public FluidTank getFluidTank(int i) {
        return this.blockEntity.getFluidTank(i);
    }

    public int getAmplification() {
        return this.blockEntity.rfAmplificationRatio;
    }

    public BlockPos getBlockPos() {
        return this.blockEntity.m_58899_();
    }

    public boolean isReady() {
        return this.isCasingValid() && this.hasAmplifiers() && this.hasMagnets() && this.hasCoolant() && this.hasRecipe() && this.getCharge() == 100 && this.hasEnoughEnergy();
    }

    public boolean hasEnoughEnergy() {
        return this.blockEntity.hasEnoughEnergy();
    }

    public boolean hasCoolant() {
        return this.blockEntity.hasCoolant();
    }

    public boolean hasMagnets() {
        return this.blockEntity.magnetsPower > 0;
    }

    public boolean hasAmplifiers() {
        return this.blockEntity.amplifiers > 0;
    }

    public int getCharge() {
        return this.blockEntity.functionalBlocksCharge;
    }

    public double getPlasmaHeat() {
        return this.blockEntity.plasmaTemperature;
    }

    public double getOptimalTemp() {
        return this.blockEntity.getOptimalTemperature();
    }

    public int requiredEnergy() {
        return TextUtils.energy2Display(this.blockEntity.rfAmplifiersPower + this.blockEntity.magnetsPower);
    }

    public boolean isRunning() {
        return this.blockEntity.isRunning();
    }

    public int getPlasmaStability() {
        return (int)(this.blockEntity.getPlasmaStability() * 100.0);
    }

    public int getAmlificationAdjustment() {
        return this.blockEntity.amplificationAdjustment;
    }

    public byte redstoneMode() {
        return this.blockEntity.redstoneMode;
    }

    public byte analogSignal() {
        return this.blockEntity.analogSignal;
    }

    public boolean canAnalyze() {
        return this.blockEntity.canAnalyze();
    }

    public BlockPos getPosition() {
        return this.blockEntity.m_58899_();
    }
}

