/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.container;

import igentuman.nc.block.entity.processor.NCProcessorBE;
import igentuman.nc.content.processors.ProcessorPrefab;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.setup.registration.NCProcessors;
import igentuman.nc.util.TextUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public class NCEnergyContainer
extends AbstractContainerMenu {
    protected NCProcessorBE blockEntity;
    protected Player playerEntity;
    protected IItemHandler playerInventory;
    protected ProcessorPrefab processor;
    public int slotIndex = 0;
    protected String name;

    public NCEnergyContainer(@Nullable MenuType<?> pMenuType, int pContainerId) {
        super(pMenuType, pContainerId);
    }

    public NCEnergyContainer(int windowId, BlockPos pos, Inventory playerInventory, Player player, String name) {
        this((MenuType)NCProcessors.PROCESSORS_CONTAINERS.get(name).get(), windowId);
        this.blockEntity = (NCProcessorBE)player.m_20193_().getExistingBlockEntity(pos);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.name = name;
        this.processor = Processors.all().get(name);
        this.processorSlots();
        this.layoutPlayerInventorySlots();
    }

    public ProcessorPrefab getProcessor() {
        return this.processor;
    }

    private void processorSlots() {
        int finalUx;
        int itemIdx = 0;
        for (int[] pos : this.processor.getSlotsConfig().getSlotPositions()) {
            if (!this.processor.getSlotsConfig().getSlotType(itemIdx).contains("item")) continue;
            int idx = itemIdx++;
            this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> this.m_38897_((Slot)new SlotItemHandler(h, idx, pos[0], pos[1])));
        }
        int ux = 154;
        if (this.getProcessor().supportSpeedUpgrade) {
            int idx = itemIdx++;
            finalUx = ux;
            this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> this.m_38897_((Slot)new SlotItemHandler(h, idx, finalUx, 77)));
            ux -= 18;
        }
        if (this.getProcessor().supportEnergyUpgrade) {
            int idx = itemIdx;
            finalUx = ux;
            this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> this.m_38897_((Slot)new SlotItemHandler(h, idx, finalUx, 77)));
        }
    }

    public ItemStack m_7648_(Player pPlayer, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(stack, 1, 37, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack, itemstack);
            } else if (ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0 ? !this.m_38903_(stack, 0, 1, false) : (index < 28 ? !this.m_38903_(stack, 28, 37, false) : index < 37 && !this.m_38903_(stack, 1, 28, false))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, stack);
        }
        return itemstack;
    }

    private void addSlotRange(IItemHandler handler, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, this.slotIndex, x, y));
            x += dx;
            ++this.slotIndex;
        }
    }

    protected void addSlotBox(IItemHandler handler, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            this.addSlotRange(handler, x, y, horAmount, dx);
            y += dy;
        }
    }

    protected void layoutPlayerInventorySlots() {
        int leftCol = 10;
        int topRow = 96;
        this.addSlotBox(this.playerInventory, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, leftCol, topRow += 58, 9, 18);
    }

    public boolean m_6875_(Player playerIn) {
        return NCEnergyContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)NCProcessors.PROCESSORS.get(this.name).get()));
    }

    public Component getTitle() {
        return TextUtils.__("block.nuclearcraft." + this.name, new Object[0]);
    }

    public IEnergyStorage getEnergy() {
        return (IEnergyStorage)this.blockEntity.getEnergy().orElse(null);
    }

    public double getProgress() {
        return this.blockEntity.getProgress();
    }
}

