/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.energy;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.energy.NCEnergy;
import igentuman.nc.block.storage.entity.BatteryBE;
import igentuman.nc.handler.config.CommonConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class BatteryBlocks {
    private static final HashMap<String, BatteryBlockPrefab> all = new HashMap();
    private static final HashMap<String, BatteryBlockPrefab> registered = new HashMap();

    public static HashMap<String, BatteryBlockPrefab> all() {
        if (all.isEmpty()) {
            all.put("basic_voltaic_pile", new BatteryBlockPrefab("basic_voltaic_pile", 1600000, 1));
            all.put("advanced_voltaic_pile", new BatteryBlockPrefab("advanced_voltaic_pile", 6400000, 2));
            all.put("du_voltaic_pile", new BatteryBlockPrefab("du_voltaic_pile", 25600000, 3));
            all.put("elite_voltaic_pile", new BatteryBlockPrefab("elite_voltaic_pile", 102400000, 4));
            all.put("basic_lithium_ion_battery", new BatteryBlockPrefab("basic_lithium_ion_battery", 32000000, 3));
            all.put("advanced_lithium_ion_battery", new BatteryBlockPrefab("advanced_lithium_ion_battery", 128000000, 4));
            all.put("du_lithium_ion_battery", new BatteryBlockPrefab("du_lithium_ion_battery", 512000000, 5));
            all.put("elite_lithium_ion_battery", new BatteryBlockPrefab("elite_lithium_ion_battery", 2048000000, 6));
        }
        return all;
    }

    public static HashMap<String, BatteryBlockPrefab> registered() {
        if (registered.isEmpty()) {
            for (String name : BatteryBlocks.all().keySet()) {
                if (!BatteryBlocks.all().get(name).config().isRegistered()) continue;
                registered.put(name, BatteryBlocks.all().get(name));
            }
        }
        return registered;
    }

    public static List<Boolean> initialRegistered() {
        ArrayList<Boolean> tmp = new ArrayList<Boolean>();
        for (String name : BatteryBlocks.all().keySet()) {
            tmp.add(true);
        }
        return tmp;
    }

    public static List<Integer> initialPower() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (String name : BatteryBlocks.all().keySet()) {
            tmp.add(BatteryBlocks.all().get(name).getStorage());
        }
        return tmp;
    }

    public static class BatteryBlockPrefab {
        private boolean registered = true;
        private boolean initialized = false;
        private final String name;
        protected int storage = 0;
        protected int tier = 0;
        private BlockEntityType.BlockEntitySupplier<? extends NCEnergy> blockEntity;

        public BatteryBlockPrefab(String name, int storage, int tier) {
            this.storage = storage;
            this.blockEntity = BatteryBE::new;
            this.name = name;
            this.tier = tier;
        }

        public int getStorage() {
            return this.storage;
        }

        public BatteryBlockPrefab setStorage(int capacity) {
            this.storage = this.storage;
            return this;
        }

        public BatteryBlockPrefab config() {
            if (!this.initialized) {
                try {
                    int id = BatteryBlocks.all().keySet().stream().toList().indexOf(this.name);
                    this.registered = (Boolean)((List)CommonConfig.ENERGY_STORAGE.REGISTER_ENERGY_BLOCK.get()).get(id);
                    this.storage = (Integer)((List)CommonConfig.ENERGY_STORAGE.ENERGY_BLOCK_STORAGE.get()).get(id);
                    this.initialized = true;
                }
                catch (Exception e) {
                    NuclearCraft.LOGGER.error("Error while loading config for " + this.name + "!");
                }
            }
            return this;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public BlockEntityType.BlockEntitySupplier<? extends NCEnergy> getBlockEntity() {
            return this.blockEntity;
        }

        public BatteryBlockPrefab setBlockEntity(BlockEntityType.BlockEntitySupplier<? extends NCEnergy> blockEntity) {
            this.blockEntity = blockEntity;
            return this;
        }

        public CommonConfig.GTCEUCompatibilityConfig.GTCEUTier getEnergyTier() {
            return CommonConfig.GTCEUCompatibilityConfig.GTCEUTier.values()[this.tier];
        }
    }
}

