/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.particles.creator;

import igentuman.nc.content.particles.Particle;
import igentuman.nc.content.particles.ParticleIngredient;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.creator.IIngredientCreator;
import igentuman.nc.util.annotation.NothingNullByDefault;
import java.util.Objects;

@NothingNullByDefault
public interface IParticleIngredientCreator
extends IIngredientCreator<Particle, ParticleStack, ParticleIngredient> {
    @Override
    default public ParticleIngredient from(ParticleStack instance) {
        Objects.requireNonNull(instance, "ParticleIngredients cannot be created from a null ParticleStack.");
        return this.from(instance, instance.getAmount());
    }

    @Override
    default public ParticleIngredient from(ParticleStack stack, int amount) {
        Objects.requireNonNull(stack, "ParticleIngredients cannot be created from a null ParticleStack.");
        if (stack.getParticle() == null) {
            throw new IllegalArgumentException("ParticleIngredients cannot be created using a stack with no particle.");
        }
        stack = stack.copy();
        return this.from(stack.getParticle(), amount, stack.getMeanEnergy(), stack.getFocus());
    }

    @Override
    default public ParticleIngredient from(Particle particle) {
        return this.from(particle, 1, 0L, 0.0);
    }

    @Override
    default public ParticleIngredient from(Particle particle, int amount) {
        return this.from(particle, amount, 0L, 0.0);
    }

    default public ParticleIngredient from(Particle particle, int amount, long meanEnergy) {
        return this.from(particle, amount, meanEnergy, 0.0);
    }

    public ParticleIngredient from(Particle var1, int var2, long var3, double var5);
}

