/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen.tags;

import igentuman.nc.NuclearCraft;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.multiblock.fusion.FusionReactorRegistration;
import igentuman.nc.setup.registration.FissionFuel;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.setup.registration.Tags;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.RegistryObject;

public class NCItemTags
extends ItemTagsProvider {
    public NCItemTags(DataGenerator generator, BlockTagsProvider blockTags, GatherDataEvent event) {
        super(generator.getPackOutput(), event.getLookupProvider(), blockTags.m_274426_(), "nuclearcraft", event.getExistingFileHelper());
    }

    protected void m_6577_(HolderLookup.Provider provider) {
        this.ores();
        this.blocks();
        this.ingots();
        this.chunks();
        this.dusts();
        this.plates();
        this.nuggets();
        this.gems();
        this.parts();
        this.fuel();
        this.isotopes();
        this.waste();
        this.disks();
        this.ionSources();
        for (RegistryObject<Item> magnet : NCItems.NC_ELECTROMAGNETS_ITEMS.values()) {
            this.m_206424_(NCItems.ELECTROMAGNETS_ITEMS).m_255245_((Object)((Item)magnet.get()));
            this.m_206424_(AcceleratorRegistration.ACCELERATOR_INNER_ITEMS).m_255245_((Object)((Item)magnet.get()));
        }
        for (RegistryObject<Item> amplifier : NCItems.NC_RF_AMPLIFIERS_ITEMS.values()) {
            this.m_206424_(NCItems.AMPLIFIERS_ITEMS).m_255245_((Object)((Item)amplifier.get()));
            this.m_206424_(AcceleratorRegistration.ACCELERATOR_INNER_ITEMS).m_255245_((Object)((Item)amplifier.get()));
        }
        this.m_206424_(FusionReactorRegistration.CASING_ITEMS).m_255179_((Object[])new Item[]{(Item)FusionReactorRegistration.FUSION_ITEMS.get("fusion_reactor_casing").get(), (Item)FusionReactorRegistration.FUSION_ITEMS.get("fusion_reactor_casing_glass").get()});
        this.m_206424_(FissionReactorRegistration.MODERATORS_ITEMS).m_255179_((Object[])new Item[]{(Item)NCItems.NC_BLOCKS_ITEMS.get("graphite").get(), (Item)NCItems.NC_BLOCKS_ITEMS.get("beryllium").get()});
        this.m_206424_(FissionReactorRegistration.CASING_ITEMS).m_255179_((Object[])new Item[]{(Item)FissionReactorRegistration.FISSION_BLOCK_ITEMS.get("fission_reactor_casing").get(), (Item)FissionReactorRegistration.FISSION_BLOCK_ITEMS.get("fission_reactor_controller").get(), (Item)FissionReactorRegistration.FISSION_BLOCK_ITEMS.get("fission_reactor_glass").get(), (Item)FissionReactorRegistration.FISSION_BLOCK_ITEMS.get("fission_reactor_port").get()});
    }

    private void ionSources() {
        for (String name : NCItems.ION_SOURCES.keySet()) {
            this.m_206424_(Tags.ION_SOURCE_TAG.get(name)).m_255245_((Object)((Item)NCItems.ION_SOURCES.get(name).get()));
        }
    }

    private void disks() {
        for (String name : NCItems.NC_RECORDS.keySet()) {
            this.m_206424_(ItemTags.f_13158_).m_255245_((Object)((Item)NCItems.NC_RECORDS.get(name).get()));
        }
    }

    private void waste() {
        for (String name : FissionFuel.NC_WASTE.keySet()) {
            this.m_206424_(Tags.NC_WASTE_TAG.get(name)).m_255245_((Object)((Item)FissionFuel.NC_WASTE.get(name).get()));
        }
    }

    private void isotopes() {
        for (String name : FissionFuel.NC_ISOTOPES.keySet()) {
            this.m_206424_(Tags.NC_ISOTOPE_TAG.get(name.replaceAll("_ox|_ni|_za", ""))).m_255245_((Object)((Item)FissionFuel.NC_ISOTOPES.get(name).get()));
        }
    }

    private void fuel() {
        for (List<String> name : FissionFuel.NC_FUEL.keySet()) {
            this.m_206424_(Tags.REACTOR_FUEL_TAG.get(name.get(1) + name.get(2))).m_255245_((Object)((Item)FissionFuel.NC_FUEL.get(name).get()));
        }
        for (List<String> name : FissionFuel.NC_DEPLETED_FUEL.keySet()) {
            this.m_206424_(Tags.REACTOR_DEPLETED_FUEL_TAG.get(name.get(1) + name.get(2))).m_255245_((Object)((Item)FissionFuel.NC_DEPLETED_FUEL.get(name).get()));
        }
    }

    private void parts() {
        for (String name : NCItems.NC_PARTS.keySet()) {
            this.m_206424_(Tags.PARTS_TAG).m_255245_((Object)((Item)NCItems.NC_PARTS.get(name).get()));
        }
    }

    private void gems() {
        for (String name : NCItems.NC_GEMS.keySet()) {
            this.m_206424_(Tags.Items.GEMS).m_255245_((Object)((Item)NCItems.NC_GEMS.get(name).get()));
            this.m_206424_(Tags.GEMS_TAG.get(name)).m_255245_((Object)((Item)NCItems.NC_GEMS.get(name).get()));
        }
    }

    private void ingots() {
        for (String name : NCItems.NC_INGOTS.keySet()) {
            this.m_206424_(Tags.Items.INGOTS).m_255245_((Object)((Item)NCItems.NC_INGOTS.get(name).get()));
            this.m_206424_(Tags.INGOTS_TAG.get(name)).m_255245_((Object)((Item)NCItems.NC_INGOTS.get(name).get()));
            this.m_206424_(Tags.INGOTS_TAG.get(name)).m_255245_((Object)((Item)NCItems.NC_INGOTS.get(name).get()));
            TagKey C_INGOTS = TagKey.m_203882_(Registries.ITEM_REGISTRY, (ResourceLocation)NuclearCraft.resourceLoc("ingots/" + name));
            this.m_206424_(C_INGOTS).m_255245_((Object)((Item)NCItems.NC_INGOTS.get(name).get()));
        }
        this.m_206424_(Tags.INGOTS_TAG.get("aluminium")).m_255245_((Object)((Item)NCItems.NC_INGOTS.get("aluminum").get()));
    }

    private void nuggets() {
        for (String name : NCItems.NC_NUGGETS.keySet()) {
            this.m_206424_(Tags.Items.NUGGETS).m_255245_((Object)((Item)NCItems.NC_NUGGETS.get(name).get()));
            this.m_206424_(Tags.NUGGETS_TAG.get(name)).m_255245_((Object)((Item)NCItems.NC_NUGGETS.get(name).get()));
            TagKey C_NUGGETS = TagKey.m_203882_(Registries.ITEM_REGISTRY, (ResourceLocation)NuclearCraft.resourceLoc("nuggets/" + name));
            this.m_206424_(C_NUGGETS).m_255245_((Object)((Item)NCItems.NC_NUGGETS.get(name).get()));
        }
        this.m_206424_(Tags.NUGGETS_TAG.get("aluminium")).m_255245_((Object)((Item)NCItems.NC_NUGGETS.get("aluminum").get()));
    }

    private void plates() {
        for (String name : NCItems.NC_PLATES.keySet()) {
            this.m_206424_(Tags.PLATE_TAG).m_255245_((Object)((Item)NCItems.NC_PLATES.get(name).get()));
            this.m_206424_(Tags.PLATES_TAG.get(name)).m_255245_((Object)((Item)NCItems.NC_PLATES.get(name).get()));
            TagKey C_PLATES = TagKey.m_203882_(Registries.ITEM_REGISTRY, (ResourceLocation)NuclearCraft.resourceLoc("plates/" + name));
            this.m_206424_(C_PLATES).m_255245_((Object)((Item)NCItems.NC_PLATES.get(name).get()));
        }
        this.m_206424_(Tags.PLATES_TAG.get("aluminium")).m_255245_((Object)((Item)NCItems.NC_PLATES.get("aluminum").get()));
    }

    private void dusts() {
        for (String name : NCItems.NC_DUSTS.keySet()) {
            this.m_206424_(Tags.Items.DUSTS).m_255245_((Object)((Item)NCItems.NC_DUSTS.get(name).get()));
            this.m_206424_(Tags.DUSTS_TAG.get(name)).m_255245_((Object)((Item)NCItems.NC_DUSTS.get(name).get()));
            TagKey C_DUSTS = TagKey.m_203882_(Registries.ITEM_REGISTRY, (ResourceLocation)NuclearCraft.resourceLoc("dusts/" + name));
            this.m_206424_(C_DUSTS).m_255245_((Object)((Item)NCItems.NC_DUSTS.get(name).get()));
        }
        this.m_206424_(Tags.DUSTS_TAG.get("aluminium")).m_255245_((Object)((Item)NCItems.NC_DUSTS.get("aluminum").get()));
        this.m_206424_(Tags.DUSTS_TAG.get("salt")).m_255245_((Object)((Item)NCItems.NC_ITEMS.get("salt").get()));
        this.m_206424_(Tags.DUSTS_TAG.get("sodium_chloride")).m_255245_((Object)((Item)NCItems.NC_ITEMS.get("salt").get()));
    }

    private void chunks() {
        for (String name : NCItems.NC_CHUNKS.keySet()) {
            this.m_206424_(Tags.Items.RAW_MATERIALS).m_255245_((Object)((Item)NCItems.NC_CHUNKS.get(name).get()));
            this.m_206424_(Tags.CHUNKS_TAG.get(name)).m_255245_((Object)((Item)NCItems.NC_CHUNKS.get(name).get()));
        }
    }

    private void ores() {
        for (String ore : NCItems.ORE_BLOCK_ITEMS.keySet()) {
            this.m_206424_(Tags.Items.ORES).m_255245_((Object)((Item)NCItems.ORE_BLOCK_ITEMS.get(ore).get()));
            TagKey C_DUSTS = TagKey.m_203882_(Registries.ITEM_REGISTRY, (ResourceLocation)NuclearCraft.resourceLoc("ores/" + ore));
            this.m_206424_(C_DUSTS).m_255245_((Object)((Item)NCItems.ORE_BLOCK_ITEMS.get(ore).get()));
            this.m_206424_(Tags.ORE_ITEM_TAGS.get(ore.replaceAll("_deepslate|_end|_nether", ""))).m_255245_((Object)((Item)NCItems.ORE_BLOCK_ITEMS.get(ore).get()));
        }
    }

    private void blocks() {
        for (String name : NCItems.NC_BLOCKS_ITEMS.keySet()) {
            this.m_206424_(Tags.Items.STORAGE_BLOCKS).m_255245_((Object)((Item)NCItems.NC_BLOCKS_ITEMS.get(name).get()));
            if (Tags.BLOCK_ITEM_TAGS.get(name) == null) continue;
            this.m_206424_(Tags.BLOCK_ITEM_TAGS.get(name)).m_255245_((Object)((Item)NCItems.NC_BLOCKS_ITEMS.get(name).get()));
        }
    }

    public String m_6055_() {
        return "NuclearCraft Item Tags";
    }
}

