/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.entity;

import igentuman.nc.client.model.ModelWastelandBoss;
import igentuman.nc.client.renderer.WastelandBossRenderer;
import igentuman.nc.entity.EntityFeralGhoul;
import igentuman.nc.entity.EntityWastelandProjectile;
import igentuman.nc.entity.goal.RadiationBurstGoal;
import igentuman.nc.entity.goal.RangedAttackGoal;
import igentuman.nc.entity.goal.SlamAttackGoal;
import igentuman.nc.entity.goal.SummonGhoulsGoal;
import igentuman.nc.entity.goal.ThrowSpamGoal;
import igentuman.nc.radiation.data.PlayerRadiationProvider;
import igentuman.nc.setup.registration.Entities;
import igentuman.nc.setup.registration.NCSounds;
import igentuman.nc.setup.registration.NcParticleTypes;
import igentuman.nc.setup.registration.WorldGeneration;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityWastelandBoss
extends EntityFeralGhoul {
    public static final int BOSS_RADIATION_AMOUNT = 20000000;
    public static final float SLAM_ATTACK_RANGE = 8.0f;
    public static final int SLAM_ATTACK_COOLDOWN = 60;
    public static final int RADIATION_BURST_COOLDOWN = 60;
    public static final float RADIATION_BURST_RANGE = 8.0f;
    public static final int RADIATION_BURST_AMOUNT = 10000000;
    public static final int SUMMON_COOLDOWN = 120;
    public static final float SUMMON_RANGE = 32.0f;
    public static final int MAX_SUMMONS = 8;
    public static final int RANGED_ATTACK_COOLDOWN = 20;
    public static final float MIN_RANGED_ATTACK_DISTANCE = 8.0f;
    public static final float MAX_RANGED_ATTACK_DISTANCE = 64.0f;
    public static final int THROW_SPAM_COOLDOWN = 300;
    public static final int THROW_SPAM_DURATION = 200;
    public static final int THROW_SPAM_INTERVAL = 8;
    public static final float THROW_SPAM_RANGE = 32.0f;
    public int slamAttackCooldownRemaining = 0;
    public int radiationBurstCooldownRemaining = 0;
    public int summonCooldownRemaining = 0;
    public int rangedAttackCooldownRemaining = 0;
    public int throwSpamCooldownRemaining = 0;
    public int throwSpamDurationRemaining = 0;
    public int throwSpamIntervalRemaining = 0;
    public boolean hasEnteredEnragedState = false;
    public final Random random = new Random();
    public boolean isExecutingAttack = false;
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.m_237115_((String)"entity.nuclearcraft.feral_ghoul_boss"), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);

    public EntityWastelandBoss(Level pLevel) {
        this((EntityType)Entities.FERAL_GHOUL_BOSS.get(), pLevel);
    }

    public EntityWastelandBoss(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 250;
        this.m_6210_();
        this.m_21530_();
    }

    @Override
    protected SoundEvent m_7515_() {
        return (SoundEvent)NCSounds.BOSS_IDLE.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)NCSounds.BOSS_HIT.get();
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new EntityFeralGhoul.FeralGhoulVaultGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 64.0f));
        this.f_21345_.m_25352_(20, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(5, (Goal)new SlamAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RadiationBurstGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SummonGhoulsGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ThrowSpamGoal(this));
    }

    public static AttributeSupplier.Builder m_34328_() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22277_, 70.0).m_22268_(Attributes.f_22278_, 2.8).m_22268_(Attributes.f_22284_, 20.0);
    }

    public static boolean checkFeralGhoulBossSpawnRules(EntityType<EntityWastelandBoss> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!Monster.m_219013_(entityType, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random)) {
            return false;
        }
        return level.m_204166_(pos).m_203656_(WorldGeneration.WASTELAND);
    }

    @Override
    public boolean m_7327_(Entity pEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)8);
        boolean attackResult = super.m_7327_(pEntity);
        if (attackResult && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            player.getCapability(PlayerRadiationProvider.PLAYER_RADIATION).ifPresent(radiation -> {
                long currentRadiation = radiation.getRadiation();
                radiation.setRadiation(currentRadiation + 20000000L);
            });
            Vec3 knockbackDirection = pEntity.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(2.0);
            pEntity.m_20256_(pEntity.m_20184_().m_82549_(knockbackDirection));
            ((LivingEntity)pEntity).m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 1));
        }
        return attackResult;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.slamAttackCooldownRemaining > 0) {
            --this.slamAttackCooldownRemaining;
        }
        if (this.radiationBurstCooldownRemaining > 0) {
            --this.radiationBurstCooldownRemaining;
        }
        if (this.summonCooldownRemaining > 0) {
            --this.summonCooldownRemaining;
        }
        if (this.rangedAttackCooldownRemaining > 0) {
            --this.rangedAttackCooldownRemaining;
        }
        if (this.throwSpamCooldownRemaining > 0) {
            --this.throwSpamCooldownRemaining;
        }
        if (this.throwSpamDurationRemaining > 0) {
            --this.throwSpamDurationRemaining;
            if (this.throwSpamIntervalRemaining > 0) {
                --this.throwSpamIntervalRemaining;
            }
        }
        if (!this.hasEnteredEnragedState && this.isEnraged()) {
            this.hasEnteredEnragedState = true;
            this.m_5496_((SoundEvent)NCSounds.BOSS_ANGRY.get(), 1.5f, 0.6f);
            this.m_5496_(SoundEvents.f_11894_, 1.0f, 0.8f);
            this.m_9236_().m_7605_((Entity)this, (byte)10);
        }
    }

    public void executeRadiationBurst() {
        if (this.radiationBurstCooldownRemaining <= 0 && !this.isExecutingAttack) {
            this.isExecutingAttack = true;
            this.m_5496_((SoundEvent)NCSounds.BOSS_ANGRY.get(), 0.7f, 1.0f);
            this.m_5496_((SoundEvent)NCSounds.GEIGER_SOUNDS.get(2).get(), 0.7f, 1.0f);
            AABB radiationBox = this.m_20191_().m_82400_(8.0);
            List nearbyPlayers = this.m_9236_().m_45976_(Player.class, radiationBox);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                double zPos;
                double yPos;
                double xPos;
                ServerLevel serverLevel = (ServerLevel)level;
                double entityY = this.m_20186_() + 0.5;
                Vec3 center = this.m_20182_();
                for (int i = 0; i < 50; ++i) {
                    double angle = this.random.nextDouble() * Math.PI * 2.0;
                    double radius = this.random.nextDouble() * 8.0;
                    double height = this.random.nextDouble() * 3.0;
                    xPos = center.f_82479_ + radius * Math.cos(angle);
                    yPos = entityY + height + 1.0;
                    zPos = center.f_82481_ + radius * Math.sin(angle);
                    double xVel = (xPos - center.f_82479_) * 0.05;
                    double yVel = this.random.nextDouble() * 0.05;
                    double zVel = (zPos - center.f_82481_) * 0.05;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)NcParticleTypes.RADIATION.get()), xPos, yPos, zPos, 1, xVel, yVel, zVel, 0.02);
                }
                for (int ring = 0; ring < 3; ++ring) {
                    double ringRadius = (float)(ring + 1) * 2.6666667f;
                    int particlesInRing = 20 + ring * 10;
                    for (int i = 0; i < particlesInRing; ++i) {
                        double angle = Math.PI * 2 * (double)i / (double)particlesInRing;
                        xPos = center.f_82479_ + ringRadius * Math.cos(angle);
                        yPos = center.f_82480_ + 0.2;
                        zPos = center.f_82481_ + ringRadius * Math.sin(angle);
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)NcParticleTypes.RADIATION.get()), xPos, yPos, zPos, 1, 0.0, 0.05, 0.0, 0.01);
                    }
                }
            }
            for (Player player : nearbyPlayers) {
                player.getCapability(PlayerRadiationProvider.PLAYER_RADIATION).ifPresent(radiation -> {
                    long currentRadiation = radiation.getRadiation();
                    radiation.setRadiation(currentRadiation + 10000000L);
                });
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 20, 0));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 10, 0));
            }
            this.radiationBurstCooldownRemaining = 60;
            this.isExecutingAttack = false;
        }
    }

    public void executeSummonAttack() {
        if (this.summonCooldownRemaining <= 0 && !this.isExecutingAttack && !this.m_9236_().m_5776_()) {
            this.isExecutingAttack = true;
            this.m_5496_((SoundEvent)NCSounds.BOSS_ANGRY.get(), 0.4f, 0.4f);
            this.m_5496_(SoundEvents.f_12500_, 1.0f, 0.7f);
            LivingEntity target = this.m_5448_();
            if (target != null && target.m_6084_()) {
                int existingGhouls = 0;
                List nearbyGhouls = this.m_9236_().m_6443_(EntityFeralGhoul.class, this.m_20191_().m_82400_(20.0), ghoul -> !(ghoul instanceof EntityWastelandBoss));
                existingGhouls = nearbyGhouls.size();
                int spawnCount = Math.min(8, 8 - existingGhouls);
                if (spawnCount > 0) {
                    for (int i = 0; i < spawnCount; ++i) {
                        double angle = this.random.nextDouble() * Math.PI * 2.0;
                        double distance = 2.0 + this.random.nextDouble() * 30.0;
                        double xOffset = Math.sin(angle) * distance;
                        double zOffset = Math.cos(angle) * distance;
                        BlockPos spawnPos = new BlockPos((int)(target.m_20185_() + xOffset), (int)target.m_20186_(), (int)(target.m_20189_() + zOffset));
                        if (!this.m_9236_().m_8055_(spawnPos).m_60795_() || !this.m_9236_().m_8055_(spawnPos.m_7495_()).m_280296_()) continue;
                        EntityFeralGhoul ghoul2 = new EntityFeralGhoul(this.m_9236_());
                        ghoul2.m_6034_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
                        ghoul2.m_6710_(target);
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123792_, (double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 1.5, (double)spawnPos.m_123343_() + 0.5, 0.0, 0.1, 0.0);
                        this.m_9236_().m_7967_((Entity)ghoul2);
                    }
                }
            }
            this.summonCooldownRemaining = 120;
            this.isExecutingAttack = false;
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public void executeSlamAttack() {
        if (this.slamAttackCooldownRemaining <= 0 && !this.isExecutingAttack) {
            this.isExecutingAttack = true;
            this.m_5496_((SoundEvent)NCSounds.BOSS_ACTION.get(), 1.4f, 0.9f);
            this.m_5496_(SoundEvents.f_11913_, 1.0f, 0.1f);
            double entityX = this.m_20185_();
            double entityY = this.m_20186_();
            double entityZ = this.m_20189_();
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            RandomSource random = this.m_217043_();
            for (int i = 0; i < 40; ++i) {
                double angle = random.m_188500_() * Math.PI * 2.0;
                double distance = random.m_188500_() * 8.0;
                double xPos = entityX + Math.cos(angle) * distance;
                double yPos = entityY + 0.1;
                double zPos = entityZ + Math.sin(angle) * distance;
                double xVel = Math.cos(angle) * 0.15;
                double zVel = Math.sin(angle) * 0.15;
                if (i % 3 == 0) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, xPos, yPos, zPos, 1, xVel * 0.2, 0.05, zVel * 0.2, 0.01);
                    continue;
                }
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, xPos, yPos, zPos, 1, xVel, 0.1, zVel, 0.05);
            }
            AABB affectedArea = this.m_20191_().m_82400_(8.0);
            List nearbyEntities = this.m_9236_().m_6443_(LivingEntity.class, affectedArea, entity -> entity != this);
            for (LivingEntity entity2 : nearbyEntities) {
                double distance = entity2.m_20270_((Entity)this);
                float damageAmount = 10.0f * (1.0f - (float)(distance / 8.0));
                entity2.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damageAmount);
                Vec3 knockbackDirection = entity2.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                double distanceMult = Math.log(8.0 / distance) + 0.6;
                entity2.m_20334_(knockbackDirection.f_82479_ * distanceMult, 1.0 * distanceMult, knockbackDirection.f_82481_ * distanceMult);
            }
            this.isExecutingAttack = false;
            this.slamAttackCooldownRemaining = 60;
        }
    }

    public void executeRangedAttack() {
        if (this.rangedAttackCooldownRemaining <= 0 && !this.isExecutingAttack && !this.m_9236_().m_5776_()) {
            this.isExecutingAttack = true;
            this.m_5496_((SoundEvent)NCSounds.BOSS_ACTION.get(), 1.4f, 0.9f);
            this.m_5496_(SoundEvents.f_12558_, 1.0f, 0.2f);
            LivingEntity target = this.m_5448_();
            if (target != null && target.m_6084_()) {
                Vec3 eyePos = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
                Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
                Vec3 direction = targetPos.m_82546_(eyePos).m_82541_();
                Vec3 targetVelocity = target.m_20184_();
                double distance = target.m_20270_((Entity)this);
                double velocityScale = 3.0;
                double timeToHit = distance / velocityScale;
                Vec3 predictedPos = targetPos.m_82520_(targetVelocity.f_82479_ * timeToHit, 0.0, targetVelocity.f_82481_ * timeToHit);
                Vec3 adjustedDirection = predictedPos.m_82546_(eyePos).m_82541_();
                double inaccuracy = 0.1;
                double verticalAdjustment = Math.log10(distance) * 0.05;
                Vec3 rightVector = new Vec3(direction.f_82481_, 0.0, -direction.f_82479_).m_82541_().m_82490_(0.75);
                Vec3 leftVector = rightVector.m_82490_(-0.75);
                EntityWastelandProjectile leftProjectile = new EntityWastelandProjectile(this.m_9236_(), (LivingEntity)this);
                leftProjectile.m_6034_(this.m_20185_() + leftVector.f_82479_ * 1.0 + direction.f_82479_ * 0.5, this.m_20188_() - 0.3, this.m_20189_() + leftVector.f_82481_ * 1.0 + direction.f_82481_ * 0.5);
                leftProjectile.m_6686_(adjustedDirection.f_82479_, adjustedDirection.f_82480_ + verticalAdjustment, adjustedDirection.f_82481_, (float)velocityScale, (float)inaccuracy);
                this.m_9236_().m_7967_((Entity)leftProjectile);
                EntityWastelandProjectile rightProjectile = new EntityWastelandProjectile(this.m_9236_(), (LivingEntity)this);
                rightProjectile.m_6034_(this.m_20185_() + rightVector.f_82479_ * 1.0 + direction.f_82479_ * 0.5, this.m_20188_() - 0.3, this.m_20189_() + rightVector.f_82481_ * 1.0 + direction.f_82481_ * 0.5);
                rightProjectile.m_6686_(adjustedDirection.f_82479_, adjustedDirection.f_82480_ + verticalAdjustment, adjustedDirection.f_82481_, (float)velocityScale, (float)inaccuracy);
                this.m_9236_().m_7967_((Entity)rightProjectile);
            }
            this.rangedAttackCooldownRemaining = 20;
            this.isExecutingAttack = false;
        }
    }

    public void executeThrowSpamAttack() {
        if (this.throwSpamCooldownRemaining <= 0 && !this.isExecutingAttack && !this.m_9236_().m_5776_()) {
            this.isExecutingAttack = true;
            this.throwSpamDurationRemaining = 200;
            this.throwSpamIntervalRemaining = 0;
            this.m_5496_((SoundEvent)NCSounds.BOSS_ANGRY.get(), 1.2f, 0.7f);
            this.m_5496_(SoundEvents.f_12554_, 1.2f, 0.4f);
            this.m_5496_(SoundEvents.f_12363_, 0.8f, 0.6f);
            this.throwSpamCooldownRemaining = 300;
            this.isExecutingAttack = false;
        }
    }

    public void throwSpamProjectile() {
        LivingEntity target;
        if (this.throwSpamDurationRemaining > 0 && this.throwSpamIntervalRemaining <= 0 && !this.m_9236_().m_5776_() && (target = this.m_5448_()) != null && target.m_6084_() && target.m_20270_((Entity)this) <= 32.0f) {
            this.m_5496_(SoundEvents.f_12558_, 0.5f, 1.2f + this.random.nextFloat() * 0.4f);
            Vec3 eyePos = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
            Vec3 targetPos = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
            Vec3 direction = targetPos.m_82546_(eyePos).m_82541_();
            double inaccuracy = 0.3;
            double velocityScale = 2.5 + this.random.nextDouble() * 1.0;
            Vec3 targetVelocity = target.m_20184_();
            double distance = target.m_20270_((Entity)this);
            double timeToHit = distance / velocityScale;
            Vec3 predictedPos = targetPos.m_82520_(targetVelocity.f_82479_ * timeToHit, 0.0, targetVelocity.f_82481_ * timeToHit);
            Vec3 adjustedDirection = predictedPos.m_82546_(eyePos).m_82541_();
            double verticalAdjustment = Math.log10(distance) * 0.08;
            EntityWastelandProjectile projectile = new EntityWastelandProjectile(this.m_9236_(), (LivingEntity)this);
            double offsetX = (this.random.nextDouble() - 0.5) * 1.5;
            double offsetZ = (this.random.nextDouble() - 0.5) * 1.5;
            projectile.m_6034_(this.m_20185_() + offsetX + direction.f_82479_ * 0.5, this.m_20188_() + 0.5, this.m_20189_() + offsetZ + direction.f_82481_ * 0.5);
            projectile.m_6686_(adjustedDirection.f_82479_, adjustedDirection.f_82480_ + verticalAdjustment, adjustedDirection.f_82481_, (float)velocityScale, (float)inaccuracy);
            this.m_9236_().m_7967_((Entity)projectile);
            this.throwSpamIntervalRemaining = 8;
        }
    }

    public boolean isThrowSpamActive() {
        return this.throwSpamDurationRemaining > 0;
    }

    public boolean isEnraged() {
        return this.m_21223_() / this.m_21233_() < 0.5f;
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_7822_(byte pId) {
        if (pId == 4 || pId == 5 || pId == 6 || pId == 7 || pId == 8) {
            EntityRenderer entityRenderer;
            if (this.m_9236_().m_5776_() && (entityRenderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)this)) instanceof WastelandBossRenderer) {
                WastelandBossRenderer renderer = (WastelandBossRenderer)entityRenderer;
                ((ModelWastelandBoss)renderer.m_7200_()).handleEntityEvent(pId);
            }
        } else {
            super.m_7822_(pId);
        }
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268493_) || super.m_6673_(source);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7640_() instanceof AbstractArrow) {
            pAmount *= 0.25f;
        }
        if (pSource.m_276093_(DamageTypes.f_268565_)) {
            pAmount *= 0.25f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20390_(1.5f, 1.5f);
    }
}

