/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import igentuman.nc.handler.config.RadiationConfig;
import igentuman.nc.radiation.data.PlayerRadiationProvider;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.util.TextUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class RadiationCommand {
    public static void register(CommandDispatcher<CommandSourceStack> command) {
        command.register((LiteralArgumentBuilder)Commands.m_82127_((String)"nc_radiation").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"action", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("disable");
            builder.suggest("set");
            builder.suggest("enable");
            builder.suggest("clear_all");
            builder.suggest("clear_player");
            return builder.buildFuture();
        }).requires(cs -> cs.m_6761_(3))).executes(RadiationCommand::executeCommand)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(cs -> cs.m_6761_(3))).executes(RadiationCommand::executeCommandWithPlayer))).then(Commands.m_82129_((String)"value", (ArgumentType)new RangeArgument.Ints()).executes(RadiationCommand::executeSetRadiation))));
    }

    private static int executeCommandWithPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer executor = ((CommandSourceStack)context.getSource()).m_81375_();
        if (!executor.m_20310_(3)) {
            executor.m_213846_((Component)TextUtils.__("commands.nuclearcraft.no_permission", new Object[0]));
            return 1;
        }
        String action = StringArgumentType.getString(context, (String)"action");
        if ("clear_player".equals(action)) {
            ServerPlayer targetPlayer = EntityArgument.m_91474_(context, (String)"player");
            targetPlayer.getCapability(PlayerRadiationProvider.PLAYER_RADIATION).ifPresent(playerRadiation -> playerRadiation.setRadiation(0L));
            executor.m_213846_((Component)Component.m_237113_((String)("Cleared player radiation " + targetPlayer.m_7755_().getString())));
            return 1;
        }
        if ("set".equals(action)) {
            RadiationCommand.executeSetRadiation(context);
            return 1;
        }
        return RadiationCommand.executeCommand(context);
    }

    private static int executeCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String action;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        if (!player.m_20310_(3)) {
            player.m_213846_((Component)TextUtils.__("commands.nuclearcraft.no_permission", new Object[0]));
            return 1;
        }
        switch (action = StringArgumentType.getString(context, (String)"action")) {
            case "disable": {
                RadiationConfig.RADIATION_CONFIG.ENABLED.set((Object)false);
                player.m_213846_((Component)Component.m_237113_((String)"Radiation disabled!"));
                break;
            }
            case "enable": {
                RadiationConfig.RADIATION_CONFIG.ENABLED.set((Object)true);
                player.m_213846_((Component)Component.m_237113_((String)"Radiation enabled!"));
                break;
            }
            case "clear_all": {
                RadiationManager.get(player.m_9236_());
                RadiationManager.clear(player.m_9236_());
                player.m_213846_((Component)Component.m_237113_((String)"Radiation cleared!"));
                break;
            }
            default: {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid action: " + action)));
                return 0;
            }
        }
        return 1;
    }

    private static int executeSetRadiation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        if (!player.m_20310_(3)) {
            player.m_213846_((Component)TextUtils.__("commands.nuclearcraft.no_permission", new Object[0]));
            return 1;
        }
        String action = StringArgumentType.getString(context, (String)"action");
        if (!"set".equals(action)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid action for value argument: " + action)));
            return 0;
        }
        int value = 0;
        try {
            value = Math.max(0, Integer.parseInt(context.getInput().split(" ")[2]));
        }
        catch (Exception ex) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid action for value argument: " + action)));
            return 0;
        }
        RadiationManager.get(player.m_9236_()).setChunkRadiation(player.m_20183_(), value);
        player.m_213846_((Component)Component.m_237113_((String)("Set your radiation to " + value)));
        return 1;
    }
}

