/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import igentuman.nc.setup.registration.WorldGeneration;
import igentuman.nc.util.TextUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class StructureCommand {
    public static void register(CommandDispatcher<CommandSourceStack> command) {
        command.register((LiteralArgumentBuilder)Commands.m_82127_((String)"nc_build").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"structure", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("fission_reactor");
            builder.suggest("fusion_reactor");
            builder.suggest("kugelblitz_chamber");
            builder.suggest("linear_accelerator");
            builder.suggest("target_chamber");
            builder.suggest("turbine");
            return builder.buildFuture();
        }).requires(cs -> cs.m_6761_(3))).executes(StructureCommand::executeCommand)));
    }

    private static int executeCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String structure;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        if (!player.m_20310_(3)) {
            player.m_213846_((Component)TextUtils.__("commands.nuclearcraft.no_permission", new Object[0]));
            return 1;
        }
        switch (structure = StringArgumentType.getString(context, (String)"structure")) {
            case "fission_reactor": {
                StructureCommand.placeFissionReactor(player);
                break;
            }
            case "fusion_reactor": {
                StructureCommand.placeFusionReactor(player);
                break;
            }
            case "kugelblitz_chamber": {
                StructureCommand.placeKugelblitzChamber(player);
                break;
            }
            case "turbine": {
                StructureCommand.placeTurbine(player);
                break;
            }
            case "linear_accelerator": {
                StructureCommand.placeLinearAccelerator(player);
                break;
            }
            case "target_chamber": {
                StructureCommand.placeTargetChamber(player);
                break;
            }
            default: {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid structure: " + structure)));
            }
        }
        return 1;
    }

    private static void placeLinearAccelerator(ServerPlayer player) {
        double rayTraceRange = 30.0;
        HitResult hitResult = player.m_19907_(rayTraceRange, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos blockPos = blockHitResult.m_82425_().m_7918_(-2, 1, -2);
            WorldGeneration.StructurePlacer.placeStructure((ServerLevel)player.m_9236_(), blockPos, "linear_accelerator");
            player.m_213846_((Component)Component.m_237113_((String)"Placing Linear Accelerator!"));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"No block targeted!"));
        }
    }

    private static void placeTargetChamber(ServerPlayer player) {
        double rayTraceRange = 30.0;
        HitResult hitResult = player.m_19907_(rayTraceRange, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos blockPos = blockHitResult.m_82425_().m_7918_(-2, 1, -2);
            WorldGeneration.StructurePlacer.placeStructure((ServerLevel)player.m_9236_(), blockPos, "target_chamber");
            player.m_213846_((Component)Component.m_237113_((String)"Placing Linear Accelerator!"));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"No block targeted!"));
        }
    }

    private static void placeKugelblitzChamber(ServerPlayer player) {
        double rayTraceRange = 30.0;
        HitResult hitResult = player.m_19907_(rayTraceRange, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos blockPos = blockHitResult.m_82425_().m_7918_(-3, 6, -3);
            WorldGeneration.StructurePlacer.placeStructure((ServerLevel)player.m_9236_(), blockPos, "kugelblitz_chamber");
            player.m_213846_((Component)Component.m_237113_((String)"Placing chamber!"));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"No block targeted!"));
        }
    }

    private static void placeTurbine(ServerPlayer player) {
        double rayTraceRange = 30.0;
        HitResult hitResult = player.m_19907_(rayTraceRange, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos blockPos = blockHitResult.m_82425_().m_7918_(-3, 1, -3);
            WorldGeneration.StructurePlacer.placeStructure((ServerLevel)player.m_9236_(), blockPos, "turbine");
            player.m_213846_((Component)Component.m_237113_((String)"Placing turbine!"));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"No block targeted!"));
        }
    }

    private static void placeFissionReactor(ServerPlayer player) {
        double rayTraceRange = 30.0;
        HitResult hitResult = player.m_19907_(rayTraceRange, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos blockPos = blockHitResult.m_82425_().m_7918_(-3, 1, -3);
            WorldGeneration.StructurePlacer.placeStructure((ServerLevel)player.m_9236_(), blockPos, "fission_reactor");
            player.m_213846_((Component)Component.m_237113_((String)"Placing fission reactor!"));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"No block targeted!"));
        }
    }

    private static void placeFusionReactor(ServerPlayer player) {
        double rayTraceRange = 30.0;
        HitResult hitResult = player.m_19907_(rayTraceRange, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos blockPos = blockHitResult.m_82425_().m_7918_(-5, 3, -5);
            WorldGeneration.StructurePlacer.placeStructure((ServerLevel)player.m_9236_(), blockPos, "fusion_reactor");
            player.m_213846_((Component)Component.m_237113_((String)"Placing fusion reactor!"));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"No block targeted!"));
        }
    }
}

