/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.event.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import igentuman.nc.client.sound.GeigerSound;
import igentuman.nc.client.sound.SoundHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.Nullable;

public class TickHandler {
    public static String currentScreenCode = "";
    public static final Minecraft minecraft = Minecraft.m_91087_();
    private static final Map<RenderType, List<LazyRender>> transparentRenderers = new HashMap<RenderType, List<LazyRender>>();
    protected static GeigerSound geigerSound;

    public static void clearQueued() {
        transparentRenderers.clear();
    }

    private void renderStage(RenderLevelStageEvent event, boolean shouldRender, StageRenderer renderer) {
        if (shouldRender) {
            Camera camera = event.getCamera();
            PoseStack matrix = event.getPoseStack();
            matrix.m_85836_();
            Vec3 camVec = camera.m_90583_();
            matrix.m_85837_(-camVec.f_82479_, -camVec.f_82480_, -camVec.f_82481_);
            renderer.render(camera, minecraft.m_91269_().m_110104_(), matrix, event.getRenderTick(), event.getPartialTick());
            matrix.m_85849_();
        }
    }

    @SubscribeEvent
    public void renderWorld(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            this.renderStage(event, !transparentRenderers.isEmpty(), (camera, renderer, poseStack, renderTick, partialTick) -> {
                ProfilerFiller profiler = minecraft.m_91307_();
                profiler.m_6180_("delayedNCTranslucentBERs");
                record TransparentRenderInfo(RenderType renderType, List<LazyRender> renders, double closest) {
                }
                Consumer<TransparentRenderInfo> renderInfoConsumer = info -> {
                    VertexConsumer buffer = renderer.m_6299_(info.renderType);
                    for (LazyRender transparentRender : info.renders) {
                        String profilerSection = transparentRender.getProfilerSection();
                        if (profilerSection != null) {
                            profiler.m_6180_(profilerSection);
                        }
                        transparentRender.render(camera, buffer, poseStack, renderTick, partialTick, profiler);
                        if (profilerSection == null) continue;
                        profiler.m_7238_();
                    }
                    renderer.m_109912_(info.renderType);
                };
                if (transparentRenderers.size() == 1) {
                    for (Map.Entry<RenderType, List<LazyRender>> entry2 : transparentRenderers.entrySet()) {
                        renderInfoConsumer.accept(new TransparentRenderInfo(entry2.getKey(), entry2.getValue(), 0.0));
                    }
                } else {
                    transparentRenderers.entrySet().stream().map(entry -> {
                        List renders = (List)entry.getValue();
                        double closest = Double.MAX_VALUE;
                        for (LazyRender render : renders) {
                            double distanceSqr;
                            Vec3 renderPos = render.getCenterPos(partialTick);
                            if (renderPos == null || !((distanceSqr = camera.m_90583_().m_82557_(renderPos)) < closest)) continue;
                            closest = distanceSqr;
                        }
                        return new TransparentRenderInfo((RenderType)entry.getKey(), renders, closest);
                    }).sorted(Comparator.comparingDouble(info -> -info.closest)).forEachOrdered(renderInfoConsumer);
                }
                transparentRenderers.clear();
                profiler.m_7238_();
            });
        }
    }

    public static void register(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(TickHandler::onTick);
        MinecraftForge.EVENT_BUS.register((Object)new TickHandler());
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            TickHandler.tickStart();
        }
    }

    public static void tickStart() {
        if (TickHandler.minecraft.f_91074_ == null) {
            return;
        }
        GeigerSound toPlay = GeigerSound.create((Player)TickHandler.minecraft.f_91074_);
        if (toPlay != null && (geigerSound == null || TickHandler.geigerSound.radiationLevel != toPlay.radiationLevel)) {
            if (geigerSound != null) {
                SoundHandler.stopSound((SoundInstance)geigerSound);
            }
            geigerSound = toPlay;
            SoundHandler.playSound((SoundInstance)geigerSound);
        }
        if (toPlay == null && geigerSound != null) {
            SoundHandler.stopSound((SoundInstance)geigerSound);
            geigerSound = null;
        }
    }

    public static void addTransparentRenderer(RenderType renderType, LazyRender render) {
        transparentRenderers.computeIfAbsent(renderType, r -> new ArrayList()).add(render);
    }

    @FunctionalInterface
    private static interface StageRenderer {
        public void render(Camera var1, MultiBufferSource.BufferSource var2, PoseStack var3, int var4, float var5);
    }

    @FunctionalInterface
    public static interface LazyRender {
        public void render(Camera var1, VertexConsumer var2, PoseStack var3, int var4, float var5, ProfilerFiller var6);

        @Nullable
        default public Vec3 getCenterPos(float partialTick) {
            return null;
        }

        @Nullable
        default public String getProfilerSection() {
            return null;
        }
    }
}

