/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.sided.capability;

import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemHandlerWrapper
implements IItemHandlerModifiable {
    private final ItemCapabilityHandler handler;
    private final Predicate<Integer> extract;
    private final BiPredicate<Integer, ItemStack> insert;
    private final Direction side;

    public ItemHandlerWrapper(Direction side, ItemCapabilityHandler handler, Predicate<Integer> extract, BiPredicate<Integer, ItemStack> insert) {
        this.handler = handler;
        this.extract = extract;
        this.insert = insert;
        this.side = side;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.handler.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.handler.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.insert.test(slot, stack) ? this.handler.insertItem(slot, stack, simulate) : stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.side != null && (this.handler.getMode(slot, 0) == SlotModePair.SlotMode.INPUT || this.handler.getMode(slot, 0) == SlotModePair.SlotMode.PULL)) {
            return ItemStack.f_41583_;
        }
        return this.extract.test(slot) ? this.handler.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return this.handler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.insert.test(slot, stack) && this.handler.isItemValid(slot, stack);
    }
}

