/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock;

import igentuman.nc.NuclearCraft;
import igentuman.nc.multiblock.AbstractMultiblock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class MultiblockHandler {
    public static final ConcurrentHashMap<ResourceKey<Level>, MultiblockHandler> instances = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AbstractMultiblock> multiblocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, List<String>> chunkCache = new ConcurrentHashMap();
    private final Set<String> toRemove = Collections.synchronizedSet(new HashSet());
    public final Set<Long> ignoreUpdate = Collections.synchronizedSet(new HashSet());
    public final Set<Long> changedBlocks = Collections.synchronizedSet(new HashSet());

    private MultiblockHandler() {
    }

    public static MultiblockHandler get(ResourceKey<Level> dimension) {
        if (instances.containsKey(dimension)) {
            return instances.get(dimension);
        }
        MultiblockHandler handler = new MultiblockHandler();
        instances.put(dimension, handler);
        return handler;
    }

    public void addMultiblock(AbstractMultiblock multiblock) {
        if (multiblock.controller() == null) {
            throw new IllegalArgumentException("Multiblock controller is null");
        }
        if (!this.multiblocks.containsKey(multiblock.getId())) {
            this.multiblocks.put(multiblock.getId(), multiblock);
            NuclearCraft.debugLog("Added new multiblock: " + multiblock.getId() + " (" + multiblock.getClass().getSimpleName() + ")");
        } else {
            this.multiblocks.putIfAbsent(multiblock.getId(), multiblock);
            NuclearCraft.debugLog("Multiblock already exists: " + multiblock.getId());
        }
        this.addToChunkCache(multiblock);
    }

    private void addToChunkCache(AbstractMultiblock multiblock) {
        List<String> list;
        long chunkPos = multiblock.getChunk().m_45588_();
        if (!this.chunkCache.containsKey(chunkPos)) {
            this.chunkCache.put(chunkPos, Collections.synchronizedList(new ArrayList()));
        }
        if (!(list = this.chunkCache.get(chunkPos)).contains(multiblock.getId())) {
            list.add(multiblock.getId());
        }
    }

    private void removeFromChunkCache(String id) {
        for (List<String> list : this.chunkCache.values()) {
            list.remove(id);
        }
        List chunkPosSet = this.chunkCache.keySet().stream().toList();
        Iterator iterator = chunkPosSet.iterator();
        while (iterator.hasNext()) {
            List<String> list;
            long chunkPos = (Long)iterator.next();
            if (!this.chunkCache.containsKey(chunkPos) || !(list = this.chunkCache.get(chunkPos)).isEmpty()) continue;
            this.chunkCache.remove(chunkPos);
        }
    }

    public void addMultiblock(AbstractMultiblock multiblock, boolean force) {
        if (this.multiblocks.containsKey(multiblock.getId()) && force) {
            NuclearCraft.debugLog("Force replacing existing multiblock: " + multiblock.getId());
            this.multiblocks.get(multiblock.getId()).dispose();
        }
        this.addMultiblock(multiblock);
    }

    public void addIgnoreToUpdate(BlockPos blockPos) {
        if (blockPos != null) {
            this.ignoreUpdate.add(blockPos.m_121878_());
        }
    }

    public void trackAllChanges() {
        for (long packedPos : this.changedBlocks) {
            AbstractMultiblock multiblock;
            BlockPos pos = BlockPos.m_122022_((long)packedPos);
            long chunkPos = new ChunkPos(pos.m_123341_() >> 4, pos.m_123343_() >> 4).m_45588_();
            if (this.chunkCache.containsKey(chunkPos)) {
                List<String> list = this.chunkCache.get(chunkPos);
                for (String id : list) {
                    AbstractMultiblock multiblock2 = this.multiblocks.get(id);
                    if (multiblock2 == null) continue;
                    multiblock2.onBlockChange(pos);
                }
            }
            ArrayList<AbstractMultiblock> tmp = new ArrayList<AbstractMultiblock>(this.multiblocks.values());
            Iterator<String> iterator = tmp.iterator();
            while (iterator.hasNext() && ((multiblock = (AbstractMultiblock)((Object)iterator.next())) == null || !multiblock.onBlockChange(pos))) {
            }
        }
        this.changedBlocks.clear();
    }

    public void trackBlockChange(BlockPos pos, boolean force) {
        if (force) {
            this.ignoreUpdate.remove(pos.m_121878_());
        }
        this.trackBlockChange(pos);
    }

    public void trackBlockChange(BlockPos pos) {
        if (pos == null || this.multiblocks.isEmpty()) {
            return;
        }
        if (this.ignoreUpdate.contains(pos.m_121878_())) {
            return;
        }
        if (!this.changedBlocks.contains(pos.m_121878_())) {
            this.changedBlocks.add(pos.m_121878_());
            NuclearCraft.debugLog("Tracking block change at " + pos.m_123344_() + " (total tracked: " + this.changedBlocks.size() + ")");
        }
    }

    public void tick(Level level) {
        AbstractMultiblock multiblock;
        if (!this.changedBlocks.isEmpty()) {
            NuclearCraft.debugLog("Processing " + this.changedBlocks.size() + " block changes for multiblocks");
        }
        this.trackAllChanges();
        ArrayList<String> needsValidation = new ArrayList<String>();
        for (String id : this.multiblocks.keySet()) {
            multiblock = this.multiblocks.get(id);
            if (multiblock == null || !multiblock.hasToRefresh || !multiblock.isLoaded() || !multiblock.isValidForTicking()) continue;
            needsValidation.add(id);
        }
        if (!needsValidation.isEmpty()) {
            NuclearCraft.debugLog("Processing validation for " + needsValidation.size() + " multiblocks");
            for (String id : needsValidation) {
                multiblock = this.multiblocks.get(id);
                if (multiblock == null || !multiblock.isValidForTicking()) {
                    this.toRemove.add(id);
                    continue;
                }
                try {
                    multiblock.tick(level);
                }
                catch (Exception e) {
                    NuclearCraft.debugLog("Error during multiblock validation for " + id + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        for (String id : this.multiblocks.keySet()) {
            multiblock = this.multiblocks.get(id);
            if (multiblock == null || !multiblock.isValidForTicking()) {
                this.toRemove.add(id);
                continue;
            }
            if (!multiblock.isLoaded()) continue;
            if (multiblock.controller().controllerBE().m_58901_()) {
                this.toRemove.add(id);
                continue;
            }
            if (multiblock.hasToRefresh) continue;
            try {
                multiblock.tick(level);
            }
            catch (Exception e) {
                NuclearCraft.debugLog("Error during multiblock tick for " + id + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (!this.toRemove.isEmpty()) {
            NuclearCraft.debugLog("Removing " + this.toRemove.size() + " invalid multiblocks: " + this.toRemove);
            for (String id : this.toRemove) {
                this.multiblocks.remove(id);
                this.removeFromChunkCache(id);
            }
            this.toRemove.clear();
        }
    }

    public void tick() {
        this.tick(null);
    }

    public void removeMultiblock(AbstractMultiblock multiblock) {
        String id = multiblock.getId();
        NuclearCraft.debugLog("Removing multiblock: " + id + " (" + multiblock.getClass().getSimpleName() + ")");
        this.multiblocks.remove(id);
        this.removeFromChunkCache(id);
    }

    public boolean checkAttachmentToBlock(Class<?> toCheck, Level level, BlockPos pos, Direction dir) {
        if (this.multiblocks.isEmpty()) {
            return false;
        }
        long chunkPos = new ChunkPos(pos.m_123341_() >> 4, pos.m_123343_() >> 4).m_45588_();
        if (this.chunkCache.containsKey(chunkPos)) {
            List<String> list = this.chunkCache.get(chunkPos);
            for (String id : list) {
                AbstractMultiblock multiblock = this.multiblocks.get(id);
                if (multiblock == null || !multiblock.checkAttachmentToBlock(toCheck, level, pos, dir)) continue;
                return true;
            }
        }
        for (AbstractMultiblock multiblock : this.multiblocks.values()) {
            if (multiblock == null || !multiblock.checkAttachmentToBlock(toCheck, level, pos, dir)) continue;
            return true;
        }
        return false;
    }

    public AbstractMultiblock getMultiblockByPos(BlockPos pos) {
        if (this.multiblocks.isEmpty()) {
            return null;
        }
        long chunkPos = new ChunkPos(pos.m_123341_() >> 4, pos.m_123343_() >> 4).m_45588_();
        if (this.chunkCache.containsKey(chunkPos)) {
            List<String> list = this.chunkCache.get(chunkPos);
            for (String id : list) {
                AbstractMultiblock multiblock = this.multiblocks.get(id);
                if (multiblock == null || !multiblock.containsPos(pos)) continue;
                return multiblock;
            }
        }
        for (AbstractMultiblock multiblock : this.multiblocks.values()) {
            if (multiblock == null || !multiblock.containsPos(pos)) continue;
            return multiblock;
        }
        return null;
    }

    public void clear() {
        for (AbstractMultiblock multiblock : this.multiblocks.values()) {
            if (multiblock == null) continue;
            multiblock.dispose();
        }
        this.multiblocks.clear();
        this.chunkCache.clear();
        this.toRemove.clear();
        this.ignoreUpdate.clear();
    }

    public void onControllerRemoved(BlockPos pos) {
        AbstractMultiblock multiblock = this.getMultiblockByPos(pos);
        if (multiblock != null) {
            NuclearCraft.debugLog("Controller removed at " + pos.m_123344_() + " for multiblock: " + multiblock.getId());
            multiblock.onControllerRemoved();
        } else {
            NuclearCraft.debugLog("Controller removed at " + pos.m_123344_() + " but no multiblock found");
        }
    }
}

