/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.accelerator;

import igentuman.api.nc.multiblock.MultiblockController;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.ElectromagnetBlock;
import igentuman.nc.block.RFAmplifierBlock;
import igentuman.nc.block.accelerator.CoolerBlock;
import igentuman.nc.block.accelerator.entity.AcceleratorBeamPortBE;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.handler.config.AcceleratorConfig;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.util.BlockPosInstance;
import igentuman.nc.util.PortMode;
import igentuman.nc.util.math.MathUtils;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AbstractAcceleratorMultiblock
extends AbstractMultiblock {
    protected static final int FINAL_STAGE = 4;
    protected BlockPosInstance centerPos;
    protected BlockPos ionSourcePos = BlockPos.f_121853_;
    protected BlockPos outputBeamPort = BlockPos.f_121853_;
    protected final HashMap<Long, ElectromagnetBlock> electromagnets = new HashMap(1000);
    protected final HashMap<Long, RFAmplifierBlock> amplifiers = new HashMap(1000);
    public final HashMap<Long, CoolerBlock> coolers = new HashMap(1000);
    protected HashSet<Long> beamPorts = new HashSet();
    protected int dipolesCount = 0;
    protected int quadrupolesCount = 0;
    protected final int[] xCoords = new int[]{0, 0, -1, 1, 1, -1, -1, 1};
    protected final int[] yCoords = new int[]{-1, 1, 0, 0, 1, -1, 1, -1};
    protected double focus = 0.0;
    protected int maxTemperature = 0;
    protected int heatRate = 0;
    protected double efficiency = 0.0;
    protected double quadStrength = 0.0;
    protected double dipoleStrength = 0.0;
    protected long acceleratingVoltage = 0L;
    protected int energyRequired = 0;
    protected int coolingRate = 0;
    protected int beamLength = 0;
    public int validCoolers = 0;
    protected int stage = 0;

    protected AbstractAcceleratorMultiblock(HashSet<Block> validOuterBlocks, HashSet<Block> validInnerBlocks, MultiblockController controller) {
        super(validOuterBlocks, validInnerBlocks, controller);
    }

    @Override
    public int maxHeight() {
        return 5;
    }

    @Override
    public int minHeight() {
        return 5;
    }

    @Override
    public int maxWidth() {
        return this.maxDepth();
    }

    @Override
    public int minWidth() {
        return this.minDepth();
    }

    @Override
    public int maxDepth() {
        return switch ((Integer)AcceleratorConfig.ACCELERATOR_CONFIG.SCALE.get()) {
            case 2 -> 1000;
            case 3 -> 10000;
            default -> 100;
        };
    }

    @Override
    public int minDepth() {
        return switch ((Integer)AcceleratorConfig.ACCELERATOR_CONFIG.SCALE.get()) {
            case 2 -> 60;
            case 3 -> 600;
            default -> 6;
        };
    }

    @Override
    protected Direction getControllerDirection() {
        return Direction.NORTH;
    }

    @Override
    public void clearStats() {
        this.controller().clearStats();
    }

    public boolean isControllerPlacedOnSide() {
        return this.depth == 5;
    }

    @Override
    public boolean isValidCorner(BlockPos pos) {
        try {
            return this.getBlockState(pos).m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_casing").get());
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public void validateOuter() {
        BlockState bs;
        NuclearCraft.debugLog("Starting accelerator outer validation at " + this.controllerPos.m_123344_());
        this.topRight = null;
        this.bottomLeft = null;
        this.validationResult = ValidationResult.INCOMPLETE;
        this.stage = 4;
        this.initialPos = BlockPosInstance.copy(this.controller().controllerBE().m_58899_());
        this.multiblockDirection = null;
        this.controllers.clear();
        this.connectedPorts = 0;
        this.width = 0;
        this.depth = 0;
        this.height = 0;
        this.beamPorts.clear();
        this.outerValid = false;
        NuclearCraft.debugLog("Resolving accelerator dimensions");
        this.resolveHeight();
        NuclearCraft.debugLog("Resolved height: " + this.height + " (required: " + this.maxHeight() + ")");
        if (this.height != this.maxHeight()) {
            NuclearCraft.debugLog("Height validation failed - expected " + this.maxHeight() + ", got " + this.height);
            this.validationResult = ValidationResult.INCOMPLETE;
            return;
        }
        this.resolveDepth();
        this.resolveWidth();
        NuclearCraft.debugLog("Resolved dimensions: " + this.width + "x" + this.height + "x" + this.depth + " (WxHxD)");
        boolean controllerOnSide = this.isControllerPlacedOnSide();
        NuclearCraft.debugLog("Controller placement - On side: " + controllerOnSide);
        if (controllerOnSide) {
            if (this.width > this.maxWidth()) {
                NuclearCraft.debugLog("Width too big for side placement: " + this.width + " > " + this.maxWidth());
                this.validationResult = ValidationResult.TOO_BIG;
                return;
            }
            if (this.width < this.minWidth()) {
                NuclearCraft.debugLog("Width too small for side placement: " + this.width + " < " + this.minWidth());
                this.validationResult = ValidationResult.TOO_SMALL;
                return;
            }
        }
        if (!controllerOnSide) {
            if (this.depth > this.maxDepth()) {
                NuclearCraft.debugLog("Depth too big for end placement: " + this.depth + " > " + this.maxDepth());
                this.validationResult = ValidationResult.TOO_BIG;
                return;
            }
            if (this.depth < this.minDepth()) {
                NuclearCraft.debugLog("Depth too small for end placement: " + this.depth + " < " + this.minDepth());
                this.validationResult = ValidationResult.TOO_SMALL;
                return;
            }
        }
        BlockPosInstance leftFront = new BlockPosInstance((Vec3i)this.getLeftPos(this.leftCasing));
        BlockPosInstance leftBack = new BlockPosInstance((Vec3i)this.getLeftPos(this.leftCasing).m_5484_(this.getControllerDirection(), -this.depth + 1));
        BlockPosInstance rightFront = new BlockPosInstance((Vec3i)this.getRightPos(this.rightCasing));
        BlockPosInstance rightBack = new BlockPosInstance((Vec3i)this.getRightPos(this.rightCasing).m_5484_(this.getControllerDirection(), -this.depth + 1));
        int minX = MathUtils.min(leftFront.m_123341_(), rightFront.m_123341_(), leftBack.m_123341_(), rightBack.m_123341_());
        int minZ = MathUtils.min(leftFront.m_123343_(), rightFront.m_123343_(), leftBack.m_123343_(), rightBack.m_123343_());
        int maxX = MathUtils.max(leftFront.m_123341_(), rightFront.m_123341_(), leftBack.m_123341_(), rightBack.m_123341_());
        int maxZ = MathUtils.max(leftFront.m_123343_(), rightFront.m_123343_(), leftBack.m_123343_(), rightBack.m_123343_());
        this.bottomLeft = new BlockPosInstance(minX, leftFront.m_123342_() - this.bottomCasing, minZ);
        this.topRight = new BlockPosInstance(maxX, leftFront.m_123342_() + this.topCasing, maxZ);
        this.cacheBlockStates(null);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    if (y != 0 && x != 0 && z != 0 && y != this.height - 1 && x != this.width - 1 && z != this.depth - 1) continue;
                    if (!((y != 0 && y != this.height - 1 || z != 0 && z != this.depth - 1) && (y != 0 && y != this.height - 1 || x != 0 && x != this.width - 1) && (z != 0 && z != this.depth - 1 || x != 0 && x != this.width - 1))) {
                        if (!this.isValidCorner(this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z))) {
                            this.validationResult = ValidationResult.WRONG_CORNER;
                            this.errorBlockPos = new BlockPos((Vec3i)this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z));
                            return;
                        }
                    } else if (!this.isValidForOuter(this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z))) {
                        this.validationResult = ValidationResult.WRONG_OUTER;
                        this.errorBlockPos = new BlockPos((Vec3i)this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z));
                        return;
                    }
                    this.processOuterBlock(this.getSidePos(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z));
                }
            }
        }
        if (maxX - minX == 4) {
            this.centerPos = new BlockPosInstance((minX + maxX) / 2, this.bottomLeft.m_123342_() + 2, minZ);
            this.multiblockDirection = Direction.NORTH;
        }
        if (maxZ - minZ == 4) {
            this.centerPos = new BlockPosInstance(minX, this.bottomLeft.m_123342_() + 2, (minZ + maxZ) / 2);
            this.multiblockDirection = Direction.WEST;
        }
        if (!(bs = this.getBlockState(this.centerPos)).m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_beam_port").get()) && !bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_ion_source_port").get())) {
            this.validationResult = ValidationResult.WRONG_BLOCK;
            this.errorBlockPos = new BlockPosInstance((Vec3i)this.centerPos);
            return;
        }
        if (bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_beam_port").get())) {
            this.beamPorts.add(this.centerPos.m_121878_());
        }
        this.ionSourcePos = bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_ion_source_port").get()) ? new BlockPosInstance((Vec3i)this.centerPos) : BlockPos.f_121853_;
        this.outputBeamPort = bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_beam_port").get()) ? new BlockPosInstance((Vec3i)this.centerPos) : BlockPos.f_121853_;
        bs = this.getBlockState(this.centerPos.offset(0, 0, maxZ - minZ));
        if (!bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_beam_port").get()) && !bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_ion_source_port").get())) {
            this.validationResult = ValidationResult.WRONG_BLOCK;
            this.errorBlockPos = new BlockPosInstance((Vec3i)this.centerPos);
            return;
        }
        if (!this.ionSourcePos.equals((Object)BlockPos.f_121853_) && bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_ion_source_port").get())) {
            this.validationResult = ValidationResult.WRONG_BLOCK;
            this.errorBlockPos = new BlockPosInstance((Vec3i)this.centerPos);
            return;
        }
        BlockPos blockPos = this.outputBeamPort = bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_beam_port").get()) && this.outputBeamPort.equals((Object)BlockPos.f_121853_) ? new BlockPosInstance((Vec3i)this.centerPos) : BlockPos.f_121853_;
        if (bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_beam_port").get())) {
            this.beamPorts.add(this.centerPos.m_121878_());
        }
        this.centerPos.revert();
        if (this.controllers.size() > 1) {
            this.validationResult = ValidationResult.TOO_MANY_CONTROLLERS;
            return;
        }
        this.validationResult = ValidationResult.VALID;
        this.outerValid = true;
        this.stage = 1;
        this.hasToRefresh = true;
    }

    public void indexInnerBlocks() {
        this.stage = 4;
        this.innerValid = false;
        this.acceleratingVoltage = 0L;
        this.heatRate = 0;
        this.maxTemperature = Integer.MAX_VALUE;
        this.efficiency = 0.0;
        this.quadrupolesCount = 0;
        this.dipolesCount = 0;
        this.quadStrength = 0.0;
        this.dipoleStrength = 0.0;
        this.focus = 0.0;
        this.energyRequired = 0;
        for (int z = 1; z < Math.max(this.depth, this.width) - 1; ++z) {
            if (this.indexSlice(z)) continue;
            return;
        }
        this.innerValid = true;
        this.validationResult = ValidationResult.VALID;
        this.stage = 3;
    }

    protected boolean indexSlice(int z) {
        int magnetCount = 0;
        boolean nextMustBeMagnet = false;
        boolean nextMustBeAmplifier = false;
        double magnetStrength = 0.0;
        double amplification = 0.0;
        for (int i = 0; i < this.xCoords.length; ++i) {
            int x = this.xCoords[i];
            int y = this.yCoords[i];
            BlockPos toCheck = new BlockPos((Vec3i)this.getSidePos(x).m_6630_(y).m_5484_(this.multiblockDirection, z));
            BlockState bs = this.getBlockState(toCheck);
            this.addIfNotExists(toCheck, (HashSet<Long>)this.allBlocks);
            if (!this.isValidForInner(bs)) {
                this.validationResult = ValidationResult.WRONG_INNER;
                this.errorBlockPos = new BlockPos((Vec3i)toCheck);
                return false;
            }
            if (this.isMagnet(bs)) {
                if (i > 4 || nextMustBeAmplifier) {
                    this.validationResult = ValidationResult.WRONG_INNER;
                    this.errorBlockPos = new BlockPos((Vec3i)toCheck);
                    return false;
                }
                this.electromagnets.put(toCheck.m_121878_(), (ElectromagnetBlock)bs.m_60734_());
                this.maxTemperature = Math.min(this.maxTemperature, ((ElectromagnetBlock)bs.m_60734_()).getMaxTemperature());
                this.heatRate += ((ElectromagnetBlock)bs.m_60734_()).getHeatRate();
                this.energyRequired += ((ElectromagnetBlock)bs.m_60734_()).getPower();
                this.efficiency += ((ElectromagnetBlock)bs.m_60734_()).getEfficiency();
                magnetStrength += ((ElectromagnetBlock)bs.m_60734_()).getStrength();
                boolean bl = nextMustBeMagnet = ++magnetCount % 2 != 0 && (i == 0 || i == 2);
            }
            if (this.isAmplifier(bs)) {
                if (nextMustBeMagnet) {
                    this.validationResult = ValidationResult.WRONG_INNER;
                    this.errorBlockPos = new BlockPos((Vec3i)toCheck);
                    return false;
                }
                amplification += (double)((RFAmplifierBlock)bs.m_60734_()).getAmplification();
                this.energyRequired += ((RFAmplifierBlock)bs.m_60734_()).getPower();
                this.heatRate += ((RFAmplifierBlock)bs.m_60734_()).getHeatRate();
                this.efficiency += ((RFAmplifierBlock)bs.m_60734_()).getEfficiency();
                this.maxTemperature = Math.min(this.maxTemperature, ((RFAmplifierBlock)bs.m_60734_()).getMaxTemperature());
                nextMustBeAmplifier = true;
                this.amplifiers.put(toCheck.m_121878_(), (RFAmplifierBlock)bs.m_60734_());
                continue;
            }
            if (this.isCooler(bs)) {
                this.coolers.put(toCheck.m_121878_(), (CoolerBlock)bs.m_60734_());
                if (!nextMustBeMagnet && !nextMustBeAmplifier) continue;
                this.validationResult = ValidationResult.WRONG_INNER;
                this.errorBlockPos = new BlockPos((Vec3i)toCheck);
                return false;
            }
            if (nextMustBeAmplifier) {
                this.validationResult = ValidationResult.WRONG_INNER;
                this.errorBlockPos = new BlockPos((Vec3i)toCheck);
                return false;
            }
            if (i == 1 && magnetCount == 1) {
                this.validationResult = ValidationResult.WRONG_INNER;
                int yy = this.isMagnet(bs) ? 2 : 0;
                this.errorBlockPos = new BlockPos((Vec3i)toCheck.m_6625_(yy));
                return false;
            }
            if (i != 3 || magnetCount != 3 && magnetCount != 1) continue;
            this.validationResult = ValidationResult.WRONG_INNER;
            int xx = this.isMagnet(bs) ? 2 : i;
            this.errorBlockPos = new BlockPos((Vec3i)new BlockPos((Vec3i)this.getSidePos(this.leftCasing - this.xCoords[xx]).m_6630_(y - this.bottomCasing).m_5484_(this.multiblockDirection, z)));
            return false;
        }
        switch (magnetCount) {
            case 4: {
                ++this.quadrupolesCount;
                this.quadStrength += magnetStrength / 4.0;
                break;
            }
            case 2: {
                ++this.dipolesCount;
                this.dipoleStrength += magnetStrength / 2.0;
            }
        }
        this.acceleratingVoltage = (long)((double)this.acceleratingVoltage + amplification / 8.0);
        return true;
    }

    protected boolean isCooler(BlockState bs) {
        return bs.m_60734_() instanceof CoolerBlock;
    }

    protected boolean isAmplifier(BlockState bs) {
        return bs.m_60734_() instanceof RFAmplifierBlock;
    }

    protected boolean isMagnet(BlockState bs) {
        return bs.m_60734_() instanceof ElectromagnetBlock;
    }

    @Override
    public void tick(Level level) {
        if (!this.canTick || !this.hasToRefresh) {
            return;
        }
        this.canTick = false;
        this.validationResult = ValidationResult.INCOMPLETE;
        if (this.stage == 0) {
            this.innerValid = false;
            this.outerValid = false;
            this.isFormed = false;
        }
        this.hasToRefresh = false;
        this.validate();
        this.canTick = true;
    }

    protected void indexCoolers() {
        this.innerValid = true;
        this.coolingRate = 0;
        this.validCoolers = 0;
        this.validationResult = ValidationResult.VALID;
        this.stage = 4;
        for (Long pos : this.coolers.keySet()) {
            CoolerBlock cooler = this.coolers.get(pos);
            if (!cooler.isValid(this.getLevel(), BlockPos.m_122022_((long)pos), this)) continue;
            this.coolingRate = (int)((double)this.coolingRate + cooler.def.heat);
            ++this.validCoolers;
        }
    }

    protected void validateBeam() {
        this.stage = 4;
        this.beamLength = 2;
        for (int i = 1; i < Math.max(this.depth, this.width) - 1; ++i) {
            if (!this.getBlockState(this.centerPos.revert().relative(this.multiblockDirection, i)).m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("particle_beam").get())) {
                this.validationResult = ValidationResult.WRONG_INNER;
                this.errorBlockPos = new BlockPosInstance((Vec3i)this.centerPos);
                return;
            }
            ++this.beamLength;
        }
        this.innerValid = true;
        this.validationResult = ValidationResult.VALID;
        this.centerPos.revert();
        this.stage = 2;
    }

    @Override
    protected boolean processInnerBlock(BlockPos pos) {
        Block block = this.getBlock(pos);
        if (block instanceof ElectromagnetBlock) {
            ElectromagnetBlock magnet = (ElectromagnetBlock)block;
            this.electromagnets.put(pos.m_121878_(), magnet);
        } else if (block instanceof RFAmplifierBlock) {
            RFAmplifierBlock amplifier = (RFAmplifierBlock)block;
            this.amplifiers.put(pos.m_121878_(), amplifier);
        } else if (block instanceof CoolerBlock) {
            CoolerBlock cooler = (CoolerBlock)block;
            this.coolers.put(pos.m_121878_(), cooler);
        }
        this.addIfNotExists(pos, (HashSet<Long>)this.allBlocks);
        return true;
    }

    public void extractParticle(ParticleStack particleStack) {
        for (long pos : this.beamPorts) {
            BlockEntity be;
            BlockPosInstance portPos = BlockPosInstance.of(pos);
            BlockState bs = this.getBlockState(portPos);
            if (!bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("accelerator_beam_port").get()) || !((PortMode.Mode)((Object)bs.m_61143_(PortMode.PORT_MODE))).equals((Object)PortMode.Mode.OUTPUT) || !((be = this.getBlockEntity(portPos, new boolean[0])) instanceof AcceleratorBeamPortBE)) continue;
            AcceleratorBeamPortBE port = (AcceleratorBeamPortBE)be;
            port.extractParticle(particleStack);
        }
    }
}

