/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.fission;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.fission.FissionCasingBlock;
import igentuman.nc.block.fission.FissionFuelCellBlock;
import igentuman.nc.block.fission.HeatSinkBlock;
import igentuman.nc.block.fission.IrradiationChamberBlock;
import igentuman.nc.block.fission.entity.FissionControllerBE;
import igentuman.nc.handler.config.FissionConfig;
import igentuman.nc.handler.event.server.WorldEvents;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.fission.FissionReactorController;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.util.TagUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class FissionReactorMultiblock
extends AbstractMultiblock {
    protected int irradiationLines = 0;
    protected int extraFuelCells = 0;
    protected int moderatorAttachments = 0;
    protected double heatSinkCooling = 0.0;
    protected double activeCooling = 0.0;
    protected final HashSet<Block> validModerators;
    public final HashMap<Long, HeatSinkBlock> validHeatSinks = new HashMap();
    protected final HashSet<Long> moderators = new HashSet();
    protected final HashSet<Long> irradiators = new HashSet();
    public final HashSet<Long> fuelCells = new HashSet();
    protected final HashSet<Long> allModerators = new HashSet();
    protected final HashSet<Long> validIrradiators = new HashSet();
    protected final HashSet<Long> activeHeatSinks = new HashSet();
    protected final HashSet<Long> allHeatSinks = new HashSet();
    protected final HashMap<String, HashSet<BlockPos>> indexedHeatSinks = new HashMap();
    protected final HashMap<BlockPos, String> reversedIndexedHeatSinks = new HashMap();
    protected double cellsHeatMult = 0.0;
    protected double moderatorsHeatMult = 0.0;
    protected double cellsEnergyMult = 0.0;
    protected double moderatorsEnergyMult = 0.0;
    protected final HashSet<Long> directFuelCellConnectionPos = new HashSet();
    protected final HashSet<Long> secondFuelCellConnectionPos = new HashSet();
    public final HashMap<String, Integer> coolantPerTick = new HashMap();

    @Override
    public int maxHeight() {
        return (Integer)FissionConfig.FISSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int maxWidth() {
        return (Integer)FissionConfig.FISSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int maxDepth() {
        return (Integer)FissionConfig.FISSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int minHeight() {
        return (Integer)FissionConfig.FISSION_CONFIG.MIN_SIZE.get();
    }

    @Override
    public int minWidth() {
        return (Integer)FissionConfig.FISSION_CONFIG.MIN_SIZE.get();
    }

    @Override
    public int minDepth() {
        return (Integer)FissionConfig.FISSION_CONFIG.MIN_SIZE.get();
    }

    public FissionReactorMultiblock(FissionControllerBE fissionControllerBE) {
        super(TagUtil.getBlocksByTagKey(FissionReactorRegistration.CASING_BLOCKS.f_203868_().toString()), TagUtil.getBlocksByTagKey(FissionReactorRegistration.INNER_REACTOR_BLOCKS.f_203868_().toString()), new FissionReactorController(fissionControllerBE));
        this.id = "fission_reactor_" + fissionControllerBE.m_58899_().m_123344_();
        this.validModerators = TagUtil.getBlocksByTagKey(FissionReactorRegistration.MODERATORS_BLOCKS.f_203868_().toString());
        for (Block b : this.validModerators) {
            if (WorldEvents.trackingBlocks.contains(b)) continue;
            WorldEvents.trackingBlocks.add(b);
        }
        for (Block b : this.validOuterBlocks()) {
            if (b instanceof FissionCasingBlock || WorldEvents.trackingBlocks.contains(b)) continue;
            WorldEvents.trackingBlocks.add(b);
        }
        this.controllerBe = fissionControllerBE;
        MultiblockHandler.get((ResourceKey<Level>)this.getLevel().m_46472_()).addMultiblock(this);
    }

    private void addActiveCoolant(String name) {
        if (!this.coolantPerTick.containsKey(name)) {
            this.coolantPerTick.put(name, 0);
        }
        this.coolantPerTick.replace(name, this.coolantPerTick.get(name) + (Integer)FissionConfig.FISSION_CONFIG.ACTIVE_HEATSINK_COOLANT_PER_TICK.get());
    }

    private void removeActiveCoolant(String name) {
        this.coolantPerTick.replace(name, this.coolantPerTick.get(name) - (Integer)FissionConfig.FISSION_CONFIG.ACTIVE_HEATSINK_COOLANT_PER_TICK.get());
        if (this.coolantPerTick.get(name) == 0) {
            this.coolantPerTick.remove(name);
        }
    }

    @Override
    public void tick(Level level) {
        super.tick(level);
    }

    public boolean isModerator(BlockState bs) {
        return this.validModerators.contains(bs.m_60734_());
    }

    public boolean isModerator(BlockPos pos) {
        return this.allModerators.contains(pos.m_121878_()) || this.isModerator(this.getBlockState(pos));
    }

    public boolean isIrradiator(BlockPos pos) {
        return this.getBlockState(pos).m_60734_() instanceof IrradiationChamberBlock;
    }

    protected boolean isHeatSink(BlockState bs) {
        return bs.m_60734_() instanceof HeatSinkBlock;
    }

    protected boolean isHeatSink(BlockPos pos) {
        return this.allHeatSinks.contains(pos.m_121878_()) || this.isHeatSink(this.getBlockState(pos));
    }

    private boolean isFuelCell(BlockPos pos) {
        return this.fuelCells.contains(pos.m_121878_()) || this.isFuelCell(this.getBlockState(pos));
    }

    protected boolean isFuelCell(BlockState bs) {
        return bs.m_60734_() instanceof FissionFuelCellBlock;
    }

    @Override
    public void validate() {
        NuclearCraft.debugLog("=== Starting Fission Reactor validation at " + this.controllerPos.m_123344_() + " ===");
        this.heatSinkCooling = 0.0;
        this.moderatorAttachments = 0;
        this.extraFuelCells = 0;
        this.irradiationLines = 0;
        this.validHeatSinks.clear();
        this.coolantPerTick.clear();
        this.allHeatSinks.clear();
        this.indexedHeatSinks.clear();
        this.reversedIndexedHeatSinks.clear();
        this.allModerators.clear();
        this.validIrradiators.clear();
        this.activeHeatSinks.clear();
        this.allBlocks.clear();
        this.fuelCells.clear();
        this.irradiators.clear();
        this.directFuelCellConnectionPos.clear();
        this.secondFuelCellConnectionPos.clear();
        NuclearCraft.debugLog("Cleared fission reactor specific caches and counters");
        super.validate();
        this.updateAABB();
    }

    @Override
    public void validateInner(boolean force) {
        ValidationResult wasResult = this.validationResult;
        BlockPos wasErrorBlockPos = this.errorBlockPos;
        if (!this.outerValid && !force) {
            NuclearCraft.debugLog("VALIDATION FAILED - Outer structure invalid, clearing stats");
            this.clearStats();
            return;
        }
        this.extraFuelCells = 0;
        this.moderatorAttachments = 0;
        this.irradiationLines = 0;
        NuclearCraft.debugLog("Stage 1: Indexing inner blocks");
        this.indexInnerBlocks();
        NuclearCraft.debugLog("Stage 1 complete - Result: " + this.validationResult + ", Fuel cells: " + this.fuelCells.size() + ", Moderators: " + this.allModerators.size() + ", Heat sinks: " + this.allHeatSinks.size() + ", Irradiators: " + this.irradiators.size());
        if (this.validationResult != ValidationResult.VALID) {
            NuclearCraft.debugLog("VALIDATION FAILED - Inner structure invalid: " + this.validationResult + ", clearing stats");
            this.clearStats();
            return;
        }
        NuclearCraft.debugLog("Stage 2: Indexing fuel cell attachments");
        this.indexFuelCellAttachments();
        NuclearCraft.debugLog("Stage 2 complete - Extra fuel cells: " + this.extraFuelCells + ", Moderator attachments: " + this.moderatorAttachments + ", Cells heat mult: " + String.format("%.2f", this.cellsHeatMult) + ", Cells energy mult: " + String.format("%.2f", this.cellsEnergyMult));
        NuclearCraft.debugLog("Stage 3: Indexing irradiators");
        this.indexIrradiators();
        NuclearCraft.debugLog("Stage 3 complete - Irradiation lines: " + this.irradiationLines + ", Valid irradiators: " + this.validIrradiators.size() + "/" + this.irradiators.size());
        NuclearCraft.debugLog("Stage 4: Indexing heat sinks");
        this.indexHeatSinks();
        if (!this.outerValid) {
            this.validationResult = wasResult;
            this.errorBlockPos = wasErrorBlockPos;
            return;
        }
        NuclearCraft.debugLog("Stage 4 complete - Valid heat sinks: " + this.validHeatSinks.size() + "/" + this.allHeatSinks.size() + ", Active heat sinks: " + this.activeHeatSinks.size() + ", Coolant types: " + this.coolantPerTick.size());
        NuclearCraft.debugLog("UPDATING CONTROLLER STATS - Setting values:");
        NuclearCraft.debugLog("  FuelCells: " + this.fuelCells.size() + " (was: " + this.controllerBE().fuelCellsCount + ")");
        NuclearCraft.debugLog("  Moderators: " + this.moderators.size() + " (was: " + this.controllerBE().moderatorsCount + ")");
        NuclearCraft.debugLog("  HeatSinks: " + this.validHeatSinks.size() + " (was: " + this.controllerBE().heatSinksCount + ")");
        NuclearCraft.debugLog("  AllHeatSinks: " + this.allHeatSinks.size() + " (was: " + this.controllerBE().allHeatSinks + ")");
        NuclearCraft.debugLog("  ActiveCoolingHeatsinks: " + this.activeHeatSinks.size() + " (was: " + this.controllerBE().activeCoolingHeatsinks + ")");
        NuclearCraft.debugLog("  CellsHeatMult: " + this.cellsHeatMult + " (was: " + this.controllerBE().cellsHeatMult + ")");
        NuclearCraft.debugLog("  CellsEnergyMult: " + this.cellsEnergyMult + " (was: " + this.controllerBE().cellsEnergyMult + ")");
        this.controllerBE().irradiationLines = this.irradiationLines;
        this.controllerBE().allIrradiators = this.irradiators.size();
        this.controllerBE().validIrradiators = this.validIrradiators.size();
        this.controllerBE().heatSinksCount = this.validHeatSinks.size();
        this.controllerBE().allHeatSinks = this.allHeatSinks.size();
        this.controllerBE().activeCoolingHeatsinks = this.activeHeatSinks.size();
        this.controllerBE().moderatorsCount = this.moderators.size();
        this.controllerBE().allModerators = this.allModerators.size();
        this.controllerBE().moderatorAttachments = this.moderatorAttachments;
        this.controllerBE().connectedPorts = this.connectedPorts;
        this.controllerBE().extraFuelCells = this.extraFuelCells;
        this.controllerBE().fuelCellsCount = this.fuelCells.size();
        this.controllerBE().cellsHeatMult = this.cellsHeatMult;
        this.controllerBE().moderatorsHeatMult = this.moderatorsHeatMult;
        this.controllerBE().cellsEnergyMult = this.cellsEnergyMult;
        this.controllerBE().moderatorsEnergyMult = this.moderatorsEnergyMult;
        this.controllerBE().height = this.height;
        this.controllerBE().width = this.width;
        this.controllerBE().depth = this.depth;
        this.heatSinkCooling = this.countCooling(true);
        NuclearCraft.debugLog("CONTROLLER STATS UPDATED - Final values:");
        NuclearCraft.debugLog("  FuelCells: " + this.controllerBE().fuelCellsCount);
        NuclearCraft.debugLog("  Moderators: " + this.controllerBE().moderatorsCount);
        NuclearCraft.debugLog("  HeatSinks: " + this.controllerBE().heatSinksCount);
        NuclearCraft.debugLog("  HeatSinkCooling: " + this.heatSinkCooling);
        NuclearCraft.debugLog("  ControllerBE instance: " + this.controllerBE().toString());
        NuclearCraft.debugLog("  ControllerBE side: " + this.controllerBE().m_58904_().m_5776_());
        this.controllerBE().refresh();
    }

    private void indexIrradiators() {
        this.validIrradiators.clear();
        this.irradiationLines = 0;
        for (long pos : this.irradiators) {
            BlockPos toCheck = BlockPos.m_122022_((long)pos);
            for (Direction d : Direction.values()) {
                if (!this.isModerator(toCheck.m_121945_(d)) || !this.isFuelCell(toCheck.m_5484_(d, 2))) continue;
                ++this.irradiationLines;
                this.addIfNotExists(pos, this.validIrradiators);
            }
        }
    }

    private void indexHeatSinks() {
        this.validHeatSinks.clear();
        this.coolantPerTick.clear();
        ArrayList<BlockPos> sortedHeatSinks = new ArrayList<BlockPos>();
        for (String toCheck : FissionReactorRegistration.hsSchedule) {
            if (!this.indexedHeatSinks.containsKey(toCheck)) continue;
            HashSet<BlockPos> posSet = this.indexedHeatSinks.get(toCheck);
            sortedHeatSinks.addAll(posSet);
            for (BlockPos hsPos : posSet) {
                this.validHeatSinks.put(hsPos.m_121878_(), (HeatSinkBlock)this.getBlockState(hsPos).m_60734_());
            }
        }
        for (BlockPos hsPos : sortedHeatSinks) {
            long pos = hsPos.m_121878_();
            if (this.isHeatSinkValid(hsPos)) {
                HeatSinkBlock hb = this.validHeatSinks.get(pos);
                this.addSecondConnectionsToFuelCell(hsPos);
                if (!hb.isActive()) continue;
                if (!this.activeHeatSinks.contains(pos)) {
                    this.addActiveCoolant(hb.def.name.replace("active_", ""));
                }
                this.addIfNotExists(pos, this.activeHeatSinks);
                continue;
            }
            if (this.activeHeatSinks.contains(pos)) {
                this.activeHeatSinks.remove(pos);
                this.removeActiveCoolant(this.validHeatSinks.get((Object)Long.valueOf((long)pos)).def.name.replace("active_", ""));
            }
            this.validHeatSinks.remove(pos);
            this.removeSecondConnectionsToFuelCell(hsPos);
        }
    }

    private boolean isHeatSinkValid(BlockPos pos) {
        HeatSinkBlock hb = (HeatSinkBlock)this.getBlockState(pos).m_60734_();
        return hb.isValid(this.getLevel(), pos, this);
    }

    private void indexFuelCellAttachments() {
        this.cellsHeatMult = 0.0;
        this.moderatorsHeatMult = 0.0;
        this.cellsEnergyMult = 0.0;
        this.moderatorsEnergyMult = 0.0;
        for (long pos : this.fuelCells) {
            this.extraFuelCells = 0;
            this.extraFuelCells += this.countAdjacentFuelCells(BlockPos.m_122022_((long)pos));
            this.cellsHeatMult += ((double)this.extraFuelCells + 1.0) * ((double)this.extraFuelCells + 2.0) / 2.0;
            this.cellsEnergyMult += (double)this.extraFuelCells + 1.0;
            int moderators = this.getFuelCellModerators(pos);
            this.moderatorsHeatMult += (double)moderators * ((double)this.extraFuelCells + 1.0) * ((Double)FissionConfig.FISSION_CONFIG.MODERATOR_HEAT_MULTIPLIER.get() / 100.0);
            this.moderatorsEnergyMult += (double)moderators * ((double)this.extraFuelCells + 1.0) * ((Double)FissionConfig.FISSION_CONFIG.MODERATOR_FE_MULTIPLIER.get() / 100.0);
        }
    }

    private int getFuelCellModerators(long pos) {
        BlockPos fuelCellPos = BlockPos.m_122022_((long)pos);
        int count = 0;
        for (Direction d : Direction.values()) {
            BlockPos toCheck = fuelCellPos.m_121945_(d);
            if (!this.isModerator(toCheck)) continue;
            this.addIfNotExists(toCheck.m_121878_(), this.moderators);
            this.addDirectFuelCellConnection(toCheck);
            ++count;
        }
        return count;
    }

    private void indexInnerBlocks() {
        BlockPos thePos = this.initialPos().copy();
        NuclearCraft.debugLog("height=" + this.height + " width=" + this.width + " depth=" + this.depth);
        for (int y = 1; y < this.height - 1; ++y) {
            for (int x = 1; x < this.width - 1; ++x) {
                for (int z = 1; z < this.depth - 1; ++z) {
                    switch (this.getControllerDirection().ordinal()) {
                        case 3: {
                            thePos = this.initialPos().copy().m_122030_(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z);
                            break;
                        }
                        case 5: {
                            thePos = this.initialPos().copy().m_122013_(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z);
                            break;
                        }
                        case 2: {
                            thePos = this.initialPos().copy().m_122025_(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z);
                            break;
                        }
                        case 4: {
                            thePos = this.initialPos().copy().m_122020_(x - this.leftCasing).m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z);
                        }
                    }
                    if (this.processInnerBlock(thePos)) continue;
                    this.validationResult = ValidationResult.WRONG_INNER;
                    this.errorBlockPos = new BlockPos((Vec3i)thePos);
                    return;
                }
            }
        }
        this.validationResult = ValidationResult.VALID;
        this.errorBlockPos = null;
    }

    @Override
    protected FissionControllerBE controllerBE() {
        if (this.controllerBe == null) {
            this.controllerBe = this.controller().controllerBE();
        }
        return (FissionControllerBE)this.controllerBe;
    }

    @Override
    protected boolean processInnerBlock(BlockPos toCheck) {
        this.addIfNotExists(toCheck, (HashSet<Long>)this.allBlocks);
        BlockState bs = this.getBlockState(toCheck);
        if (this.isFuelCell(bs)) {
            this.addDirectFuelCellConnection(new BlockPos((Vec3i)toCheck));
            this.addIfNotExists(toCheck, this.fuelCells);
            return true;
        }
        if (this.isModerator(bs)) {
            this.addIfNotExists(toCheck, this.allModerators);
            return true;
        }
        if (this.isHeatSink(bs)) {
            String name = String.valueOf(ForgeRegistries.BLOCKS.getKey((Object)bs.m_60734_()));
            this.indexedHeatSinks.computeIfAbsent(name, k -> new HashSet()).add(toCheck);
            this.reversedIndexedHeatSinks.put(toCheck, name);
            this.addIfNotExists(toCheck, this.allHeatSinks);
            return true;
        }
        if (this.isIrradiator(toCheck)) {
            this.addIfNotExists(toCheck, this.irradiators);
            return true;
        }
        return this.isValidForInner(bs);
    }

    private void addSecondConnectionsToFuelCell(BlockPos toCheck) {
        this.addIfNotExists(toCheck, this.secondFuelCellConnectionPos);
        for (Direction d : Direction.values()) {
            this.addIfNotExists(toCheck.m_121945_(d), this.secondFuelCellConnectionPos);
        }
    }

    private void removeSecondConnectionsToFuelCell(BlockPos toCheck) {
        this.secondFuelCellConnectionPos.remove(toCheck.m_121878_());
        for (Direction d : Direction.values()) {
            this.secondFuelCellConnectionPos.remove(toCheck.m_121945_(d).m_121878_());
        }
    }

    private void addDirectFuelCellConnection(BlockPos toCheck) {
        this.addIfNotExists(toCheck, this.directFuelCellConnectionPos);
        for (Direction d : Direction.values()) {
            this.addIfNotExists(toCheck.m_121945_(d), this.directFuelCellConnectionPos);
        }
    }

    @Override
    public boolean checkAttachmentToBlock(Class<?> toCheck, Level level, BlockPos pos, Direction dir) {
        pos = pos.m_121945_(dir);
        if (this.getBottomLeftBlock().m_123341_() >= pos.m_123341_() && this.getBottomLeftBlock().m_123342_() >= pos.m_123341_() && this.getBottomLeftBlock().m_123343_() >= pos.m_123343_() && this.getTopRightBlock().m_123341_() <= pos.m_123341_() && this.getTopRightBlock().m_123342_() <= pos.m_123342_() && this.getTopRightBlock().m_123343_() <= pos.m_123343_() && !this.allBlocks.contains(pos.m_121878_())) {
            return false;
        }
        if (toCheck.equals(FissionFuelCellBlock.class)) {
            return this.directFuelCellConnectionPos.contains(pos.m_121878_()) || this.secondFuelCellConnectionPos.contains(pos.m_121878_()) && !this.getBlockState(pos).m_60795_();
        }
        return false;
    }

    private int countAdjacentFuelCells(BlockPos toCheck) {
        int count = 0;
        block0: for (Direction d : Direction.values()) {
            for (int l = 1; l < 5; ++l) {
                BlockState blockState = this.getBlockState(toCheck.m_5484_(d, l));
                if (this.isFuelCell(blockState)) {
                    ++count;
                    continue block0;
                }
                if (!this.isModerator(blockState)) continue block0;
                if (!this.isFuelCell(toCheck.m_5484_(d, l + 1))) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    @Override
    public void removeFromCacheIfChanged(BlockPos pos) {
        BlockEntity be;
        long packedPos = pos.m_121878_();
        if (this.beCache.containsKey(packedPos) && ((be = this.getLevel().getExistingBlockEntity(pos)) != this.beCache.get(packedPos) || be != null && be.m_58901_())) {
            this.beCache.remove(packedPos);
        }
        if (this.bsCache.containsKey(packedPos)) {
            BlockState bs = this.getLevel().m_8055_(pos);
            BlockState cachedState = (BlockState)this.bsCache.get(packedPos);
            if (cachedState == null || !bs.m_60713_(((BlockState)this.bsCache.get(packedPos)).m_60734_())) {
                this.bsCache.remove(packedPos);
                this.moderators.remove(packedPos);
                for (Direction dir : Direction.values()) {
                    long pPos = pos.m_121945_(dir).m_121878_();
                    this.moderators.remove(pPos);
                    this.allModerators.remove(pPos);
                    this.directFuelCellConnectionPos.remove(pPos);
                    this.secondFuelCellConnectionPos.remove(pPos);
                }
                String posHeatSink = this.reversedIndexedHeatSinks.get(pos);
                this.reversedIndexedHeatSinks.remove(pos);
                this.indexedHeatSinks.get(posHeatSink).remove(pos);
                if (this.indexedHeatSinks.get(posHeatSink).isEmpty()) {
                    this.indexedHeatSinks.remove(posHeatSink);
                }
                this.activeHeatSinks.remove(packedPos);
                this.allModerators.remove(packedPos);
                this.allHeatSinks.remove(packedPos);
                this.fuelCells.remove(packedPos);
                this.irradiators.remove(packedPos);
                this.validIrradiators.remove(packedPos);
                this.directFuelCellConnectionPos.remove(packedPos);
                this.secondFuelCellConnectionPos.remove(packedPos);
            }
        }
    }

    @Override
    public void clearStats() {
        this.controller().clearStats();
        this.controllerBE().fuelCellsCount = 0;
        this.controllerBE().extraFuelCells = 0;
        this.controllerBE().moderatorAttachments = 0;
        this.controllerBE().moderatorsCount = 0;
        this.controllerBE().allModerators = 0;
        this.controllerBE().allIrradiators = 0;
        this.controllerBE().irradiationLines = 0;
        this.controllerBE().validIrradiators = 0;
        this.controllerBE().heatSinksCount = 0;
        this.controllerBE().allHeatSinks = 0;
        this.controllerBE().activeCoolingHeatsinks = 0;
        this.controllerBE().connectedPorts = 0;
        this.controllerBE().moderatorsHeatMult = 0.0;
        this.controllerBE().cellsEnergyMult = 0.0;
        this.controllerBE().moderatorsEnergyMult = 0.0;
        this.controllerBE().cellsHeatMult = 0.0;
        this.controllerBE().bottomLeft = BlockPos.f_121853_;
        this.controllerBE().topRight = BlockPos.f_121853_;
        this.controllerBE().m_6596_();
    }

    @Override
    protected Direction getControllerDirection() {
        return this.controllerBE().getFacing();
    }

    public double countCooling(boolean forceCheck) {
        if (forceCheck) {
            this.heatSinkCooling = 0.0;
            for (HeatSinkBlock hs : this.validHeatSinks.values()) {
                this.heatSinkCooling += hs.heat;
            }
        }
        return this.heatSinkCooling;
    }
}

