/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.fusion;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.ElectromagnetBlock;
import igentuman.nc.block.RFAmplifierBlock;
import igentuman.nc.block.fusion.FusionConnectorBlock;
import igentuman.nc.block.fusion.entity.FusionCoreBE;
import igentuman.nc.handler.config.FusionConfig;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.fusion.FusionReactorController;
import igentuman.nc.multiblock.fusion.FusionReactorRegistration;
import igentuman.nc.util.BlockPosInstance;
import igentuman.nc.util.TagUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class FusionReactorMultiblock
extends AbstractMultiblock {
    protected int magnetsEfficiency = 0;
    protected int rfEfficiency = 0;
    protected FusionCoreBE controllerBE;
    protected int length = 0;
    protected double magneticFieldStrength = 0.0;
    protected int magnetsPower = 0;
    protected int maxMagnetsTemp = 0;
    protected int rfAmplification = 0;
    protected int rfAmplifiersPower = 0;
    protected int maxRFAmplifiersTemp = 0;
    protected boolean connectorsValid = false;
    protected boolean ringValid = false;
    protected int connectorsCount = 0;
    protected int casingBlocks = 0;
    protected final HashMap<Long, ElectromagnetBlock> electromagnets = new HashMap();
    protected final HashMap<Long, RFAmplifierBlock> amplifiers = new HashMap();

    public FusionReactorMultiblock(FusionCoreBE core) {
        super(TagUtil.getBlocksByTagKey(FusionReactorRegistration.CASING_BLOCKS.f_203868_().toString()), new HashSet<Block>(List.of(Blocks.f_50016_)), new FusionReactorController(core));
        this.controllerBE = core;
        this.id = "fusion_reactor_" + this.controllerBE.m_58899_().m_123344_();
        MultiblockHandler.get((ResourceKey<Level>)core.m_58904_().m_46472_()).addMultiblock(this, true);
    }

    @Override
    public int height() {
        return 3;
    }

    @Override
    public int width() {
        return this.length;
    }

    @Override
    public int depth() {
        return this.length;
    }

    @Override
    public int maxHeight() {
        return 3;
    }

    @Override
    public int minHeight() {
        return 3;
    }

    @Override
    public int maxWidth() {
        return (Integer)FusionConfig.FUSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int minWidth() {
        return (Integer)FusionConfig.FUSION_CONFIG.MIN_SIZE.get();
    }

    @Override
    public int maxDepth() {
        return (Integer)FusionConfig.FUSION_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int minDepth() {
        return (Integer)FusionConfig.FUSION_CONFIG.MIN_SIZE.get();
    }

    @Override
    public final HashSet<Block> validOuterBlocks() {
        return this.validOuterBlocks;
    }

    @Override
    public HashSet<Block> validInnerBlocks() {
        return this.validInnerBlocks;
    }

    @Override
    protected FusionCoreBE controllerBE() {
        if (this.controllerBe == null) {
            this.controllerBe = this.controller().controllerBE();
        }
        return (FusionCoreBE)this.controllerBe;
    }

    public boolean updateCharacteristics() {
        boolean hasChanges = this.controllerBE().magneticFieldStrength != this.magneticFieldStrength || this.controllerBE().rfEfficiency != this.rfEfficiency || this.controllerBE().magnetsEfficiency != this.magnetsEfficiency || this.controllerBE().maxMagnetsTemp != this.maxMagnetsTemp || (double)this.controllerBE().rfAmplification != (double)this.rfAmplification * this.controllerBE().rfAmplifierRatio() || (double)this.controllerBE().rfAmplifiersPower != (double)this.rfAmplifiersPower * this.controllerBE().rfAmplifierRatio() || this.controllerBE().minRFAmplifiersTemp != this.maxRFAmplifiersTemp;
        this.controllerBE().rfEfficiency = this.rfEfficiency;
        this.controllerBE().amplifiers = this.amplifiers.size();
        this.controllerBE().magnetsEfficiency = this.magnetsEfficiency;
        this.controllerBE().magneticFieldStrength = this.magneticFieldStrength;
        this.controllerBE().magnetsPower = this.magnetsPower;
        this.controllerBE().maxMagnetsTemp = this.maxMagnetsTemp;
        this.controllerBE().rfAmplification = (int)((double)this.rfAmplification * this.controllerBE().rfAmplifierRatio());
        this.controllerBE().rfAmplifiersPower = (int)((double)this.rfAmplifiersPower * this.controllerBE().rfAmplifierRatio());
        this.controllerBE().minRFAmplifiersTemp = this.maxRFAmplifiersTemp;
        this.controllerBE().connectors = this.connectorsCount;
        this.controllerBE().magnets = this.electromagnets.size();
        this.controllerBE().amplifiers = this.amplifiers.size();
        this.controllerBE().casingBlocks = this.casingBlocks;
        this.controllerBE().size = this.length;
        if (hasChanges) {
            this.controllerBE().currentRfAmplification = this.rfAmplification;
            this.controllerBE.m_6596_();
        }
        return hasChanges;
    }

    @Override
    public void validateOuter() {
        NuclearCraft.debugLog("Starting fusion reactor outer validation");
        this.resolveDimensions();
        NuclearCraft.debugLog("Resolved fusion reactor dimensions - Length: " + this.length);
        if (!this.validationResult.isValid) {
            NuclearCraft.debugLog("Dimension resolution failed with result: " + this.validationResult);
            this.clearStats();
            return;
        }
        NuclearCraft.debugLog("Validating fusion reactor ring structure");
        this.validateRing();
        NuclearCraft.debugLog("Ring validation - Ring valid: " + this.ringValid + ", Connectors valid: " + this.connectorsValid + ", Connectors count: " + this.connectorsCount + ", Casing blocks: " + this.casingBlocks);
        if (!this.validationResult.isValid) {
            NuclearCraft.debugLog("Ring validation failed with result: " + this.validationResult);
            this.clearStats();
            return;
        }
        boolean bl = this.outerValid = this.ringValid && this.connectorsValid;
        if (this.outerValid) {
            this.validationResult = ValidationResult.VALID;
            NuclearCraft.debugLog("Fusion reactor outer validation completed successfully");
        } else {
            NuclearCraft.debugLog("Fusion reactor outer validation failed - Ring valid: " + this.ringValid + ", Connectors valid: " + this.connectorsValid);
        }
    }

    @Override
    public void validate() {
        NuclearCraft.debugLog("=== Starting Fusion Reactor validation at " + this.controllerPos.m_123344_() + " ===");
        NuclearCraft.debugLog("Target length: " + this.length);
        super.validate();
        NuclearCraft.debugLog("Handling potential meltdown conditions");
        this.handleMeltdown();
        NuclearCraft.debugLog("Collecting functional parts (electromagnets and RF amplifiers)");
        this.collectFunctionalParts();
        NuclearCraft.debugLog("Found " + this.electromagnets.size() + " electromagnets and " + this.amplifiers.size() + " RF amplifiers");
        NuclearCraft.debugLog("Recalculating fusion reactor characteristics");
        this.recalculateCharacteristics();
        NuclearCraft.debugLog("Magnetic field strength: " + String.format("%.2f", this.magneticFieldStrength) + ", RF efficiency: " + this.rfEfficiency + ", Magnets efficiency: " + this.magnetsEfficiency);
        boolean hasChanges = this.updateCharacteristics();
        NuclearCraft.debugLog("Updated controller characteristics - Changes detected: " + hasChanges);
        if (this.validationResult.isValid) {
            this.errorBlockPos = BlockPos.f_121853_;
            NuclearCraft.debugLog("Fusion reactor validation completed successfully");
        } else {
            NuclearCraft.debugLog("Fusion reactor validation failed with result: " + this.validationResult);
        }
    }

    private void handleMeltdown() {
        if (!this.validationResult.isValid && this.controllerBE().plasmaTemperature > 100000L) {
            this.controllerBE().plasmaTemperature = 0L;
            this.getLevel().m_255391_(null, (double)this.errorBlockPos.m_123341_(), (double)this.errorBlockPos.m_123342_(), (double)this.errorBlockPos.m_123343_(), 2.0f, true, Level.ExplosionInteraction.TNT);
        }
    }

    private void processFunctionalBlock(BlockPosInstance pos) {
        Block block = this.getBlock(pos);
        if (block instanceof ElectromagnetBlock) {
            ElectromagnetBlock magnet = (ElectromagnetBlock)block;
            this.electromagnets.put(pos.m_121878_(), magnet);
            this.addIfNotExists(pos, (HashSet<Long>)this.allBlocks);
        } else {
            block = this.getBlock(pos);
            if (block instanceof RFAmplifierBlock) {
                RFAmplifierBlock amplifier = (RFAmplifierBlock)block;
                this.amplifiers.put(pos.m_121878_(), amplifier);
                this.addIfNotExists(pos, (HashSet<Long>)this.allBlocks);
            }
        }
    }

    public void collectFunctionalParts() {
        this.electromagnets.clear();
        this.amplifiers.clear();
        BlockPosInstance pos = new BlockPosInstance((Vec3i)this.controllerBE.m_58899_());
        Iterator<Direction> iterator = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST).iterator();
        while (iterator.hasNext()) {
            int i;
            Direction side;
            Direction dir = side = iterator.next();
            int steps = this.length * 2 + 3;
            int shift = this.length + 1;
            BlockPosInstance startPosInnerWall = null;
            BlockPosInstance startPosOuterWall = null;
            switch (side) {
                case NORTH: {
                    dir = Direction.EAST;
                    startPosInnerWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.NORTH, shift).relative(Direction.WEST, shift));
                    startPosOuterWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.NORTH, 2 + shift).relative(Direction.WEST, 1 + shift));
                    break;
                }
                case SOUTH: {
                    dir = Direction.WEST;
                    startPosInnerWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.SOUTH, shift).relative(Direction.EAST, shift));
                    startPosOuterWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.SOUTH, 2 + shift).relative(Direction.EAST, 1 + shift));
                    break;
                }
                case WEST: {
                    dir = Direction.SOUTH;
                    startPosInnerWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.WEST, shift).relative(Direction.NORTH, shift));
                    startPosOuterWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.WEST, 2 + shift).relative(Direction.NORTH, 1 + shift));
                    break;
                }
                case EAST: {
                    dir = Direction.NORTH;
                    startPosInnerWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.EAST, shift).relative(Direction.SOUTH, shift));
                    startPosOuterWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.EAST, 2 + shift).relative(Direction.SOUTH, 1 + shift));
                }
            }
            if (startPosInnerWall == null || startPosOuterWall == null) {
                return;
            }
            for (i = 0; i < steps; ++i) {
                this.processFunctionalBlock(startPosInnerWall.revert().relative(dir, i));
                this.processFunctionalBlock(startPosInnerWall.revert().relative(Direction.UP, 2).relative(dir, i));
            }
            for (i = 0; i < steps + 2; ++i) {
                this.processFunctionalBlock(startPosOuterWall.revert().relative(dir, i));
                this.processFunctionalBlock(startPosOuterWall.revert().relative(Direction.UP, 2).relative(dir, i));
            }
        }
    }

    private void validateRing() {
        this.casingBlocks = 0;
        this.validationResult = ValidationResult.VALID;
        BlockPosInstance pos = new BlockPosInstance((Vec3i)this.controllerBE.m_58899_().m_121945_(Direction.UP));
        this.ringValid = true;
        Iterator<Direction> iterator = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST).iterator();
        while (iterator.hasNext()) {
            int i;
            Direction side;
            Direction dir = side = iterator.next();
            int steps = this.length * 2 + 3;
            int shift = this.length + 1;
            BlockPosInstance startPosInnerWall = null;
            BlockPosInstance startPosOuterWall = null;
            BlockPosInstance startPosBottomWall = null;
            BlockPosInstance startPosTopWall = null;
            switch (side) {
                case NORTH: {
                    dir = Direction.EAST;
                    startPosInnerWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.NORTH, shift).relative(Direction.WEST, shift));
                    startPosOuterWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.NORTH, 2 + shift).relative(Direction.WEST, 1 + shift));
                    startPosBottomWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.NORTH, 1 + shift).relative(Direction.WEST, 1 + shift).relative(Direction.DOWN));
                    startPosTopWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.NORTH, 1 + shift).relative(Direction.WEST, 1 + shift).relative(Direction.UP));
                    break;
                }
                case SOUTH: {
                    dir = Direction.WEST;
                    startPosInnerWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.SOUTH, shift).relative(Direction.EAST, shift));
                    startPosOuterWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.SOUTH, 2 + shift).relative(Direction.EAST, 1 + shift));
                    startPosBottomWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.SOUTH, 1 + shift).relative(Direction.EAST, 1 + shift).relative(Direction.DOWN));
                    startPosTopWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.SOUTH, 1 + shift).relative(Direction.EAST, 1 + shift).relative(Direction.UP));
                    break;
                }
                case WEST: {
                    dir = Direction.SOUTH;
                    startPosInnerWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.WEST, shift).relative(Direction.NORTH, shift));
                    startPosOuterWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.WEST, 2 + shift).relative(Direction.NORTH, 1 + shift));
                    startPosBottomWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.WEST, 1 + shift).relative(Direction.NORTH, 1 + shift).relative(Direction.DOWN));
                    startPosTopWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.WEST, 1 + shift).relative(Direction.NORTH, 1 + shift).relative(Direction.UP));
                    break;
                }
                case EAST: {
                    dir = Direction.NORTH;
                    startPosInnerWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.EAST, shift).relative(Direction.SOUTH, shift));
                    startPosOuterWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.EAST, 2 + shift).relative(Direction.SOUTH, 1 + shift));
                    startPosBottomWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.EAST, 1 + shift).relative(Direction.SOUTH, 1 + shift).relative(Direction.DOWN));
                    startPosTopWall = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.EAST, 1 + shift).relative(Direction.SOUTH, 1 + shift).relative(Direction.UP));
                }
            }
            for (i = 0; i < steps; ++i) {
                assert (startPosInnerWall != null);
                if (this.isValidForOuter(startPosInnerWall.revert().relative(dir, i))) {
                    this.addIfNotExists(startPosInnerWall, (HashSet<Long>)this.allBlocks);
                    ++this.casingBlocks;
                    continue;
                }
                this.ringValid = false;
                this.validationResult = ValidationResult.WRONG_OUTER;
                if (this.casingBlocks > 0 || this.length > 1) {
                    this.errorBlockPos = new BlockPos((Vec3i)startPosInnerWall);
                }
                return;
            }
            for (i = 0; i < steps + 2; ++i) {
                assert (startPosOuterWall != null);
                if (this.isValidForOuter(startPosOuterWall.revert().relative(dir, i))) {
                    this.addIfNotExists(startPosOuterWall, (HashSet<Long>)this.allBlocks);
                    ++this.casingBlocks;
                } else {
                    this.ringValid = false;
                    this.validationResult = ValidationResult.WRONG_OUTER;
                    this.errorBlockPos = new BlockPos((Vec3i)startPosOuterWall);
                    return;
                }
                assert (startPosBottomWall != null);
                if (this.isValidForOuter(startPosBottomWall.revert().relative(dir, i))) {
                    this.addIfNotExists(startPosBottomWall, (HashSet<Long>)this.allBlocks);
                    ++this.casingBlocks;
                } else {
                    this.ringValid = false;
                    this.validationResult = ValidationResult.WRONG_OUTER;
                    this.errorBlockPos = new BlockPos((Vec3i)startPosBottomWall);
                    return;
                }
                assert (startPosTopWall != null);
                if (this.isValidForOuter(startPosTopWall.revert().relative(dir, i))) {
                    this.addIfNotExists(startPosTopWall, (HashSet<Long>)this.allBlocks);
                    ++this.casingBlocks;
                    continue;
                }
                this.ringValid = false;
                this.validationResult = ValidationResult.WRONG_OUTER;
                this.errorBlockPos = new BlockPos((Vec3i)startPosTopWall);
                return;
            }
        }
    }

    private void validateConnectors() {
        this.validationResult = ValidationResult.VALID;
        BlockPosInstance pos = new BlockPosInstance((Vec3i)this.controllerBE().m_58899_().m_7494_());
        this.connectorsCount = 0;
        this.length = 1;
        this.connectorsValid = true;
        BlockPos possibleErrorPos = BlockPos.f_121853_;
        for (int i = 2; i <= this.maxWidth() / 2 + 1; ++i) {
            int connectors = 0;
            for (Direction side : List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST)) {
                if (this.getBlockState(pos.revert().relative(side, i), true).m_60734_() instanceof FusionConnectorBlock) {
                    this.addIfNotExists(pos, (HashSet<Long>)this.allBlocks);
                    ++this.connectorsCount;
                    ++connectors;
                    continue;
                }
                possibleErrorPos = new BlockPos((Vec3i)pos);
            }
            if (connectors == 4) {
                ++this.length;
                continue;
            }
            if (connectors != 0) {
                this.connectorsValid = false;
                this.errorBlockPos = possibleErrorPos;
                this.validationResult = ValidationResult.INCOMPLETE;
            } else {
                this.connectorsValid = true;
            }
            return;
        }
    }

    @Override
    public void validateInner() {
        if (!this.outerValid) {
            return;
        }
        BlockPosInstance pos = new BlockPosInstance((Vec3i)this.controllerBE.m_58899_().m_121945_(Direction.UP));
        this.innerValid = true;
        Iterator<Direction> iterator = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST).iterator();
        while (iterator.hasNext()) {
            Direction side;
            Direction dir = side = iterator.next();
            int steps = this.length * 2 + 3;
            int shift = this.length + 2;
            BlockPosInstance innerRingStartPos = null;
            Level level = this.controllerBE.m_58904_();
            switch (side) {
                case NORTH: {
                    dir = Direction.EAST;
                    innerRingStartPos = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.NORTH, shift).relative(Direction.WEST, shift));
                    break;
                }
                case SOUTH: {
                    dir = Direction.WEST;
                    innerRingStartPos = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.SOUTH, shift).relative(Direction.EAST, shift));
                    break;
                }
                case WEST: {
                    dir = Direction.SOUTH;
                    innerRingStartPos = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.WEST, shift).relative(Direction.NORTH, shift));
                    break;
                }
                case EAST: {
                    dir = Direction.NORTH;
                    innerRingStartPos = new BlockPosInstance((Vec3i)pos.revert().relative(Direction.EAST, shift).relative(Direction.SOUTH, shift));
                }
            }
            for (int i = 0; i < steps; ++i) {
                assert (innerRingStartPos != null);
                if (this.processInnerBlock(innerRingStartPos.revert().relative(dir, i))) continue;
                this.innerValid = false;
                this.validationResult = ValidationResult.WRONG_INNER;
                this.errorBlockPos = new BlockPos((Vec3i)innerRingStartPos);
                return;
            }
        }
        this.validationResult = ValidationResult.VALID;
    }

    @Override
    protected boolean processInnerBlock(BlockPos toCheck) {
        return this.validInnerBlocks.contains(this.getBlockState(toCheck).m_60734_());
    }

    @Override
    public void clearStats() {
        this.length = 0;
        this.controller().clearStats();
        this.isFormed = false;
    }

    @Override
    protected Direction getControllerDirection() {
        return Direction.UP;
    }

    @Override
    public void tick(Level level) {
        super.tick(level);
        if (this.isFormed) {
            // empty if block
        }
    }

    @Override
    public void resolveDimensions() {
        this.validateConnectors();
        this.topRight = BlockPosInstance.of(this.validationResult.isValid ? this.controllerBE.m_58899_().m_5484_(Direction.UP, 2).m_5484_(Direction.EAST, this.length + 3).m_5484_(Direction.SOUTH, this.length + 3) : BlockPos.f_121853_);
        this.bottomLeft = BlockPosInstance.of(this.validationResult.isValid ? this.controllerBE.m_58899_().m_5484_(Direction.WEST, this.length + 3).m_5484_(Direction.NORTH, this.length + 3) : BlockPos.f_121853_);
    }

    public void recalculateCharacteristics() {
        this.magneticFieldStrength = 0.0;
        this.magnetsPower = 0;
        this.maxMagnetsTemp = 1000000;
        this.rfAmplification = 0;
        this.rfAmplifiersPower = 0;
        this.maxRFAmplifiersTemp = 1000000;
        double mEfficiency = 0.0;
        double rEfficiency = 0.0;
        for (ElectromagnetBlock magnet : this.electromagnets.values()) {
            this.magneticFieldStrength += magnet.getStrength();
            mEfficiency += (double)((int)magnet.getEfficiency());
            this.magnetsPower += magnet.getPower();
            if (magnet.getMaxTemperature() >= this.maxMagnetsTemp) continue;
            this.maxMagnetsTemp = magnet.getMaxTemperature();
        }
        this.magnetsEfficiency = (int)(mEfficiency / (double)this.electromagnets.size());
        for (RFAmplifierBlock amplifier : this.amplifiers.values()) {
            this.rfAmplification += amplifier.getAmplification();
            this.rfAmplifiersPower += amplifier.getPower();
            rEfficiency += (double)((int)amplifier.getEfficiency());
            if (amplifier.getMaxTemperature() >= this.maxRFAmplifiersTemp) continue;
            this.maxRFAmplifiersTemp = amplifier.getMaxTemperature();
        }
        this.rfEfficiency = (int)(rEfficiency / (double)this.amplifiers.size());
    }
}

