/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.kugelblitz;

import igentuman.nc.block.kugelblitz.BlackHoleBlock;
import igentuman.nc.block.kugelblitz.ChamberBlock;
import igentuman.nc.block.kugelblitz.ChamberPortBlock;
import igentuman.nc.block.kugelblitz.ChamberTerminalBlock;
import igentuman.nc.block.kugelblitz.EXPLBlock;
import igentuman.nc.block.kugelblitz.EXPLProxyBlock;
import igentuman.nc.block.kugelblitz.PhotonConcentratorBlock;
import igentuman.nc.block.kugelblitz.entity.BlackHoleBE;
import igentuman.nc.block.kugelblitz.entity.ChamberPortBE;
import igentuman.nc.block.kugelblitz.entity.ChamberTerminalBE;
import igentuman.nc.block.kugelblitz.entity.EXPLBE;
import igentuman.nc.block.kugelblitz.entity.EXPLProxyBE;
import igentuman.nc.block.kugelblitz.entity.PhotonConcentratorBE;
import igentuman.nc.container.ChamberPortContainer;
import igentuman.nc.container.ChamberTerminalContainer;
import igentuman.nc.container.EXPLContainer;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.setup.registration.Tags;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.RegistryObject;

public class KugelblitzRegistration {
    public static final Pattern TRANSPARENT_BLOCKS_PATTERN = Pattern.compile(".*(glass|photon|transformer|stabilizer).*");
    public static final BlockBehaviour.Properties NO_OCCLUSION_BLOCK_PROPS = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(3.0f).m_60999_().m_60955_();
    public static final Item.Properties KUGELBLITZ_ITEM_PROPERTIES = new Item.Properties();
    public static final BlockBehaviour.Properties KUGELBLITZ_BLOCK_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(4.0f).m_60999_();
    public static final HashMap<String, RegistryObject<BlockEntityType<? extends BlockEntity>>> KUGELBLITZ_BE = new HashMap();
    public static final HashMap<String, RegistryObject<Item>> KUGELBLITZ_ITEMS = new HashMap();
    public static final HashMap<String, RegistryObject<Block>> KUGELBLITZ_BLOCKS = new HashMap();
    public static final TagKey<Block> CASING_BLOCKS = Tags.blockTag("kugelblitz_casing");
    public static final TagKey<Item> CASING_ITEMS = Tags.itemTag("kugelblitz_casing");
    public static final RegistryObject<Block> EXPL_PROXY_BLOCK = Registries.BLOCKS.register("expl_proxy_block", () -> new EXPLProxyBlock(NO_OCCLUSION_BLOCK_PROPS));
    public static final RegistryObject<BlockEntityType<? extends BlockEntity>> EXPL_PROXY_BE = Registries.BLOCK_ENTITIES.register("expl_proxy", () -> BlockEntityType.Builder.m_155273_(EXPLProxyBE::new, (Block[])new Block[]{(Block)EXPL_PROXY_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<Block> EXPL_BLOCK = Registries.BLOCKS.register("expl", () -> new EXPLBlock(NO_OCCLUSION_BLOCK_PROPS));
    public static final RegistryObject<BlockEntityType<? extends BlockEntity>> EXPL_BE = Registries.BLOCK_ENTITIES.register("expl", () -> BlockEntityType.Builder.m_155273_(EXPLBE::new, (Block[])new Block[]{(Block)EXPL_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<Item> EXPL_ITEM = Registries.ITEMS.register("expl", () -> new BlockItem((Block)EXPL_BLOCK.get(), KUGELBLITZ_ITEM_PROPERTIES));
    public static final RegistryObject<MenuType<EXPLContainer>> EXPL_CONTAINER = Registries.CONTAINERS.register("expl", () -> IForgeMenuType.create((windowId, inv, data) -> new EXPLContainer(windowId, data.m_130135_(), inv)));
    public static final RegistryObject<MenuType<ChamberTerminalContainer>> CHAMBER_TERMINAL_CONTAINER = Registries.CONTAINERS.register("chamber_terminal", () -> IForgeMenuType.create((windowId, inv, data) -> new ChamberTerminalContainer(windowId, data.m_130135_(), inv)));
    public static final RegistryObject<MenuType<ChamberPortContainer>> CHAMBER_PORT_CONTAINER = Registries.CONTAINERS.register("chamber_port", () -> IForgeMenuType.create((windowId, inv, data) -> new ChamberPortContainer(windowId, data.m_130135_(), inv)));

    public static void init() {
        KugelblitzRegistration.registerSimpleBlock("neutronium_frame");
        KugelblitzRegistration.registerSimpleBlock("event_horizon_stabilizer");
        KugelblitzRegistration.registerSimpleBlock("quantum_flux_regulator");
        KugelblitzRegistration.registerSimpleBlock("quantum_transformer");
        KUGELBLITZ_BLOCKS.put("photon_concentrator", (RegistryObject<Block>)Registries.BLOCKS.register("photon_concentrator", () -> new PhotonConcentratorBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56744_).m_60978_(1.0f).m_60999_().m_60955_())));
        KUGELBLITZ_ITEMS.put("photon_concentrator", KugelblitzRegistration.fromMultiblock(KUGELBLITZ_BLOCKS.get("photon_concentrator")));
        KUGELBLITZ_BE.put("photon_concentrator", (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register("photon_concentrator", () -> BlockEntityType.Builder.m_155273_(PhotonConcentratorBE::new, (Block[])new Block[]{(Block)KUGELBLITZ_BLOCKS.get("photon_concentrator").get()}).m_58966_(null)));
        KUGELBLITZ_BLOCKS.put("chamber_port", (RegistryObject<Block>)Registries.BLOCKS.register("chamber_port", () -> new ChamberPortBlock(KUGELBLITZ_BLOCK_PROPERTIES)));
        KUGELBLITZ_ITEMS.put("chamber_port", KugelblitzRegistration.fromMultiblock(KUGELBLITZ_BLOCKS.get("chamber_port")));
        NCItems.ALL_NC_ITEMS.put("chamber_port", KUGELBLITZ_ITEMS.get("chamber_port"));
        KUGELBLITZ_BE.put("chamber_port", (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register("chamber_port", () -> BlockEntityType.Builder.m_155273_(ChamberPortBE::new, (Block[])new Block[]{(Block)KUGELBLITZ_BLOCKS.get("chamber_port").get()}).m_58966_(null)));
        KUGELBLITZ_BLOCKS.put("chamber_terminal", (RegistryObject<Block>)Registries.BLOCKS.register("chamber_terminal", () -> new ChamberTerminalBlock(KUGELBLITZ_BLOCK_PROPERTIES)));
        KUGELBLITZ_ITEMS.put("chamber_terminal", KugelblitzRegistration.fromMultiblock(KUGELBLITZ_BLOCKS.get("chamber_terminal")));
        NCItems.ALL_NC_ITEMS.put("chamber_terminal", KUGELBLITZ_ITEMS.get("chamber_terminal"));
        KUGELBLITZ_BE.put("chamber_terminal", (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register("chamber_terminal", () -> BlockEntityType.Builder.m_155273_(ChamberTerminalBE::new, (Block[])new Block[]{(Block)KUGELBLITZ_BLOCKS.get("chamber_terminal").get()}).m_58966_(null)));
        KUGELBLITZ_BLOCKS.put("black_hole", (RegistryObject<Block>)Registries.BLOCKS.register("black_hole", () -> new BlackHoleBlock(KUGELBLITZ_BLOCK_PROPERTIES)));
        KUGELBLITZ_ITEMS.put("black_hole", KugelblitzRegistration.fromMultiblock(KUGELBLITZ_BLOCKS.get("black_hole")));
        NCItems.ALL_NC_ITEMS.put("black_hole", KUGELBLITZ_ITEMS.get("black_hole"));
        KUGELBLITZ_BE.put("black_hole", (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register("black_hole", () -> BlockEntityType.Builder.m_155273_(BlackHoleBE::new, (Block[])new Block[]{(Block)KUGELBLITZ_BLOCKS.get("black_hole").get()}).m_58966_(null)));
    }

    private static void registerSimpleBlock(String key) {
        BlockBehaviour.Properties props = TRANSPARENT_BLOCKS_PATTERN.matcher(key).matches() ? BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56744_).m_60978_(1.0f).m_60999_().m_60955_() : KUGELBLITZ_BLOCK_PROPERTIES;
        KUGELBLITZ_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new ChamberBlock(props)));
        KUGELBLITZ_ITEMS.put(key, KugelblitzRegistration.fromMultiblock(KUGELBLITZ_BLOCKS.get(key)));
        NCItems.ALL_NC_ITEMS.put(key, KUGELBLITZ_ITEMS.get(key));
    }

    public static <B extends Block> RegistryObject<Item> fromMultiblock(RegistryObject<B> block) {
        return Registries.ITEMS.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), KUGELBLITZ_ITEM_PROPERTIES));
    }
}

