/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.radiation;

import igentuman.nc.handler.config.RadiationConfig;
import igentuman.nc.util.NcUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemShielding {
    protected static final HashMap<Item, Integer> shieldingItems = new HashMap();
    protected static boolean initialized = false;

    public static HashMap<Item, Integer> get() {
        return shieldingItems;
    }

    public static void init() {
        if (!shieldingItems.isEmpty()) {
            return;
        }
        for (String line : (List)RadiationConfig.RADIATION_CONFIG.ARMOR_PROTECTION.get()) {
            Item item;
            String[] split = line.split("\\|");
            if (split.length != 2 || (item = ItemShielding.getItemByName(split[0].trim())).equals(Items.f_41852_)) continue;
            try {
                shieldingItems.put(item, Integer.parseInt(split[1].trim()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static void add(String item, int radiation) {
        Item toAdd = ItemShielding.getItemByName(item);
        if (toAdd.equals(Items.f_41852_)) {
            return;
        }
        shieldingItems.put(toAdd, radiation);
    }

    public static void add(Item item, int radiation) {
        shieldingItems.put(item, radiation);
    }

    protected static Item getItemByName(String name) {
        if (!((String)name).contains(":")) {
            name = "nuclearcraft:" + (String)name;
        }
        ResourceLocation itemKey = NcUtils.rlFromString(((String)name).replace("/", "_"));
        return (Item)ForgeRegistries.ITEMS.getValue(itemKey);
    }

    public static int byItem(Item item) {
        if (!initialized) {
            ItemShielding.init();
            initialized = true;
        }
        if (shieldingItems.containsKey(item)) {
            return shieldingItems.get(item);
        }
        return 0;
    }
}

