/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.radiation.data;

import igentuman.nc.content.NCRadiationDamageSource;
import igentuman.nc.handler.config.RadiationConfig;
import igentuman.nc.radiation.ItemRadiation;
import igentuman.nc.radiation.ItemShielding;
import igentuman.nc.radiation.data.IPlayerRadiationCapability;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.radiation.data.WorldRadiation;
import igentuman.nc.setup.Registration;
import igentuman.nc.util.NcUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PlayerRadiation
implements IPlayerRadiationCapability {
    private final double decaySpeed;
    public Level level;
    private long radiation;
    private int timestamp;
    private int contaminationStage;
    public static long maxPlayerRadiation = 500000000L;
    public List<MobEffectInstance> contaminationEffects;

    public PlayerRadiation() {
        this.decaySpeed = ((Integer)RadiationConfig.RADIATION_CONFIG.DECAY_SPEED_FOR_PLAYER.get()).intValue();
        this.radiation = 0L;
        this.timestamp = 0;
        this.contaminationStage = 0;
        this.contaminationEffects = new LinkedList<MobEffectInstance>();
    }

    public static PlayerRadiation deserialize(CompoundTag radiation) {
        PlayerRadiation playerRadiation = new PlayerRadiation();
        playerRadiation.deserializeNBT(radiation);
        return playerRadiation;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("radiation", this.radiation);
        tag.m_128405_("timestamp", this.timestamp);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.radiation = nbt.m_128454_("radiation");
        this.timestamp = nbt.m_128451_("timestamp");
    }

    public void copyFrom(PlayerRadiation source) {
        this.radiation = source.radiation;
        this.timestamp = source.timestamp;
    }

    public int getInventoryRadiation(Player player) {
        long rad = 0L;
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            rad += (long)((int)(ItemRadiation.byItem(itemStack.m_41720_()) * 1000000.0 * (double)(itemStack.m_41613_() + 1) * 0.75));
        }
        return Math.toIntExact(Math.min(rad / 5L, Integer.MAX_VALUE));
    }

    public static int getRadiationShielding(LivingEntity player, String ... modFilter) {
        int shielding = 0;
        for (ItemStack stack : player.m_6168_()) {
            if (stack.m_41619_()) continue;
            if (modFilter.length > 0) {
                String stackMod = NcUtils.getModId(stack);
                boolean hasMod = false;
                for (String mod : modFilter) {
                    if (!stackMod.equals(mod)) continue;
                    hasMod = true;
                    break;
                }
                if (!hasMod) continue;
            }
            shielding += ItemShielding.byItem(stack.m_41720_());
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("rad_shielding")) continue;
            shielding += stack.m_41783_().m_128451_("rad_shielding");
        }
        if (player.m_21023_((MobEffect)Registration.RADIATION_RESISTANCE.get())) {
            int resistance = player.m_21124_((MobEffect)Registration.RADIATION_RESISTANCE.get()).m_19564_() + 1;
            shielding += resistance * 2;
        }
        return shielding;
    }

    public void updateRadiation(Level level, LivingEntity player) {
        this.level = level;
        WorldRadiation worldRadiation = RadiationManager.get(level).getWorldRadiation();
        int chunkRadiation = worldRadiation.getChunkRadiation(player.m_146902_().f_45578_, player.m_146902_().f_45579_);
        double intensityMult = Math.max(0.5, Math.sqrt((double)chunkRadiation / 1000000.0));
        double shieldingRate = Math.max(0.001, 0.7 - (double)PlayerRadiation.getRadiationShielding(player, new String[0]) / 100.0);
        long wasRadiation = this.radiation;
        if ((long)chunkRadiation < this.radiation) {
            intensityMult *= 0.5;
        }
        this.radiation = (int)((double)chunkRadiation * intensityMult * (Double)RadiationConfig.RADIATION_CONFIG.GAIN_SPEED_FOR_PLAYER.get() * shieldingRate + (double)this.radiation);
        if (player instanceof Player) {
            this.radiation += (long)((int)((double)this.getInventoryRadiation((Player)player) * shieldingRate));
        }
        this.radiation = (wasRadiation + this.radiation) / 2L;
        this.radiation -= (long)((int)this.decaySpeed);
        this.radiation = Math.min(maxPlayerRadiation, Math.max(0L, this.radiation));
        assert (player instanceof Player);
        this.updateContaminationStage((Player)player);
    }

    public void updateContaminationStage(Player player) {
        if (this.radiation >= maxPlayerRadiation) {
            player.m_6469_(NCRadiationDamageSource.RADIATION((ServerPlayer)player), 1000000.0f);
            return;
        }
        if ((double)this.radiation >= (double)maxPlayerRadiation * 0.66) {
            this.setContaminationStage(3, player);
            return;
        }
        if ((double)this.radiation >= (double)maxPlayerRadiation * 0.44) {
            this.setContaminationStage(2, player);
            return;
        }
        if ((double)this.radiation >= (double)maxPlayerRadiation * 0.22) {
            this.setContaminationStage(1, player);
            return;
        }
        this.setContaminationStage(0, player);
    }

    private void setContaminationStage(int i, Player player) {
        if (player.m_7500_()) {
            return;
        }
        this.contaminationStage = i;
        for (MobEffectInstance effect : this.contaminationEffects) {
            player.m_21195_(effect.m_19544_());
        }
        this.contaminationEffects.clear();
        switch (this.contaminationStage) {
            case 3: {
                this.contaminationEffects.add(new MobEffectInstance(MobEffects.f_19613_, 900000, 3));
                this.contaminationEffects.add(new MobEffectInstance(MobEffects.f_19604_, 900000, 2));
                this.contaminationEffects.add(new MobEffectInstance(MobEffects.f_19619_, 900000));
                this.contaminationEffects.add(new MobEffectInstance(MobEffects.f_19590_, 900000));
                this.contaminationEffects.add(new MobEffectInstance(MobEffects.f_19614_, 900000));
                this.contaminationEffects.add(new MobEffectInstance(MobEffects.f_19610_, 900000));
                break;
            }
            case 2: {
                this.contaminationEffects.add(new MobEffectInstance(MobEffects.f_19613_, 900000, 2));
                this.contaminationEffects.add(new MobEffectInstance(MobEffects.f_19604_, 900000));
                this.contaminationEffects.add(new MobEffectInstance(MobEffects.f_19619_, 900000));
                this.contaminationEffects.add(new MobEffectInstance(MobEffects.f_19590_, 900000));
                this.contaminationEffects.add(new MobEffectInstance(MobEffects.f_19614_, 900000));
                break;
            }
            case 1: {
                this.contaminationEffects.add(new MobEffectInstance(MobEffects.f_19613_, 90000));
                this.contaminationEffects.add(new MobEffectInstance(MobEffects.f_19590_, 90000));
            }
        }
        for (MobEffectInstance effect : this.contaminationEffects) {
            player.m_7292_(effect);
        }
    }

    @Override
    public long getRadiation() {
        return this.radiation;
    }

    @Override
    public void setRadiation(long radiation) {
        this.radiation = radiation;
    }

    @Override
    public int getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }
}

