/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.serializers;

import com.google.gson.JsonObject;
import igentuman.nc.NuclearCraft;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import igentuman.nc.recipes.serializers.NcRecipeSerializer;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.recipes.type.TargetChamberRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public class TargetChamberSerializer<RECIPE extends TargetChamberRecipe>
extends NcRecipeSerializer<RECIPE> {
    final ITargetChamberFactory<RECIPE> targetChamberFactory;

    public TargetChamberSerializer(ITargetChamberFactory<RECIPE> factory) {
        super(factory);
        this.targetChamberFactory = factory;
    }

    @Override
    @NotNull
    public RECIPE fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        String type = GsonHelper.m_13906_((JsonObject)json, (String)"type");
        ParticleStack[] inputParticles = this.particleStacksFromJson(json, "inputParticles", recipeId);
        ParticleStack[] outputParticles = this.particleStacksFromJson(json, "outputParticles", recipeId);
        ItemStackIngredient[] inputItems = this.inputItemsFromJson(json, recipeId);
        ItemStackIngredient[] outputItems = this.outputItemsFromJson(json, recipeId);
        FluidStackIngredient[] inputFluids = this.inputFluidsFromJson(json, recipeId);
        FluidStackIngredient[] outputFluids = this.outputFluidsFromJson(json, recipeId);
        long maxEnergy = GsonHelper.m_13828_((JsonObject)json, (String)"maxEnergy", (long)Long.MAX_VALUE);
        double crossSection = GsonHelper.m_144742_((JsonObject)json, (String)"crossSection", (double)5.0);
        return (RECIPE)((TargetChamberRecipe)this.targetChamberFactory.make(recipeId, inputItems, outputItems, inputFluids, outputFluids, inputParticles, outputParticles, maxEnergy, crossSection));
    }

    public ParticleStack[] readParticles(@NotNull FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ParticleStack[] items = new ParticleStack[size];
        for (int i = 0; i < size; ++i) {
            items[i] = ParticleStack.readBuffer(buffer);
        }
        return items;
    }

    @Override
    public ItemStackIngredient[] readItems(@NotNull FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ItemStackIngredient[] items = new ItemStackIngredient[size];
        for (int i = 0; i < size; ++i) {
            items[i] = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        }
        return items;
    }

    @Override
    public FluidStackIngredient[] readFluids(@NotNull FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        FluidStackIngredient[] fluids = new FluidStackIngredient[size];
        for (int i = 0; i < size; ++i) {
            fluids[i] = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
        }
        return fluids;
    }

    @Override
    public RECIPE fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient[] inputItems = this.readItems(buffer);
            ItemStackIngredient[] outputItems = this.readItems(buffer);
            FluidStackIngredient[] inputFluids = this.readFluids(buffer);
            FluidStackIngredient[] outputFluids = this.readFluids(buffer);
            ParticleStack[] inputParticles = this.readParticles(buffer);
            ParticleStack[] outputParticles = this.readParticles(buffer);
            long maxEnergy = buffer.readLong();
            double crossSection = buffer.readDouble();
            return (RECIPE)((TargetChamberRecipe)this.targetChamberFactory.make(recipeId, inputItems, outputItems, inputFluids, outputFluids, inputParticles, outputParticles, maxEnergy, crossSection));
        }
        catch (Exception e) {
            NuclearCraft.debugLog("Error reading recipe {} from packet. Trace: {} " + recipeId + e);
            NuclearCraft.debugLog("Return empty recipe for: {}" + recipeId);
            return (RECIPE)((TargetChamberRecipe)this.emptyRecipe(recipeId));
        }
    }

    @Override
    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        try {
            ((TargetChamberRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            NuclearCraft.debugLog("Error writing recipe to packet." + e);
            throw e;
        }
    }

    public static interface ITargetChamberFactory<RECIPE extends NcRecipe>
    extends NcRecipeSerializer.IFactory<RECIPE> {
        @Override
        default public RECIPE create(ResourceLocation id, ItemStackIngredient[] inputItems, ItemStackIngredient[] outputItems, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeMultiplier, double powerMultiplier, double radiationMultiplier, double rarityMultiplier) {
            throw new UnsupportedOperationException("TargetChamberFactory should use make() method instead of create()");
        }

        public RECIPE make(ResourceLocation var1, ItemStackIngredient[] var2, ItemStackIngredient[] var3, FluidStackIngredient[] var4, FluidStackIngredient[] var5, ParticleStack[] var6, ParticleStack[] var7, long var8, double var10);
    }
}

