/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.setup;

import igentuman.nc.NuclearCraft;
import igentuman.nc.content.particles.Particles;
import igentuman.nc.handler.event.server.PlayerEvents;
import igentuman.nc.radiation.data.RadiationEvents;
import igentuman.nc.setup.registration.Entities;
import igentuman.nc.setup.registration.GameEvents;
import igentuman.nc.util.GTCEUCompatibilityCondition;
import igentuman.nc.util.WastelandEnabledCondition;
import igentuman.nc.util.insitu_leaching.WorldVeinsProvider;
import igentuman.nc.world.structure.ScientistHouseStructure;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="nuclearcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModSetup {
    public static void setup() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(RadiationEvents::onPlayerCloned);
        Particles.init();
        bus.addGenericListener(Entity.class, RadiationEvents::attachPlayerRadiation);
        bus.addGenericListener(Level.class, RadiationEvents::attachWorldRadiation);
        bus.addGenericListener(Level.class, WorldVeinsProvider::attachVeinCapability);
        bus.register((Object)NuclearCraft.worldTickHandler);
        bus.register((Object)new PlayerEvents());
        bus.register((Object)new RadiationEvents());
        bus.register((Object)new ScientistHouseStructure());
    }

    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CraftingHelper.register((IConditionSerializer)new WastelandEnabledCondition.Serializer());
            CraftingHelper.register((IConditionSerializer)new GTCEUCompatibilityCondition.Serializer());
            Entities.registerSpawnPlacements();
            GameEvents.commonSetup();
        });
        NuclearCraft.packetHandler().initialize();
    }
}

