/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import igentuman.nc.NuclearCraft;
import igentuman.nc.handler.config.MaterialsConfig;
import igentuman.nc.multiblock.fission.FissionReactorRegistration;
import igentuman.nc.multiblock.fusion.FusionReactorRegistration;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.setup.registration.NCEnergyBlocks;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.NCProcessors;
import igentuman.nc.util.math.FloatingLong;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NcUtils {
    public static final float ONE_OVER_ROOT_TWO = (float)(1.0 / Math.sqrt(2.0));
    private static final List<UUID> warnedFails = new ArrayList<UUID>();
    public static List<HashMap<String, RegistryObject<Item>>> ALL_ITEMS = List.of(NCItems.NC_ITEMS, NCItems.NC_PARTS, NCItems.NC_GEMS, NCItems.NC_INGOTS, NCItems.NC_DUSTS, NCItems.NC_NUGGETS, NCItems.ALL_NC_ITEMS);
    public static List<HashMap<String, RegistryObject<Block>>> ALL_BLOCKS = List.of(NCBlocks.NC_BLOCKS, FissionReactorRegistration.FISSION_BLOCKS, FusionReactorRegistration.FUSION_BLOCKS, NCProcessors.PROCESSORS, NCEnergyBlocks.ENERGY_BLOCKS, NCBlocks.ORE_BLOCKS, TurbineRegistration.TURBINE_BLOCKS);

    public static ResourceLocation getName(ParticleType<?> element) {
        return NcUtils.getName(ForgeRegistries.PARTICLE_TYPES, element);
    }

    public static ResourceLocation rlFromString(String name) {
        return ResourceLocation.m_135820_((String)name);
    }

    public static ResourceLocation getName(Item element) {
        return NcUtils.getName(ForgeRegistries.ITEMS, element);
    }

    public static ResourceLocation getName(Fluid element) {
        return NcUtils.getName(ForgeRegistries.FLUIDS, element);
    }

    private static <T> ResourceLocation getName(IForgeRegistry<T> registry, T element) {
        return registry.getKey(element);
    }

    public static String getPath(Item element) {
        return NcUtils.getName(element).m_135815_();
    }

    public static ResourceLocation getName(Block element) {
        return NcUtils.getName(ForgeRegistries.BLOCKS, element);
    }

    public static String getNamespace(Block element) {
        return NcUtils.getName(element).m_135827_();
    }

    public static ResourceLocation getName(MenuType<?> element) {
        return NcUtils.getName(ForgeRegistries.MENU_TYPES, element);
    }

    @NotNull
    public static String getModId(@NotNull ItemStack stack) {
        try {
            String mod = ((ResourceKey)stack.m_220173_().m_203439_().left().get()).m_135782_().m_135827_();
            if (mod != null && !mod.isEmpty()) {
                return mod;
            }
        }
        catch (Exception mod) {
            // empty catch block
        }
        Item item = stack.m_41720_();
        String modid = item.getCreatorModId(stack);
        if (modid == null) {
            ResourceLocation registryName = NcUtils.getName(item);
            if (registryName == null) {
                NuclearCraft.debugLog("Unexpected null registry name for item of class type: {}" + item.getClass().getSimpleName());
                return "";
            }
            return registryName.m_135827_();
        }
        return modid;
    }

    public static ItemStack getItemStackByModPriority(ItemStackIngredient item) {
        if (item.getRepresentations().size() == 1) {
            return (ItemStack)item.getRepresentations().get(0);
        }
        for (String mod : (List)MaterialsConfig.MATERIAL_PRODUCTS.MODS_PRIORITY.get()) {
            for (ItemStack i : item.getRepresentations()) {
                if (!NcUtils.getModId(i).equals(mod)) continue;
                return i;
            }
        }
        return (ItemStack)item.getRepresentations().get(0);
    }

    @NotNull
    public static String getModId(@NotNull FluidStack stack) {
        Fluid fluid = stack.getFluid();
        String modid = "";
        try {
            modid = ForgeRegistries.FLUIDS.getKey((Object)fluid).m_135827_();
        }
        catch (Exception e) {
            return "";
        }
        return modid;
    }

    public static ItemStack getItemInHand(LivingEntity entity, HumanoidArm side) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return NcUtils.getItemInHand(player, side);
        }
        if (side == HumanoidArm.RIGHT) {
            return entity.m_21205_();
        }
        return entity.m_21206_();
    }

    public static ItemStack getItemInHand(Player player, HumanoidArm side) {
        if (player.m_5737_() == side) {
            return player.m_21205_();
        }
        return player.m_21206_();
    }

    public static int redstoneLevelFromContents(long amount, long capacity) {
        double fractionFull = capacity == 0L ? 0.0 : (double)amount / (double)capacity;
        return Mth.m_14143_((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }

    public static int redstoneLevelFromContents(FloatingLong amount, FloatingLong capacity) {
        if (capacity.isZero() || amount.isZero()) {
            return 0;
        }
        return 1 + amount.divide(capacity).multiply(14L).intValue();
    }

    public static boolean isPlayingMode(Player player) {
        return !player.m_7500_() && !player.m_5833_();
    }

    public static List<String> getParameterNames(@Nullable JsonObject classMethods, String method, String signature) {
        JsonElement params;
        JsonObject signatures;
        if (classMethods != null && (signatures = classMethods.getAsJsonObject(method)) != null && (params = signatures.get(signature)) != null) {
            if (params.isJsonArray()) {
                JsonArray paramArray = params.getAsJsonArray();
                ArrayList<String> paramNames = new ArrayList<String>(paramArray.size());
                for (JsonElement param : paramArray) {
                    paramNames.add(param.getAsString());
                }
                return Collections.unmodifiableList(paramNames);
            }
            return Collections.singletonList(params.getAsString());
        }
        return Collections.emptyList();
    }

    public static Block getNCBlock(String name) {
        for (HashMap<String, RegistryObject<Block>> map : ALL_BLOCKS) {
            if (!map.containsKey(name)) continue;
            return (Block)map.get(name).get();
        }
        if (NCBlocks.NC_MATERIAL_BLOCKS.containsKey(name)) {
            return (Block)NCBlocks.NC_MATERIAL_BLOCKS.get(name).get();
        }
        return Blocks.f_50016_;
    }

    public static Item getNCItem(String name) {
        for (HashMap<String, RegistryObject<Item>> map : ALL_ITEMS) {
            if (!map.containsKey(name)) continue;
            return (Item)map.get(name).get();
        }
        return Items.f_41852_;
    }
}

