/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util;

import igentuman.nc.NuclearCraft;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class RadiationExecutorManager {
    private static ThreadPoolExecutor executor;
    private static final int MAX_THREAD_COUNT;
    private static final int CORE_THREAD_COUNT;
    private static final int MAX_QUEUE_SIZE = 1000;
    private static final ThreadFactory threadFactory;

    public static synchronized ExecutorService getExecutor() {
        if (executor == null || executor.isShutdown() || executor.isTerminated()) {
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(1000);
            executor = new ThreadPoolExecutor(CORE_THREAD_COUNT, MAX_THREAD_COUNT, 60L, TimeUnit.SECONDS, workQueue, threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
            executor.prestartAllCoreThreads();
            executor.setRejectedExecutionHandler((r, e) -> {
                NuclearCraft.debugLog("Warning: Radiation task queue is full! Running task in main thread.");
                if (!e.isShutdown()) {
                    r.run();
                }
            });
        }
        return executor;
    }

    public static int getQueueSize() {
        return executor != null ? executor.getQueue().size() : 0;
    }

    public static int getActiveThreadCount() {
        return executor != null ? executor.getActiveCount() : 0;
    }

    public static synchronized void shutdown() {
        if (executor != null && !executor.isShutdown()) {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        MAX_THREAD_COUNT = Math.max(2, Runtime.getRuntime().availableProcessors() / 2);
        CORE_THREAD_COUNT = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        threadFactory = new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "NCN-Radiation-" + this.threadNumber.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        };
    }
}

