/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util.math;

import java.util.List;

public class MathUtils {
    private static final long UNSIGNED_MASK = Long.MAX_VALUE;

    private MathUtils() {
    }

    public static long clamp(long num, long min, long max) {
        return num < min ? min : Math.min(num, max);
    }

    public static int clampToInt(double d) {
        if (d < 2.147483647E9) {
            return (int)d;
        }
        return Integer.MAX_VALUE;
    }

    public static int clampToInt(long l) {
        if (l < Integer.MAX_VALUE) {
            return (int)l;
        }
        return Integer.MAX_VALUE;
    }

    public static long clampToLong(double d) {
        if (d < 9.223372036854776E18) {
            return (long)d;
        }
        return Long.MAX_VALUE;
    }

    public static int clampUnsignedToInt(long l) {
        if (l < 0L || l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public static long clampUnsignedToLong(long l) {
        return l < 0L ? Long.MAX_VALUE : l;
    }

    public static float unsignedLongToFloat(long l) {
        float fValue = l & Long.MAX_VALUE;
        if (l < 0L) {
            fValue += 9.223372E18f;
        }
        return fValue;
    }

    public static double unsignedLongToDouble(long l) {
        double dValue = l & Long.MAX_VALUE;
        if (l < 0L) {
            dValue += 9.223372036854776E18;
        }
        return dValue;
    }

    public static <TYPE> TYPE getByIndexMod(TYPE[] elements, int index) {
        if (index < 0) {
            return elements[Math.floorMod(index, elements.length)];
        }
        return elements[index % elements.length];
    }

    public static <TYPE> TYPE getByIndexMod(List<TYPE> elements, int index) {
        if (index < 0) {
            return elements.get(Math.floorMod(index, elements.size()));
        }
        return elements.get(index % elements.size());
    }

    public static int min(int ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("Values cannot be null or empty");
        }
        int min = values[0];
        for (int value : values) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public static int max(int ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("Values cannot be null or empty");
        }
        int max = values[0];
        for (int value : values) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }
}

