/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world;

import igentuman.nc.NuclearCraft;
import igentuman.nc.content.materials.Ores;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.world.ore.NCOre;
import igentuman.nc.world.structure.WastelandBossLairFeature;
import igentuman.nc.world.structure.WastelandPortalFeature;
import igentuman.nc.world.structure.WastelandStructureFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.registries.RegistryObject;

public class NCConfiguredFeatures {
    public static final HashMap<String, ResourceKey<ConfiguredFeature<?, ?>>> CONFIGURED_FEATURES = NCConfiguredFeatures.initFeatures();
    public static final RegistryObject<ConfiguredFeature<?, ?>> CONFIGURED_WASTELAND_RUINS = Registries.CONFIGURED.register("wasteland_ruins", () -> new ConfiguredFeature((Feature)WastelandStructureFeature.WASTELAND_RUINS_FEATURE.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));

    private static HashMap<String, ResourceKey<ConfiguredFeature<?, ?>>> initFeatures() {
        HashMap features = new HashMap();
        for (String name : Ores.all().keySet()) {
            features.put(name, NCConfiguredFeatures.registerKey(name + "_ore"));
            features.put(name + "_wasteland", NCConfiguredFeatures.registerKey(name + "_wasteland_ore"));
        }
        for (String name : List.of("uranium", "thorium")) {
            features.put(name + "_additional_wasteland", NCConfiguredFeatures.registerKey(name + "_additional_wasteland_ore"));
        }
        features.put("glowing_mushroom", NCConfiguredFeatures.registerKey("glowing_mushroom_feature"));
        features.put("glowing_mushroom_wasteland", NCConfiguredFeatures.registerKey("glowing_mushroom_wasteland_feature"));
        features.put("wasteland_ruins", NCConfiguredFeatures.registerKey("wasteland_ruins"));
        features.put("wasteland_surface", NCConfiguredFeatures.registerKey("wasteland_surface"));
        features.put("wasteland_portal", NCConfiguredFeatures.registerKey("wasteland_portal"));
        features.put("wasteland_boss_lair", NCConfiguredFeatures.registerKey("wasteland_boss_lair"));
        return features;
    }

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        NCOre ore;
        TagMatchTest stoneReplaceable = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.f_144267_);
        BlockMatchTest netherrackReplacables = new BlockMatchTest(Blocks.f_50134_);
        BlockMatchTest endReplaceables = new BlockMatchTest(Blocks.f_50259_);
        for (String name : Ores.registered().keySet()) {
            ore = Ores.all().get(name);
            if (ore.dimensions.contains("minecraft:overworld")) {
                ArrayList<OreConfiguration.TargetBlockState> overworld = new ArrayList<OreConfiguration.TargetBlockState>();
                if (ore.config().height[1] > 0) {
                    overworld.add(OreConfiguration.m_161021_((RuleTest)stoneReplaceable, (BlockState)Ores.all().get(name).block().m_49966_()));
                    overworld.add(OreConfiguration.m_161021_((RuleTest)netherrackReplacables, (BlockState)Ores.all().get(name).block().m_49966_()));
                    overworld.add(OreConfiguration.m_161021_((RuleTest)endReplaceables, (BlockState)Ores.all().get(name).block().m_49966_()));
                }
                if (ore.config().height[0] < 0) {
                    overworld.add(OreConfiguration.m_161021_((RuleTest)deepslateReplaceables, (BlockState)ore.block("_deepslate").m_49966_()));
                }
                NCConfiguredFeatures.register(context, CONFIGURED_FEATURES.get(name), Feature.f_65731_, new OreConfiguration(overworld, 9));
                if (ore.config().dimensions.contains("nuclearcraft:wasteland")) {
                    NCConfiguredFeatures.register(context, CONFIGURED_FEATURES.get(name + "_wasteland"), Feature.f_65731_, new OreConfiguration(overworld, 2));
                }
            }
            if (ore.config().dimensions.contains("minecraft:nether")) {
                NCConfiguredFeatures.register(context, CONFIGURED_FEATURES.get(name), Feature.f_65731_, new OreConfiguration((RuleTest)netherrackReplacables, ore.block().m_49966_(), 9));
            }
            if (!ore.config().dimensions.contains("minecraft:the_end")) continue;
            NCConfiguredFeatures.register(context, CONFIGURED_FEATURES.get(name), Feature.f_65731_, new OreConfiguration((RuleTest)endReplaceables, ore.block().m_49966_(), 9));
        }
        for (String name : List.of("uranium", "thorium")) {
            ore = Ores.all().get(name);
            NCConfiguredFeatures.register(context, CONFIGURED_FEATURES.get(name + "_additional_wasteland"), Feature.f_65731_, new OreConfiguration((RuleTest)stoneReplaceable, ore.block().m_49966_(), 9));
        }
        NCConfiguredFeatures.register(context, CONFIGURED_FEATURES.get("glowing_mushroom"), Feature.f_65763_, FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)NCBlocks.MUSHROOM_BLOCK.get()))), List.of(Blocks.f_50136_, Blocks.f_50135_, Blocks.f_50141_)));
        NCConfiguredFeatures.register(context, CONFIGURED_FEATURES.get("glowing_mushroom_wasteland"), Feature.f_65763_, FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)NCBlocks.MUSHROOM_BLOCK.get()))), List.of((Block)NCBlocks.WASTELAND_EARTH.get())));
        NCConfiguredFeatures.register(context, CONFIGURED_FEATURES.get("wasteland_ruins"), (Feature)WastelandStructureFeature.WASTELAND_RUINS_FEATURE.get(), new NoneFeatureConfiguration());
        NCConfiguredFeatures.register(context, CONFIGURED_FEATURES.get("wasteland_portal"), (Feature)WastelandPortalFeature.WASTELAND_PORTAL_FEATURE.get(), new NoneFeatureConfiguration());
        NCConfiguredFeatures.register(context, CONFIGURED_FEATURES.get("wasteland_boss_lair"), (Feature)WastelandBossLairFeature.WASTELAND_BOSS_LAIR_FEATURE.get(), new NoneFeatureConfiguration());
        NCConfiguredFeatures.register(context, CONFIGURED_FEATURES.get("wasteland_surface"), Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)NCBlocks.WASTELAND_EARTH.get()))));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)net.minecraft.core.registries.Registries.f_256911_, (ResourceLocation)NuclearCraft.rl(name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

