/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world;

import com.mojang.serialization.Codec;
import igentuman.nc.handler.config.OreGenConfig;
import igentuman.nc.setup.registration.WorldGeneration;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.jetbrains.annotations.NotNull;

public class OrePlacementModifier
extends PlacementModifier {
    public static final Codec<OrePlacementModifier> CODEC = Codec.STRING.fieldOf("name").xmap(OrePlacementModifier::new, modifier -> modifier.name).codec();
    private final String name;
    private boolean register;
    private int amount;
    private int minHeight;
    private int maxHeight;
    private List<String> dims;
    private HashMap<ResourceKey<Level>, Boolean> dimsCache = new HashMap();

    public OrePlacementModifier(String name) {
        this.name = name;
        try {
            this.register = (Boolean)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).register.get();
            this.amount = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).veinSize.get();
            this.minHeight = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).min_height.get();
            this.maxHeight = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).max_height.get();
            this.dims = (List)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).dimensions.get();
        }
        catch (Exception e) {
            this.register = (Boolean)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).register.getDefault();
            this.amount = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).veinSize.getDefault();
            this.minHeight = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).min_height.getDefault();
            this.maxHeight = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).max_height.getDefault();
            this.dims = (List)OreGenConfig.ORE_CONFIG.ORES.get((Object)name).dimensions.getDefault();
        }
        if (!this.register) {
            this.amount = 0;
        }
    }

    @NotNull
    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)WorldGeneration.NC_ORE_MODIFIER.get();
    }

    @NotNull
    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
        int actualCount = this.determinePlacementCount(context, random);
        int x = (pos.m_123341_() >> 4 << 4) + random.m_188503_(16);
        int z = (pos.m_123343_() >> 4 << 4) + random.m_188503_(16);
        if (actualCount == 0) {
            return Stream.empty();
        }
        return Stream.generate(() -> new BlockPos(x, this.minHeight + random.m_188503_(this.maxHeight - Math.max(this.minHeight, context.m_142201_()) + 1), z)).limit(actualCount);
    }

    private int determinePlacementCount(PlacementContext context, RandomSource random) {
        try {
            WorldGenLevel level = context.m_191831_();
            int veinSize = this.amount;
            if (!this.canPlace(level)) {
                return 0;
            }
            return random.m_188503_(veinSize);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private boolean canPlace(WorldGenLevel level) {
        if (this.dimsCache.containsKey(level.m_6018_().m_46472_())) {
            return this.dimsCache.get(level.m_6018_().m_46472_());
        }
        for (String dim : this.dims) {
            if (level.m_6018_().m_46472_().m_135782_().toString().equals(dim)) {
                this.dimsCache.put((ResourceKey<Level>)level.m_6018_().m_46472_(), true);
                return true;
            }
            this.dimsCache.put((ResourceKey<Level>)level.m_6018_().m_46472_(), false);
        }
        return false;
    }
}

